/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bpel.core.annotations.AnnotationListener;
import org.netbeans.modules.bpel.core.annotations.AnnotationManagerCookie;
import org.netbeans.modules.bpel.core.annotations.DiagramAnnotation;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.nodes.validation.ChangeValidationListener;
import org.netbeans.modules.bpel.nodes.validation.ChangeValidationSupport;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.soa.validation.core.Listener;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELExtensibilityComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProxyListener
implements Listener,
AnnotationListener {
    private Map<Component, Validator.ResultType> cachedResultMap = new HashMap<Component, Validator.ResultType>();
    private ChangeValidationSupport myValidationSupport;
    private Lookup myLookup;
    private Controller myValidationController;
    private AnnotationManagerCookie cookie;

    private ValidationProxyListener(Lookup lookup, Controller controller) {
        assert (lookup != null && controller != null);
        this.myLookup = lookup;
        this.myValidationController = controller;
        this.myValidationSupport = new ChangeValidationSupport();
        this.attachValidationController(this);
        this.subscribeOnAnnotationChanges();
        this.myValidationController.triggerValidation();
    }

    public static synchronized ValidationProxyListener getInstance(Lookup lookup) {
        if (lookup == null) {
            return null;
        }
        Controller controller = (Controller)lookup.lookup(Controller.class);
        if (controller == null) {
            return null;
        }
        return new ValidationProxyListener(lookup, controller);
    }

    protected void finalize() throws Throwable {
        this.detachValidationController(this);
        this.unSubscribeOnAnnotationChanges();
    }

    private Lookup getLookup() {
        return this.myLookup;
    }

    public void addChangeValidationListener(ChangeValidationListener changeValidationListener) {
        this.myValidationSupport.addChangeValidationListener(changeValidationListener);
    }

    public void removeChangeValidationListener(ChangeValidationListener changeValidationListener) {
        this.myValidationSupport.removeChangeValidationListener(changeValidationListener);
    }

    public synchronized void validationUpdated(List<Validator.ResultItem> list) {
        list = EditorUtil.filterBpelResultItems(list);
        Map<Component, Validator.ResultType> map = this.getComponentResultMap(list);
        Map<Component, Validator.ResultType> map2 = this.getRemovedComponentResultMap(this.cachedResultMap, map);
        Map<Component, Validator.ResultType> map3 = this.getChangedComponentResultMap(this.cachedResultMap, map);
        this.cachedResultMap = map;
        if (map2 != null && map2.size() > 0) {
            this.myValidationSupport.fireRemoveValidation(new ArrayList<Component>(map2.keySet()));
        }
        if (map3 != null && map3.size() > 0) {
            this.myValidationSupport.fireChangeValidation(map3);
        }
    }

    private Map<Component, Validator.ResultType> getRemovedComponentResultMap(Map<Component, Validator.ResultType> map, Map<Component, Validator.ResultType> map2) {
        if (map == null || map.size() < 1) {
            return null;
        }
        if (map2 == null || map2.size() < 1) {
            return map;
        }
        HashMap<Component, Validator.ResultType> hashMap = map == null ? null : new HashMap<Component, Validator.ResultType>(map);
        for (Component component : map2.keySet()) {
            hashMap.remove(component);
        }
        return hashMap;
    }

    private Map<Component, Validator.ResultType> getChangedComponentResultMap(Map<Component, Validator.ResultType> map, Map<Component, Validator.ResultType> map2) {
        if (map2 == null || map2.size() < 1) {
            return null;
        }
        if (map == null || map.size() < 1) {
            return map2;
        }
        HashMap<Component, Validator.ResultType> hashMap = new HashMap<Component, Validator.ResultType>();
        Validator.ResultType resultType = null;
        Validator.ResultType resultType2 = null;
        for (Component component : map2.keySet()) {
            resultType = map.get(component);
            resultType2 = map2.get(component);
            if (resultType2 == null || resultType2.equals((Object)resultType)) continue;
            hashMap.put(component, resultType2);
        }
        return hashMap;
    }

    public Validator.ResultType getValidationStatusForElement(Object object) {
        if (object == null || this.cachedResultMap == null || this.cachedResultMap.size() < 1) {
            return null;
        }
        for (Component component : this.cachedResultMap.keySet()) {
            if (!component.equals(object)) continue;
            return this.cachedResultMap.get(component);
        }
        return null;
    }

    private void attachValidationController(Listener listener) {
        this.myValidationController.addListener(listener);
    }

    private void detachValidationController(Listener listener) {
        this.myValidationController.removeListener(listener);
    }

    private void subscribeOnAnnotationChanges() {
        DataObject dataObject = (DataObject)this.myLookup.lookup(DataObject.class);
        if (dataObject != null) {
            this.cookie = (AnnotationManagerCookie)dataObject.getCookie(AnnotationManagerCookie.class);
        }
        this.cookie.addAnnotationListener((AnnotationListener)this);
    }

    private void unSubscribeOnAnnotationChanges() {
        this.cookie.removeAnnotationListener((AnnotationListener)this);
    }

    private Map<Component, Validator.ResultType> getComponentResultMap(List<Validator.ResultItem> list) {
        HashMap<Component, Validator.ResultType> hashMap = new HashMap<Component, Validator.ResultType>();
        if (list == null || list.size() < 1) {
            return hashMap;
        }
        Validator.ResultType resultType = null;
        Validator.ResultType resultType2 = null;
        boolean bl = true;
        for (Validator.ResultItem resultItem : list) {
            Component component = resultItem.getComponents();
            resultType = (Validator.ResultType)hashMap.get(component);
            resultType2 = resultItem.getType();
            if (resultType2 != null) {
                boolean bl2 = bl = !(resultType2 = ValidationProxyListener.getPriorytestType(resultType2, resultType)).equals((Object)resultType);
            }
            if (!bl) continue;
            hashMap.put(component, resultType2);
        }
        return hashMap;
    }

    public static Validator.ResultType getPriorytestType(List<Validator.ResultType> list) {
        assert (list != null);
        if (list.size() == 0) {
            return null;
        }
        Validator.ResultType resultType = null;
        resultType = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            resultType = ValidationProxyListener.getPriorytestType(resultType, list.get(i));
        }
        return resultType;
    }

    public static Validator.ResultType getPriorytestType(Validator.ResultType resultType, Validator.ResultType resultType2) {
        if (resultType == null && resultType2 == null) {
            return null;
        }
        if (resultType == Validator.ResultType.ERROR || resultType2 == Validator.ResultType.ERROR) {
            return Validator.ResultType.ERROR;
        }
        if (resultType == Validator.ResultType.WARNING || resultType2 == Validator.ResultType.WARNING) {
            return Validator.ResultType.WARNING;
        }
        return Validator.ResultType.ADVICE;
    }

    public static List<Validator.ResultItem> filterNavigatorRelatedResultItems(List<Validator.ResultItem> list) {
        ArrayList<Validator.ResultItem> arrayList = new ArrayList<Validator.ResultItem>();
        for (Validator.ResultItem resultItem : list) {
            Component component = resultItem.getComponents();
            if (!(component instanceof BpelEntity) && !(component instanceof BPELExtensibilityComponent)) continue;
            Validator.ResultItem resultItem2 = new Validator.ResultItem(resultItem.getValidator(), resultItem.getType(), component, resultItem.getDescription());
            arrayList.add(resultItem2);
        }
        return arrayList;
    }

    public void annotationAdded(DiagramAnnotation diagramAnnotation) {
        this.myValidationSupport.fireAddAnnotation(diagramAnnotation.getBpelEntityId(), diagramAnnotation.getAnnotationType());
    }

    public void annotationRemoved(DiagramAnnotation diagramAnnotation) {
        this.myValidationSupport.fireRemoveAnnotation(diagramAnnotation.getBpelEntityId(), diagramAnnotation.getAnnotationType());
    }

    public boolean getAnnotationStatusForElement(Object object) {
        if (!(object instanceof BpelEntity)) {
            return false;
        }
        DiagramAnnotation[] diagramAnnotationArray = this.cookie.getAnnotations(((BpelEntity)object).getUID());
        return diagramAnnotationArray != null && diagramAnnotationArray.length >= 1;
    }

    public String[] getAnnotationTypes(Object object) {
        if (!(object instanceof BpelEntity)) {
            return null;
        }
        DiagramAnnotation[] diagramAnnotationArray = this.cookie.getAnnotations(((BpelEntity)object).getUID());
        if (diagramAnnotationArray == null || diagramAnnotationArray.length < 1) {
            return null;
        }
        String[] stringArray = new String[diagramAnnotationArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = diagramAnnotationArray[i].getAnnotationType();
        }
        return stringArray;
    }
}

