/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.nodes.validation.ChangeValidationListener;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeValidationSupport {
    private Lock writeLock;
    private Lock readLock;
    private List<ChangeValidationListener> myListeners = new ArrayList<ChangeValidationListener>();

    public ChangeValidationSupport() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
        this.readLock = reentrantReadWriteLock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeValidationListener(ChangeValidationListener changeValidationListener) {
        assert (changeValidationListener != null) : "Try to add null listerner.";
        this.writeLock.lock();
        try {
            this.myListeners.add(changeValidationListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeValidationListener(ChangeValidationListener changeValidationListener) {
        assert (changeValidationListener != null) : "Try to remove null listerner.";
        this.writeLock.lock();
        try {
            this.myListeners.remove(changeValidationListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void fireChangeValidation(Map<Component, Validator.ResultType> map) {
        assert (map != null);
        for (Component component : map.keySet()) {
            this.fireChangeValidation(component, map.get(component));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoveValidation(List<Component> componentArray) {
        assert (componentArray != null);
        Component[] componentArray2 = new Component[componentArray.size()];
        Component[] componentArray3 = componentArray;
        synchronized (componentArray) {
            componentArray2 = componentArray.toArray(componentArray2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (Component component : componentArray2) {
                this.fireRemoveValidation(component);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeValidation(Component component, Validator.ResultType resultType) {
        ChangeValidationListener[] changeValidationListenerArray = null;
        this.readLock.lock();
        try {
            changeValidationListenerArray = this.myListeners.toArray(new ChangeValidationListener[this.myListeners.size()]);
        }
        finally {
            this.readLock.unlock();
        }
        for (ChangeValidationListener changeValidationListener : changeValidationListenerArray) {
            changeValidationListener.validationUpdated(component, resultType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoveValidation(Component component) {
        ChangeValidationListener[] changeValidationListenerArray = null;
        this.readLock.lock();
        try {
            changeValidationListenerArray = this.myListeners.toArray(new ChangeValidationListener[this.myListeners.size()]);
        }
        finally {
            this.readLock.unlock();
        }
        for (ChangeValidationListener changeValidationListener : changeValidationListenerArray) {
            changeValidationListener.validationRemoved(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAddAnnotation(UniqueId uniqueId, String string) {
        ChangeValidationListener[] changeValidationListenerArray = null;
        this.readLock.lock();
        try {
            changeValidationListenerArray = this.myListeners.toArray(new ChangeValidationListener[this.myListeners.size()]);
        }
        finally {
            this.readLock.unlock();
        }
        for (ChangeValidationListener changeValidationListener : changeValidationListenerArray) {
            changeValidationListener.annotationAdded(uniqueId, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoveAnnotation(UniqueId uniqueId, String string) {
        ChangeValidationListener[] changeValidationListenerArray = null;
        this.readLock.lock();
        try {
            changeValidationListenerArray = this.myListeners.toArray(new ChangeValidationListener[this.myListeners.size()]);
        }
        finally {
            this.readLock.unlock();
        }
        for (ChangeValidationListener changeValidationListener : changeValidationListenerArray) {
            changeValidationListener.annotationRemoved(uniqueId, string);
        }
    }
}

