/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.nodes.actions.GoToDiagrammAction;
import org.netbeans.modules.bpel.nodes.actions.GoToLoggingAction;
import org.netbeans.modules.bpel.nodes.actions.GoToSourceAction;
import org.netbeans.modules.bpel.nodes.actions.ShowBpelMapperAction;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToAction
extends BpelNodeAction {
    private static final long serialVersionUID = 1L;
    private static ActSubMenuModel model = new ActSubMenuModel(null);
    private static BpelNodeAction[] GO_TO_ACTIONS = new BpelNodeAction[]{(BpelNodeAction)SystemAction.get(GoToDiagrammAction.class), (BpelNodeAction)SystemAction.get(GoToSourceAction.class), (BpelNodeAction)SystemAction.get(ShowBpelMapperAction.class), (BpelNodeAction)SystemAction.get(GoToLoggingAction.class)};

    public static KeyStroke getKeyStroke(Class<? extends BpelNodeAction> clazz) {
        Object object;
        if (clazz == null) {
            return null;
        }
        SystemAction systemAction = SystemAction.get(clazz);
        KeyStroke keyStroke = null;
        if (systemAction != null && (object = systemAction.getValue("AcceleratorKey")) instanceof KeyStroke) {
            keyStroke = (KeyStroke)object;
        }
        return keyStroke;
    }

    @Override
    public final String getBundleName() {
        return NbBundle.getMessage(BpelNodeAction.class, (String)"CTL_GoToAction");
    }

    @Override
    public String getName() {
        return model.getCount() == 1 ? super.getName() + " " + model.getLabel(0) : super.getName();
    }

    public ActionType getType() {
        return ActionType.GO_TO;
    }

    @Override
    public boolean enable(Node[] nodeArray) {
        model = new ActSubMenuModel(nodeArray);
        return super.enable(nodeArray);
    }

    @Override
    public void performAction(Node[] nodeArray) {
        if (!this.enable(nodeArray)) {
            return;
        }
        GoToAction.performAction(nodeArray, 0);
    }

    private static final void performAction(Node[] nodeArray, int n) {
        BpelNodeAction[] bpelNodeActionArray = GoToAction.getGoToActions(nodeArray);
        if (bpelNodeActionArray == null || n < 0 || n > bpelNodeActionArray.length) {
            return;
        }
        GoToAction.performAction(nodeArray, (SystemAction)bpelNodeActionArray[n]);
    }

    private static final void performAction(Node[] nodeArray, SystemAction systemAction) {
        if (systemAction instanceof BpelNodeAction) {
            ((BpelNodeAction)systemAction).performAction(nodeArray);
        }
    }

    public static final BpelNodeAction[] getGoToActions(Node[] nodeArray) {
        ArrayList<BpelNodeAction> arrayList = new ArrayList<BpelNodeAction>();
        if (nodeArray != null && nodeArray.length > 0) {
            for (BpelNodeAction bpelNodeAction : GO_TO_ACTIONS) {
                if (!bpelNodeAction.enable(nodeArray)) continue;
                arrayList.add(bpelNodeAction);
            }
            return arrayList.toArray(new BpelNodeAction[arrayList.size()]);
        }
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)model, true);
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)model, false);
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    private static final BpelNodeAction[] getGoToActions() {
        return GO_TO_ACTIONS;
    }

    private static final Node[] getCurrentNodes() {
        return WindowManager.getDefault().getRegistry().getCurrentNodes();
    }

    @Override
    protected void performAction(BpelEntity[] bpelEntityArray) {
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static final long serialVersionUID = -4273674308662494596L;
        private Node[] nodes;

        ActSubMenuModel(Node[] nodeArray) {
            this.nodes = nodeArray;
        }

        private Node[] getNodes() {
            return this.nodes == null ? GoToAction.getCurrentNodes() : this.nodes;
        }

        public int getCount() {
            return GoToAction.getGoToActions(this.getNodes()).length;
        }

        public String getLabel(int n) {
            BpelNodeAction[] bpelNodeActionArray = GoToAction.getGoToActions(this.getNodes());
            if (bpelNodeActionArray != null && n >= 0 && n < bpelNodeActionArray.length) {
                return bpelNodeActionArray[n].getName();
            }
            return null;
        }

        public HelpCtx getHelpCtx(int n) {
            BpelNodeAction[] bpelNodeActionArray = GoToAction.getGoToActions(this.getNodes());
            if (bpelNodeActionArray != null && n > 0 && n < bpelNodeActionArray.length) {
                return bpelNodeActionArray[n].getHelpCtx();
            }
            return HelpCtx.DEFAULT_HELP;
        }

        public void performActionAt(int n) {
            BpelNodeAction[] bpelNodeActionArray = GoToAction.getGoToActions(this.getNodes());
            if (bpelNodeActionArray != null && n >= 0 && n < bpelNodeActionArray.length) {
                GoToAction.performAction(this.nodes, n);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.remove(ChangeListener.class, changeListener);
        }
    }
}

