/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.awt.Component;
import java.awt.Image;
import javax.swing.Action;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.editors.api.Constants;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.actions.DeleteVariableAction;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.VariableMainPanel;
import org.netbeans.modules.bpel.properties.editors.controls.SimpleCustomEditor;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeFilter;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeInfoProvider;
import org.netbeans.modules.bpel.properties.props.CustomEditorProperty;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.xml.xam.Reference;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableNode
extends BpelNode<VariableDeclaration>
implements VariableTypeInfoProvider {
    public VariableNode(VariableDeclaration variableDeclaration, Children children, Lookup lookup) {
        super(variableDeclaration, children, lookup);
    }

    public VariableNode(VariableDeclaration variableDeclaration, Lookup lookup) {
        super(variableDeclaration, lookup);
    }

    public static QName getVariableQNameType(VariableDeclaration variableDeclaration) {
        Constants.VariableStereotype variableStereotype = EditorUtil.getVariableStereotype((AbstractVariableDeclaration)variableDeclaration);
        switch (variableStereotype) {
            case PRIMITIVE_TYPE: 
            case GLOBAL_SIMPLE_TYPE: 
            case GLOBAL_COMPLEX_TYPE: 
            case GLOBAL_TYPE: {
                SchemaReference schemaReference = variableDeclaration.getType();
                if (schemaReference != null) {
                    return schemaReference.getQName();
                }
                return null;
            }
            case MESSAGE: {
                WSDLReference wSDLReference = variableDeclaration.getMessageType();
                if (wSDLReference != null) {
                    return wSDLReference.getQName();
                }
                return null;
            }
            case GLOBAL_ELEMENT: {
                SchemaReference schemaReference = variableDeclaration.getElement();
                if (schemaReference != null) {
                    return schemaReference.getQName();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.VARIABLE;
    }

    @Override
    public Image getIcon(int n) {
        return this.getNodeType().getImage((Object)this.getVariableStereotype());
    }

    @Override
    protected String getNameImpl() {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.getReference();
        String string = null;
        if (variableDeclaration != null) {
            string = variableDeclaration instanceof Variable ? ((Variable)variableDeclaration).getName() : variableDeclaration.getVariableName();
        }
        return string != null ? string : "";
    }

    @Override
    protected String getImplHtmlDisplayName() {
        Reference reference;
        VariableTypeFilter variableTypeFilter = (VariableTypeFilter)this.getLookup().lookup(VariableTypeFilter.class);
        String string = variableTypeFilter != null ? (variableTypeFilter.isTypeAllowed(this) ? this.getName() : SoaUtil.getGrayString((String)this.getName())) : ((reference = this.getVariableType()) == null ? this.getName() : SoaUtil.getGrayString((String)this.getName(), (String)(" " + this.getVariableType().getRefString())));
        return string;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        CustomEditorProperty customEditorProperty = new CustomEditorProperty(this);
        set.put((Node.Property)customEditorProperty);
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.getReference();
        if (variableDeclaration instanceof Variable) {
            PropertyUtils.registerAttributeProperty(this, set, "name", PropertyType.NAME, "getName", "setName", null);
        } else {
            PropertyUtils.registerAttributeProperty(this, set, "name", PropertyType.NAME, "getVariableName", null, null);
        }
        PropertyUtils.registerCalculatedProperty(this, set, PropertyType.VARIABLE_STEREOTYPE, "getVariableStereotype", null);
        PropertyUtils.registerCalculatedProperty(this, set, PropertyType.VARIABLE_TYPE_QNAME, "getVariableQNameType", null);
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    @Override
    public Constants.VariableStereotype getVariableStereotype() {
        return EditorUtil.getVariableStereotype((AbstractVariableDeclaration)((AbstractVariableDeclaration)this.getReference()));
    }

    public Reference getVariableType() {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.getReference();
        return variableDeclaration == null ? null : EditorUtil.getVariableType((AbstractVariableDeclaration)variableDeclaration);
    }

    @Override
    public QName getVariableQNameType() {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.getReference();
        return variableDeclaration == null ? null : VariableNode.getVariableQNameType(variableDeclaration);
    }

    public void setVariableType(Reference reference) {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.getReference();
        if (variableDeclaration == null) {
            return;
        }
        if (!(variableDeclaration instanceof Variable)) {
            return;
        }
        Variable variable = (Variable)variableDeclaration;
        Constants.VariableStereotype variableStereotype = this.getVariableStereotype();
        switch (variableStereotype) {
            case PRIMITIVE_TYPE: 
            case GLOBAL_SIMPLE_TYPE: 
            case GLOBAL_COMPLEX_TYPE: 
            case GLOBAL_TYPE: {
                assert (reference instanceof SchemaReference);
                variable.setType((SchemaReference)reference);
                break;
            }
            case MESSAGE: {
                assert (reference instanceof WSDLReference);
                variable.setMessageType((WSDLReference)reference);
                break;
            }
            case GLOBAL_ELEMENT: {
                assert (reference instanceof SchemaReference);
                variable.setElement((SchemaReference)reference);
            }
        }
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.GO_TO_SOURCE, ActionType.GO_TO_TYPE_SOURCE, ActionType.FIND_USAGES, ActionType.SEPARATOR, ActionType.SHOW_POPERTY_EDITOR, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    @Override
    public Action createAction(ActionType actionType) {
        switch (actionType) {
            case REMOVE: {
                return SystemAction.get(DeleteVariableAction.class);
            }
        }
        return super.createAction(actionType);
    }

    @Override
    public Component getCustomizer(CustomNodeEditor.EditingMode editingMode) {
        SimpleCustomEditor<VariableDeclaration> simpleCustomEditor = new SimpleCustomEditor<VariableDeclaration>(this, VariableMainPanel.class, editingMode);
        return simpleCustomEditor;
    }

    @Override
    protected void updateComplexProperties(ChangeEvent changeEvent) {
        String string;
        BpelEntity bpelEntity;
        if ((changeEvent instanceof PropertyUpdateEvent || changeEvent instanceof PropertyRemoveEvent) && (bpelEntity = changeEvent.getParent()) != null && bpelEntity.equals(this.getReference()) && ("type".equals(string = changeEvent.getName()) || "messageType".equals(string) || "element".equals(string))) {
            this.updateProperty(PropertyType.VARIABLE_STEREOTYPE);
            this.updateProperty(PropertyType.VARIABLE_TYPE_QNAME);
        }
    }

    public static class DefaultTypeInfoProvider
    implements VariableTypeInfoProvider {
        private VariableDeclaration myVar;

        public DefaultTypeInfoProvider(VariableDeclaration variableDeclaration) {
            this.myVar = variableDeclaration;
        }

        public Constants.VariableStereotype getVariableStereotype() {
            if (this.myVar != null) {
                return EditorUtil.getVariableStereotype((AbstractVariableDeclaration)this.myVar);
            }
            return null;
        }

        public Object getVariableType() {
            if (this.myVar != null) {
                return EditorUtil.getVariableType((AbstractVariableDeclaration)this.myVar);
            }
            return null;
        }

        public QName getVariableQNameType() {
            if (this.myVar != null) {
                return VariableNode.getVariableQNameType(this.myVar);
            }
            return null;
        }
    }
}

