/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FDimension;
import org.netbeans.modules.bpel.design.geometry.FPath;
import org.netbeans.modules.bpel.design.geometry.FShape;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.ConnectionManager;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.GroupBorder;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.xml.xam.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowPattern
extends CompositePattern {
    private VisualElement startGateway;
    private VisualElement endGateway;
    private PlaceHolderElement placeHolder;
    private List<Connection> connectionsStart = new ArrayList<Connection>();
    private List<Connection> connectionsEnd = new ArrayList<Connection>();
    private Connection startPlaceHolderConnection;
    private Connection endPlaceHolderConnection;
    private static final String FLOW_SEQUENCE_NAME = "FlowSequence";

    public FlowPattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    public VisualElement getFirstElement() {
        return this.startGateway;
    }

    @Override
    public VisualElement getLastElement() {
        return this.endGateway;
    }

    @Override
    protected void createElementsImpl() {
        ExtendableActivity[] extendableActivityArray;
        this.setBorder(new GroupBorder());
        this.getBorder().setLabelText(this.getDefaultName());
        this.registerTextElement(this.getBorder());
        this.startGateway = ContentElement.createFlowGateway();
        this.appendElement(this.startGateway);
        this.startGateway.setLabelText("");
        this.endGateway = ContentElement.createFlowGateway();
        this.appendElement(this.endGateway);
        this.endGateway.setLabelText("");
        this.placeHolder = new PlaceHolderElement();
        this.appendElement(this.placeHolder);
        Flow flow = (Flow)this.getOMReference();
        for (ExtendableActivity extendableActivity : extendableActivityArray = flow.getActivities()) {
            Pattern pattern = this.getModel().createPattern((BpelEntity)extendableActivity);
            pattern.setParent(this);
        }
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        double d;
        List<Pattern> list = this.getNestedPatterns();
        boolean bl = list.isEmpty();
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d3 = this.placeHolder.getWidth();
            d2 = this.placeHolder.getHeight();
            this.placeHolder.setLocation(-d3 / 2.0, -d2 / 2.0);
        } else {
            ExtendableActivity[] extendableActivityArray;
            Flow flow = (Flow)this.getOMReference();
            for (ExtendableActivity extendableActivity : extendableActivityArray = flow.getActivities()) {
                Pattern pattern = this.getNestedPattern((BpelEntity)extendableActivity);
                FDimension fDimension = pattern.getBounds().getSize();
                d2 = Math.max(d2, (double)fDimension.height);
                d3 += (double)fDimension.width;
            }
            d = -(d3 += (double)((float)(list.size() - 1) * 12.0f)) / 2.0;
            for (ExtendableActivity extendableActivity : extendableActivityArray) {
                Pattern pattern = this.getNestedPattern((BpelEntity)extendableActivity);
                FBounds fBounds = pattern.getBounds();
                float f = -fBounds.height / 2.0f;
                layoutManager.setPatternPosition(pattern, d, f);
                d += (double)(fBounds.width + 12.0f);
            }
        }
        double d4 = -(d2 / 2.0 + this.startGateway.getHeight() / 2.0 + 18.0);
        d = d2 / 2.0 + this.endGateway.getHeight() / 2.0 + 18.0;
        this.startGateway.setCenter(0.0, d4);
        this.endGateway.setCenter(0.0, d);
        d3 = Math.max(d3, this.startGateway.getWidth());
        double d5 = -d3 / 2.0;
        double d6 = -d2 / 2.0 - this.startGateway.getHeight() - 18.0;
        this.getBorder().setClientRectangle(d5, d6, d3, d2 += this.startGateway.getHeight() + this.endGateway.getHeight() + 36.0);
        return this.getBorder().getBounds();
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
        if (this.placeHolder.getPattern() == this) {
            this.removeElement(this.placeHolder);
        }
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        Flow flow = (Flow)this.getOMReference();
        if (flow.sizeOfActivities() == 0) {
            this.appendElement(this.placeHolder);
        }
    }

    @Override
    public String getDefaultName() {
        return "Flow";
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (pattern == this) {
            return;
        }
        if (this.isNestedIn(pattern)) {
            return;
        }
        if (!(pattern.getOMReference() instanceof Activity)) {
            return;
        }
        if (this.placeHolder.getPattern() != null) {
            collection.add(new FirstPlaceHolder(pattern));
        } else {
            collection.add(new NextPlaceHolder(pattern));
            Flow flow = (Flow)this.getOMReference();
            ExtendableActivity[] extendableActivityArray = flow.getActivities();
            for (int i = 0; i < extendableActivityArray.length; ++i) {
                BorderElement borderElement;
                Pattern pattern2;
                ExtendableActivity extendableActivity = extendableActivityArray[i];
                if (extendableActivity instanceof Sequence || (pattern2 = this.getNestedPattern((BpelEntity)extendableActivity)) == pattern) continue;
                FPath fPath = this.connectionsStart.get(i).getPath();
                FPath fPath2 = this.connectionsEnd.get(i).getPath();
                if (pattern2 instanceof CompositePattern && (borderElement = ((CompositePattern)pattern2).getBorder()) != null) {
                    FShape fShape = borderElement.getShape();
                    fPath = fPath.subtract(fShape);
                    fPath2 = fPath2.subtract(fShape);
                }
                collection.add(new BeforeImpliciteSequencePlaceHolder(i, pattern, fPath));
                collection.add(new AfterImpliciteSequencePlaceHolder(i, pattern, fPath2));
            }
        }
    }

    @Override
    public void reconnectElements() {
        ExtendableActivity[] extendableActivityArray = ((Flow)this.getOMReference()).getActivities();
        this.ensureConnectionsCount(this.connectionsStart, extendableActivityArray.length);
        this.ensureConnectionsCount(this.connectionsEnd, extendableActivityArray.length);
        for (int i = 0; i < extendableActivityArray.length; ++i) {
            Pattern pattern = this.getNestedPattern((BpelEntity)extendableActivityArray[i]);
            Connection connection = this.connectionsStart.get(i);
            Connection connection2 = this.connectionsEnd.get(i);
            ConnectionManager.connectVerticaly(this.startGateway, connection, pattern, connection2, this.endGateway);
        }
        if (this.placeHolder.getPattern() != null) {
            if (this.startPlaceHolderConnection == null) {
                this.startPlaceHolderConnection = new Connection(this);
            }
            if (this.endPlaceHolderConnection == null) {
                this.endPlaceHolderConnection = new Connection(this);
            }
            ConnectionManager.connectVerticaly(this.startGateway, this.startPlaceHolderConnection, this.placeHolder, this.endPlaceHolderConnection, this.endGateway);
        } else {
            if (this.startPlaceHolderConnection != null) {
                this.startPlaceHolderConnection.remove();
                this.startPlaceHolderConnection = null;
            }
            if (this.endPlaceHolderConnection != null) {
                this.endPlaceHolderConnection.remove();
                this.endPlaceHolderConnection = null;
            }
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLOW;
    }

    @Override
    public Area createSelection() {
        Area area = new Area(this.getBorder().getShape());
        area.subtract(new Area(this.startGateway.getShape()));
        area.subtract(new Area(this.endGateway.getShape()));
        return area;
    }

    private double getNextPlaceHolderX() {
        BorderElement borderElement = this.getBorder();
        return borderElement.getX() + borderElement.getWidth() - (double)(borderElement.getInsets().right / 2.0f);
    }

    private void setName(Flow flow, Sequence sequence) {
        String string = FLOW_SEQUENCE_NAME;
        int n = 1;
        while (this.hasName((BpelEntity)flow, string)) {
            string = FLOW_SEQUENCE_NAME + n++;
        }
        try {
            sequence.setName(string);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    private boolean hasName(BpelEntity bpelEntity, String string) {
        if (bpelEntity instanceof Named && string.equals(((Named)bpelEntity).getName())) {
            return true;
        }
        List list = bpelEntity.getChildren();
        for (BpelEntity bpelEntity2 : list) {
            if (!this.hasName(bpelEntity2, string)) continue;
            return true;
        }
        return false;
    }

    private class AfterImpliciteSequencePlaceHolder
    extends PlaceHolder {
        private int index;

        public AfterImpliciteSequencePlaceHolder(int n, Pattern pattern, FPath fPath) {
            int n2;
            super((Pattern)FlowPattern.this, pattern, fPath.point(Math.min(1.0, 10.0 / fPath.length())));
            Flow flow = (Flow)FlowPattern.this.getOMReference();
            ExtendableActivity extendableActivity = (ExtendableActivity)pattern.getOMReference();
            this.index = n;
            if (extendableActivity.getParent() == flow && (n2 = flow.indexOf(ExtendableActivity.class, (BpelEntity)extendableActivity)) < n) {
                --this.index;
            }
        }

        public void drop() {
            Flow flow = (Flow)this.getOwnerPattern().getOMReference();
            ExtendableActivity extendableActivity = (ExtendableActivity)this.getDraggedPattern().getOMReference();
            ExtendableActivity extendableActivity2 = (ExtendableActivity)flow.getActivity(this.index).cut();
            Sequence sequence = flow.getBpelModel().getBuilder().createSequence();
            sequence.addActivity(extendableActivity2);
            sequence.addActivity(extendableActivity);
            flow.insertActivity((ExtendableActivity)sequence, this.index);
            FlowPattern.this.setName(flow, sequence);
        }
    }

    private class BeforeImpliciteSequencePlaceHolder
    extends PlaceHolder {
        private int index;

        public BeforeImpliciteSequencePlaceHolder(int n, Pattern pattern, FPath fPath) {
            int n2;
            super((Pattern)FlowPattern.this, pattern, fPath.point(Math.max(0.0, 1.0 - 10.0 / fPath.length())));
            Flow flow = (Flow)FlowPattern.this.getOMReference();
            ExtendableActivity extendableActivity = (ExtendableActivity)pattern.getOMReference();
            this.index = n;
            if (extendableActivity.getParent() == flow && (n2 = flow.indexOf(ExtendableActivity.class, (BpelEntity)extendableActivity)) < n) {
                --this.index;
            }
        }

        public void drop() {
            Flow flow = (Flow)this.getOwnerPattern().getOMReference();
            ExtendableActivity extendableActivity = (ExtendableActivity)this.getDraggedPattern().getOMReference();
            ExtendableActivity extendableActivity2 = (ExtendableActivity)flow.getActivity(this.index).cut();
            Sequence sequence = flow.getBpelModel().getBuilder().createSequence();
            sequence.addActivity(extendableActivity);
            sequence.addActivity(extendableActivity2);
            flow.insertActivity((ExtendableActivity)sequence, this.index);
            FlowPattern.this.setName(flow, sequence);
        }
    }

    class NextPlaceHolder
    extends PlaceHolder {
        private FPath tempPath;

        public NextPlaceHolder(Pattern pattern) {
            super((Pattern)FlowPattern.this, pattern, FlowPattern.this.getNextPlaceHolderX(), FlowPattern.this.getBorder().getCenterY());
            this.tempPath = this.createTempPath();
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            ((Flow)FlowPattern.this.getOMReference()).addActivity((ExtendableActivity)((Activity)pattern.getOMReference()));
        }

        public void paint(Graphics2D graphics2D) {
            Connection.paintConnection(graphics2D, this.tempPath, false, true, false, false, null);
            super.paint(graphics2D);
        }

        private FPath createTempPath() {
            double d = FlowPattern.this.startGateway.getX() + FlowPattern.this.startGateway.getWidth();
            double d2 = FlowPattern.this.startGateway.getY() + FlowPattern.this.startGateway.getHeight();
            for (Connection connection : FlowPattern.this.startGateway.getOutcomingConnections()) {
                if (connection.getSourceDirection() != Direction.RIGHT) continue;
                d2 = Math.min((double)connection.getPath().point((double)0.0).y, d2);
            }
            d2 = (d2 + FlowPattern.this.startGateway.getY()) / 2.0;
            double d3 = FlowPattern.this.endGateway.getX() + FlowPattern.this.endGateway.getWidth();
            double d4 = FlowPattern.this.endGateway.getY();
            for (Connection connection : FlowPattern.this.endGateway.getIncomingConnections()) {
                if (connection.getTargetDirection() != Direction.RIGHT) continue;
                d4 = Math.max((double)connection.getPath().point((double)1.0).y, d4);
            }
            d4 = (d4 + FlowPattern.this.endGateway.getY() + FlowPattern.this.endGateway.getHeight()) / 2.0;
            double d5 = FlowPattern.this.getNextPlaceHolderX();
            FPath fPath = new FPath(d, d2, d5, d2, d5, d4, d3, d4);
            return fPath.round(2.0);
        }
    }

    class FirstPlaceHolder
    extends PlaceHolder {
        public FirstPlaceHolder(Pattern pattern) {
            super((Pattern)FlowPattern.this, pattern, FlowPattern.this.placeHolder.getCenterX(), FlowPattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            ((Flow)FlowPattern.this.getOMReference()).addActivity((ExtendableActivity)((Activity)pattern.getOMReference()));
        }
    }
}

