/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositePattern
extends Pattern {
    private BorderElement border;
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public CompositePattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    public void setBorder(BorderElement borderElement) {
        BorderElement borderElement2 = this.border;
        if (borderElement2 != null) {
            borderElement2.setPattern(null);
        }
        if (borderElement != null) {
            borderElement.setPattern(this);
        }
        this.border = borderElement;
    }

    public BorderElement getBorder() {
        return this.border;
    }

    public List<Pattern> getNestedPatterns() {
        return this.patterns;
    }

    public Pattern getNestedPattern() {
        if (this.patterns.size() == 0) {
            return null;
        }
        return this.patterns.get(0);
    }

    protected abstract void onAppendPattern(Pattern var1);

    protected abstract void onRemovePattern(Pattern var1);

    protected void appendPattern(Pattern pattern) {
        assert (pattern != null) : "Trying to add null pattern to " + this;
        int n = this.getChildIndex(pattern);
        int n2 = this.patterns.size();
        n = n < 0 || n > n2 ? this.patterns.size() : n;
        this.patterns.add(n, pattern);
        this.onAppendPattern(pattern);
    }

    private int getChildIndex(Pattern pattern) {
        int n = -1;
        BpelEntity bpelEntity = pattern.getOMReference();
        if (bpelEntity == null) {
            return n;
        }
        BpelEntity bpelEntity2 = this.getOMReference();
        List list = null;
        if (bpelEntity2 != null) {
            list = bpelEntity2.getChildren();
        }
        if (list != null) {
            int n2 = -1;
            for (BpelEntity bpelEntity3 : list) {
                for (Pattern pattern2 : this.patterns) {
                    if (bpelEntity3 == null || !bpelEntity3.equals(pattern2.getOMReference())) continue;
                    ++n2;
                    break;
                }
                if (!bpelEntity.equals(bpelEntity3)) continue;
                ++n2;
                break;
            }
            n = n2;
        }
        return n;
    }

    protected void removePattern(Pattern pattern) {
        this.patterns.remove(pattern);
        this.onRemovePattern(pattern);
    }

    public VisualElement getNamedElement() {
        return this.getBorder();
    }

    public void ensureConnectionsCount(List<Connection> list, int n) {
        n = Math.max(n, 0);
        while (list.size() > n) {
            list.remove(list.size() - 1).remove();
        }
        while (list.size() < n) {
            list.add(new Connection(this));
        }
    }

    public Pattern getNestedPattern(BpelEntity bpelEntity) {
        Pattern pattern = this.getModel().getPattern(bpelEntity);
        if (pattern == null) {
            return null;
        }
        if (pattern.getParent() != this) {
            assert (false);
            return null;
        }
        return pattern;
    }

    @Override
    public Area createSelection() {
        return this.createOutline();
    }

    @Override
    public boolean isCollapsable() {
        return true;
    }

    @Override
    public Area createOutline() {
        Area area = new Area();
        BorderElement borderElement = this.getBorder();
        if (borderElement != null) {
            area.add(new Area(borderElement.getShape()));
        }
        for (VisualElement visualElement : this.getElements()) {
            if (visualElement.getWidth() < 2.0 && visualElement.getHeight() < 2.0) continue;
            area.add(new Area(visualElement.getShape()));
        }
        return area;
    }
}

