/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.actions.DesignViewAction;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public class TabToNextComponentAction
extends DesignViewAction {
    private static final long serialVersionUID = 1L;
    private boolean forward;

    public TabToNextComponentAction(DesignView designView, boolean bl) {
        super(designView);
        this.forward = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DesignView designView = this.getDesignView();
        if (designView.getCopyPasteHandler().isActive()) {
            designView.getCopyPasteHandler().tabNextPlaceholder(this.forward);
        } else {
            Pattern pattern = designView.getSelectionModel().getSelectedPattern();
            while ((pattern = this.getNextPattern(pattern)) != null && !pattern.isSelectable()) {
            }
            if (pattern != null) {
                designView.getSelectionModel().setSelectedPattern(pattern);
                designView.scrollSelectedToView();
            }
        }
    }

    private Pattern getNextPattern(Pattern pattern) {
        DesignView designView = this.getDesignView();
        if (pattern == null) {
            return null;
        }
        DiagramView diagramView = pattern.getView();
        Pattern pattern2 = this.getNextInView(pattern);
        if (pattern2 != null) {
            return pattern2;
        }
        DiagramView diagramView2 = this.getNextView(diagramView);
        if (diagramView2 == null) {
            return null;
        }
        return this.getFirstInView(diagramView2);
    }

    private Pattern getNextInView(Pattern pattern) {
        DiagramView diagramView = pattern.getView();
        Iterator<Pattern> iterator = diagramView.getPatterns();
        Pattern pattern2 = null;
        while (iterator.hasNext()) {
            Pattern pattern3 = iterator.next();
            if (pattern3 == pattern) {
                if (this.forward) {
                    return iterator.hasNext() ? iterator.next() : null;
                }
                return pattern2;
            }
            pattern2 = pattern3;
        }
        return null;
    }

    private Pattern getFirstInView(DiagramView diagramView) {
        Iterator<Pattern> iterator = diagramView.getPatterns();
        if (this.forward) {
            return iterator.hasNext() ? iterator.next() : null;
        }
        Pattern pattern = null;
        while (iterator.hasNext()) {
            pattern = iterator.next();
        }
        return pattern;
    }

    private DiagramView getNextView(DiagramView diagramView) {
        DesignView designView = this.getDesignView();
        if (diagramView == designView.getConsumersView()) {
            return this.forward ? designView.getProcessView() : designView.getProvidersView();
        }
        if (diagramView == designView.getProcessView()) {
            return this.forward ? designView.getProvidersView() : designView.getConsumersView();
        }
        if (diagramView == designView.getProvidersView()) {
            return this.forward ? designView.getConsumersView() : designView.getProcessView();
        }
        return null;
    }
}

