/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BWGraphics2D
extends Graphics2D {
    private final Graphics2D g2;

    public BWGraphics2D(Graphics2D graphics2D) {
        this.g2 = graphics2D;
    }

    @Override
    public void draw(Shape shape) {
        this.g2.draw(shape);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.g2.drawImage(image, affineTransform, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.g2.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.g2.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.g2.drawRenderableImage(renderableImage, affineTransform);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.g2.drawString(string, n, n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.g2.drawString(string, f, f2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g2.drawString(attributedCharacterIterator, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.g2.drawString(attributedCharacterIterator, f, f2);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.g2.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public void fill(Shape shape) {
        this.g2.fill(shape);
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.g2.hit(rectangle, shape, bl);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite composite) {
        this.g2.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            paint = BWGraphics2D.gray((Color)paint);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            paint = new GradientPaint(gradientPaint.getPoint1(), BWGraphics2D.gray(gradientPaint.getColor1()), gradientPaint.getPoint2(), BWGraphics2D.gray(gradientPaint.getColor2()), gradientPaint.isCyclic());
        } else if (paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)paint;
            paint = new TexturePaint(BWGraphics2D.gray(texturePaint.getImage()), texturePaint.getAnchorRect());
        }
        this.g2.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.g2.setStroke(stroke);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g2.setRenderingHint(key, object);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2.getRenderingHint(key);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.g2.setRenderingHints(map);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.g2.addRenderingHints(map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2.getRenderingHints();
    }

    @Override
    public void translate(int n, int n2) {
        this.g2.translate(n, n2);
    }

    @Override
    public void translate(double d, double d2) {
        this.g2.translate(d, d2);
    }

    @Override
    public void rotate(double d) {
        this.g2.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.g2.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.g2.scale(d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.g2.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.g2.transform(affineTransform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.g2.setTransform(affineTransform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.g2.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.g2.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.g2.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.g2.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.g2.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.g2.getStroke();
    }

    @Override
    public void clip(Shape shape) {
        this.g2.clip(shape);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g2.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new BWGraphics2D((Graphics2D)this.g2.create());
    }

    @Override
    public Color getColor() {
        return this.g2.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.g2.setColor(BWGraphics2D.gray(color));
    }

    @Override
    public void setPaintMode() {
        this.g2.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.g2.setXORMode(color);
    }

    @Override
    public Font getFont() {
        return this.g2.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.g2.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.g2.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.g2.getClipBounds();
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.g2.clearRect(n, n2, n3, n4);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.g2.setClip(n, n2, n3, n4);
    }

    @Override
    public Shape getClip() {
        return this.g2.getClip();
    }

    @Override
    public void setClip(Shape shape) {
        this.g2.setClip(shape);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.g2.drawLine(n, n2, n3, n4);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g2.fillRect(n, n2, n3, n4);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.g2.clearRect(n, n2, n3, n4);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.g2.drawOval(n, n2, n3, n4);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.g2.fillOval(n, n2, n3, n4);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2.fillArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g2.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g2.drawPolygon(nArray, nArray2, n);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g2.fillPolygon(nArray, nArray2, n);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.g2.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public void dispose() {
        this.g2.dispose();
    }

    private static Color gray(Color color) {
        int n = color.getRGB();
        int n2 = Math.round(0.299f * (float)(n >> 16 & 0xFF) + 0.587f * (float)(n >> 8 & 0xFF) + 0.114f * (float)(n & 0xFF));
        return new Color(n2, n2, n2);
    }

    private static BufferedImage gray(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = bufferedImage.getRGB(i, j);
                int n4 = Math.round(0.299f * (float)(n3 >> 16 & 0xFF) + 0.587f * (float)(n3 >> 8 & 0xFF) + 0.114f * (float)(n3 & 0xFF));
                bufferedImage2.setRGB(i, j, n4 << 16 | n4 << 8 | n4);
            }
        }
        return bufferedImage2;
    }
}

