/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotClassPathEntry {
    public static final String ATTRIBUTE_KIND = "kind";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_EXPORTED = "exported";
    public static final String ATTRIBUTE_SOURCEPATH = "sourcepath";
    public static final String ATTRIBUTE_JAVADOC = "javadoc_location";
    public static final String ATTRIBUTE_SOURCE_EXCLUDES = "excluding";
    public static final String ATTRIBUTE_SOURCE_INCLUDES = "including";
    private Map<String, String> properties;
    private String absolutePath;
    private String containerMapping;
    private String linkName;
    private Boolean importSuccessful;

    public DotClassPathEntry(Map<String, String> map, String string) {
        this.properties = map;
        this.linkName = string;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Kind getKind() {
        String string = this.getProperty(ATTRIBUTE_KIND);
        if ("con".equals(string)) {
            return Kind.CONTAINER;
        }
        if ("lib".equals(string)) {
            return Kind.LIBRARY;
        }
        if ("src".equals(string)) {
            if (this.getRawPath().startsWith("/") && this.getLinkName() == null) {
                return Kind.PROJECT;
            }
            return Kind.SOURCE;
        }
        if ("var".equals(string)) {
            return Kind.VARIABLE;
        }
        if ("output".equals(string)) {
            return Kind.OUTPUT;
        }
        throw new IllegalStateException("unknown kind: " + string);
    }

    public String getRawPath() {
        return this.getProperty(ATTRIBUTE_PATH);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    String getLinkName() {
        return this.linkName;
    }

    public boolean isExported() {
        return Boolean.parseBoolean(this.getProperty(ATTRIBUTE_EXPORTED));
    }

    public void setAbsolutePath(String string) {
        this.absolutePath = string;
    }

    public String toString() {
        return "DotClassPathEntry: " + this.properties;
    }

    public String getContainerMapping() {
        return this.containerMapping;
    }

    public void setContainerMapping(String string) {
        this.containerMapping = string;
    }

    public Boolean getImportSuccessful() {
        return this.importSuccessful;
    }

    public void setImportSuccessful(Boolean bl) {
        this.importSuccessful = bl;
    }

    public void updateVariableValue(String string) {
        this.properties.put(ATTRIBUTE_PATH, string);
    }

    public void updateSourcePath(String string) {
        this.properties.put(ATTRIBUTE_SOURCEPATH, string);
    }

    public void updateJavadoc(String string) {
        this.properties.put(ATTRIBUTE_JAVADOC, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CONTAINER,
        LIBRARY,
        PROJECT,
        SOURCE,
        VARIABLE,
        OUTPUT;

    }
}

