/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workspace {
    private static final Logger logger = Logger.getLogger(Workspace.class.getName());
    private static final String RUNTIME_SETTINGS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/";
    static final String CORE_PREFERENCE = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs";
    static final String RESOURCES_PREFERENCE = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs";
    static final String LAUNCHING_PREFERENCES = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.launching.prefs";
    static final String RESOURCE_PROJECTS_DIR = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    static final String DEFAULT_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    static final String USER_JSF_LIBRARIES = ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml";
    private File corePrefFile;
    private File resourcesPrefFile;
    private File launchingPrefsFile;
    private File resourceProjectsDir;
    private File workspaceDir;
    private File userJSFLibraries;
    private Set<Variable> variables = new HashSet<Variable>();
    private Set<Variable> resourcesVariables = new HashSet<Variable>();
    private Set<EclipseProject> projects = new HashSet<EclipseProject>();
    private Map<String, String> jreContainers;
    private Map<String, List<String>> userLibraries;
    private Collection<LaunchConfiguration> launchConfigurations;
    private boolean myEclipseLibrariesLoaded;

    static Workspace createWorkspace(File file) {
        if (!EclipseUtils.isRegularWorkSpace(file)) {
            ErrorManager.getDefault().log(1, "There is not a regular workspace in " + file);
            return null;
        }
        Workspace workspace = new Workspace(file);
        return workspace;
    }

    Workspace(File file) {
        this.workspaceDir = file;
        this.corePrefFile = new File(file, CORE_PREFERENCE);
        this.resourcesPrefFile = new File(file, RESOURCES_PREFERENCE);
        this.launchingPrefsFile = new File(file, LAUNCHING_PREFERENCES);
        this.resourceProjectsDir = new File(file, RESOURCE_PROJECTS_DIR);
        this.userJSFLibraries = new File(file, USER_JSF_LIBRARIES);
    }

    File getUserJSFLibraries() {
        return this.userJSFLibraries;
    }

    public File getDirectory() {
        return this.workspaceDir;
    }

    File getCorePreferenceFile() {
        return this.corePrefFile;
    }

    File getResourcesPreferenceFile() {
        return this.resourcesPrefFile;
    }

    File getLaunchingPrefsFile() {
        return this.launchingPrefsFile;
    }

    File getResourceProjectsDir() {
        return this.resourceProjectsDir;
    }

    void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    void addResourcesVariable(Variable variable) {
        this.resourcesVariables.add(variable);
    }

    Set<Variable> getVariables() {
        return this.variables;
    }

    Set<Variable> getResourcesVariables() {
        return this.resourcesVariables;
    }

    void loadMyEclipseLibraries(List<String> list) {
        if (!this.myEclipseLibrariesLoaded) {
            this.myEclipseLibrariesLoaded = true;
            String string = null;
            Object object = this.getVariables().iterator();
            while (object.hasNext()) {
                int n;
                Variable variable = object.next();
                if (!variable.getName().startsWith("MYECLIPSE_") || !variable.getName().endsWith("_HOME") || (n = variable.getLocation().replace('\\', '/').indexOf("/plugins/")) == -1) continue;
                string = variable.getLocation().substring(0, n + 8);
                break;
            }
            if (string == null) {
                object = this.getVariable("ECLIPSE_HOME");
                if (object == null) {
                    list.add(NbBundle.getMessage(Workspace.class, (String)"MSG_CannotReadMyEclipseLibs"));
                    return;
                }
                string = new File(new File(((Variable)object).getLocation()), "plugins").getPath();
            }
            if (!((File)(object = new File(string))).exists()) {
                list.add(NbBundle.getMessage(Workspace.class, (String)"MSG_CannotReadMyEclipseLibs"));
                return;
            }
            this.scanForLibraries((File)object);
        }
    }

    private void scanForLibraries(File file) {
        File[] fileArray;
        assert (file.isDirectory()) : file;
        for (File file2 : fileArray = file.listFiles()) {
            File file3;
            if (!file2.isDirectory() || !(file3 = new File(file2, "preferences.ini")).exists()) continue;
            this.analyzePreferencesIniFile(file3);
        }
    }

    private void analyzePreferencesIniFile(File file) {
        Properties properties = new Properties();
        EclipseUtils.tryLoad(properties, file);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!string.startsWith("melibrary.com.genuitec.eclipse.") || !string.endsWith(".classpath")) continue;
            List<String> list = this.parseLibDefinition(string2);
            int n = string.indexOf(".classpath");
            int n2 = string.indexOf(".MYECLIPSE_");
            if (n2 == -1) {
                n2 = string.substring(0, n).lastIndexOf(".");
                if (n2 != -1) {
                    ++n2;
                }
            } else {
                n2 += 11;
            }
            assert (n2 != -1) : string;
            String string3 = string.substring(n2, n);
            this.addUserLibrary(string3, list);
        }
    }

    private List<String> parseLibDefinition(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            Variable variable;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("(");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if ((variable = this.getVariable((stringArray = EclipseUtils.splitVariable(string2))[0])) != null) {
                string2 = variable.getLocation() + stringArray[1];
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Variable getVariable(String string) {
        for (Variable variable : this.getVariables()) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    void setJREContainers(Map<String, String> map) {
        this.jreContainers = map;
    }

    void addProject(EclipseProject eclipseProject) {
        this.projects.add(eclipseProject);
    }

    void addUserLibrary(String string, List<String> list) {
        if (this.userLibraries == null) {
            this.userLibraries = new HashMap<String, List<String>>();
        }
        this.userLibraries.put(string, list);
    }

    Map<String, List<String>> getUserLibraries() {
        return this.userLibraries;
    }

    List<URL> getJarsForUserLibrary(String string) {
        if (this.userLibraries != null && this.userLibraries.get(string) != null) {
            List<String> list = this.userLibraries.get(string);
            ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
            for (String string2 : list) {
                try {
                    File file = new File(string2);
                    URL uRL = file.toURI().toURL();
                    if (file.isFile()) {
                        uRL = FileUtil.getArchiveRoot((URL)uRL);
                    }
                    arrayList.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    EclipseProject getProjectByRawPath(String string) {
        EclipseProject eclipseProject = null;
        for (EclipseProject eclipseProject2 : this.projects) {
            if (!eclipseProject2.getName().equals(string.substring(1))) continue;
            eclipseProject = eclipseProject2;
        }
        if (eclipseProject == null) {
            logger.info("Project with raw path \"" + string + "\" cannot" + " be found in project list: " + this.projects);
        }
        return eclipseProject;
    }

    public Set<EclipseProject> getProjects() {
        return this.projects;
    }

    String getProjectAbsolutePath(String string) {
        for (EclipseProject eclipseProject : this.projects) {
            if (!eclipseProject.getName().equals(string)) continue;
            return eclipseProject.getDirectory().getAbsolutePath();
        }
        return null;
    }

    EclipseProject getProjectByProjectDir(File file) {
        for (EclipseProject eclipseProject : this.projects) {
            if (!eclipseProject.getDirectory().equals(file)) continue;
            return eclipseProject;
        }
        return null;
    }

    EclipseProject getProjectByName(String string) {
        for (EclipseProject eclipseProject : this.projects) {
            if (!eclipseProject.getName().equals(string)) continue;
            return eclipseProject;
        }
        return null;
    }

    String getJDKDirectory(String string) {
        if (string != null) {
            if (!DEFAULT_JRE_CONTAINER.equals(string)) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            for (Map.Entry<String, String> entry : this.jreContainers.entrySet()) {
                if (!entry.getKey().equals(string)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public Collection<LaunchConfiguration> getLaunchConfigurations() {
        return this.launchConfigurations;
    }

    void setLaunchConfigurations(Collection<LaunchConfiguration> collection) {
        this.launchConfigurations = collection;
    }

    public static class Variable {
        private String name;
        private String location;
        private boolean fileVar;
        private String file;

        public Variable(String string, String string2) {
            this.name = string;
            this.location = string2;
            File file = new File(string2);
            boolean bl = this.fileVar = file.exists() && file.isFile();
            if (this.fileVar) {
                this.file = file.getName();
                this.location = file.getParentFile().getAbsolutePath();
            }
        }

        String getName() {
            return this.name;
        }

        String getLocation() {
            return this.location;
        }

        public String getFileName() {
            return this.file;
        }

        public String toString() {
            return this.name + " = " + this.location;
        }

        public boolean isFileVariable() {
            return this.fileVar;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Variable)) {
                return false;
            }
            Variable variable = (Variable)object;
            if (this.name != null ? !this.name.equals(variable.name) : variable.name != null) {
                return false;
            }
            return !(this.location != null ? !this.location.equals(variable.location) : variable.location != null);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + System.identityHashCode(this.name);
            n = 37 * n + System.identityHashCode(this.location);
            return n;
        }
    }
}

