/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPathParser;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.ProjectParser;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;

public final class ProjectFactory {
    private static final Logger logger = Logger.getLogger(ProjectFactory.class.getName());
    private static ProjectFactory instance = new ProjectFactory();

    private ProjectFactory() {
    }

    public static ProjectFactory getInstance() {
        return instance;
    }

    public EclipseProject load(File file) throws ProjectImporterException {
        return this.load(file, file.getParentFile());
    }

    public EclipseProject load(File file, File file2) throws ProjectImporterException {
        Workspace workspace = null;
        if (file2 != null) {
            workspace = WorkspaceFactory.getInstance().load(file2);
        }
        return this.load(file, workspace);
    }

    private EclipseProject load(File file, Workspace workspace) throws ProjectImporterException {
        EclipseProject eclipseProject = EclipseProject.createProject(file);
        if (eclipseProject != null) {
            eclipseProject.setWorkspace(workspace);
            this.load(eclipseProject);
        }
        return eclipseProject;
    }

    void load(EclipseProject eclipseProject) throws ProjectImporterException {
        logger.finest("Loading project: " + eclipseProject.getDirectory().getAbsolutePath());
        try {
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<Link> arrayList = new ArrayList<Link>();
            HashSet<Workspace.Variable> hashSet2 = new HashSet();
            if (eclipseProject.getWorkspace() != null) {
                hashSet2 = eclipseProject.getWorkspace().getResourcesVariables();
            }
            String string = ProjectParser.parse(eclipseProject.getProjectFile(), hashSet, arrayList, hashSet2);
            eclipseProject.setNatures(hashSet);
            eclipseProject.setName(string);
            eclipseProject.setFacets(ProjectParser.readProjectFacets(eclipseProject.getDirectory(), hashSet));
            DotClassPath dotClassPath = eclipseProject.getClassPathFile() != null ? DotClassPathParser.parse(eclipseProject.getClassPathFile(), arrayList) : DotClassPathParser.empty();
            eclipseProject.setClassPath(dotClassPath);
        }
        catch (IOException iOException) {
            throw new ProjectImporterException(iOException);
        }
    }
}

