/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Importer;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPlatformSupport {
    private List<JavaPlatform> justCreatedPlatforms = new ArrayList<JavaPlatform>();
    private File defaultNetBeansPlatformFile = null;
    private static JavaPlatformSupport inst;

    private JavaPlatformSupport() {
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection collection = javaPlatform.getInstallFolders();
        if (!collection.isEmpty()) {
            this.defaultNetBeansPlatformFile = FileUtil.toFile((FileObject)((FileObject)collection.toArray()[0]));
        }
    }

    public static synchronized JavaPlatformSupport getJavaPlatformSupport() {
        if (inst == null) {
            inst = new JavaPlatformSupport();
        }
        return inst;
    }

    private List<JavaPlatform> getAllPlatforms() {
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>(this.justCreatedPlatforms);
        arrayList.addAll(Arrays.asList(JavaPlatformManager.getDefault().getInstalledPlatforms()));
        return arrayList;
    }

    public JavaPlatform getJavaPlatform(EclipseProject eclipseProject, List<String> list) {
        JavaPlatform[] javaPlatformArray;
        Object object;
        String string = eclipseProject.getJDKDirectory();
        if (string == null) {
            return null;
        }
        File file = FileUtil.normalizeFile((File)new File(string));
        if (this.defaultNetBeansPlatformFile != null && file.equals(this.defaultNetBeansPlatformFile)) {
            return null;
        }
        JavaPlatform javaPlatform = null;
        for (JavaPlatform javaPlatform2 : this.getAllPlatforms()) {
            object = javaPlatform2.getInstallFolders();
            if (object.isEmpty() || !(javaPlatformArray = FileUtil.toFile((FileObject)((FileObject)object.toArray()[0]))).equals(file)) continue;
            javaPlatform = javaPlatform2;
            break;
        }
        if (javaPlatform != null) {
            return javaPlatform;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                JavaPlatform javaPlatform2;
                javaPlatform2 = NewJ2SEPlatform.create((FileObject)fileObject);
                javaPlatform2.run();
                if (javaPlatform2.isValid()) {
                    if (javaPlatform2.findTool("javac") != null) {
                        object = this.createPlatformDisplayName(javaPlatform2);
                        javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms((String)object, null);
                        if (javaPlatformArray.length > 0) {
                            return javaPlatformArray[0];
                        }
                        String string2 = this.createPlatformAntName((String)object);
                        javaPlatform2.setDisplayName((String)object);
                        javaPlatform2.setAntName(string2);
                        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Services/Platforms/org-netbeans-api-java-Platform");
                        assert (fileObject2 != null);
                        DataObject dataObject = PlatformConvertor.create((JavaPlatform)javaPlatform2, (DataFolder)DataFolder.findFolder((FileObject)fileObject2), (String)string2);
                        javaPlatform = (JavaPlatform)dataObject.getNodeDelegate().getLookup().lookup(JavaPlatform.class);
                        this.justCreatedPlatforms.add(javaPlatform);
                    }
                    list.add(NbBundle.getMessage(Importer.class, (String)"MSG_JRECannotBeUsed", (Object)eclipseProject.getName()));
                }
                list.add("Cannot create J2SE platform for '" + file + "'. " + "Default platform will be used instead.");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        } else {
            list.add(NbBundle.getMessage(Importer.class, (String)"MSG_JDKDoesnExistUseDefault", (Object)eclipseProject.getName(), (Object)file.getAbsolutePath()));
        }
        return javaPlatform;
    }

    private String createPlatformDisplayName(JavaPlatform javaPlatform) {
        Map map = javaPlatform.getSystemProperties();
        String string = (String)map.get("java.specification.version");
        StringBuffer stringBuffer = new StringBuffer("JDK ");
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String createPlatformAntName(String string) {
        assert (string != null && string.length() > 0);
        String string2 = PropertyUtils.getUsablePropertyName((String)string);
        if (this.platformExists(string2)) {
            String string3 = string2;
            int n = 1;
            string2 = string3 + Integer.toString(n);
            while (this.platformExists(string2)) {
                string2 = string3 + Integer.toString(++n);
            }
        }
        return string2;
    }

    private boolean platformExists(String string) {
        assert (string != null && string.length() > 0);
        for (JavaPlatform javaPlatform : this.getAllPlatforms()) {
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

