/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.JavaPlatformSupport;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Importer {
    private static final Logger logger = Logger.getLogger(Importer.class.getName());
    private final List<EclipseProject> eclProjects;
    private final String destination;
    private final List<Project> nbProjects;
    private int nOfProcessed;
    private String progressInfo;
    private List<String> warnings = new ArrayList<String>();
    private Task task = null;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels;

    Importer(List<EclipseProject> list, String string, List<WizardDescriptor.Panel<WizardDescriptor>> list2) {
        this.eclProjects = list;
        this.destination = string;
        this.nbProjects = new ArrayList<Project>();
        this.extraPanels = list2;
    }

    void startImporting() {
        this.task = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (EclipseProject eclipseProject : Importer.this.eclProjects) {
                    Project project = Importer.this.importProject(eclipseProject, Importer.this.warnings);
                    if (project == null) continue;
                    Importer.this.nbProjects.add(project);
                }
            }
        });
    }

    int getNOfProcessed() {
        return this.nOfProcessed;
    }

    String getProgressInfo() {
        return this.progressInfo;
    }

    boolean isDone() {
        return this.task != null && this.task.isFinished();
    }

    List<String> getWarnings() {
        return this.warnings;
    }

    Project[] getProjects() {
        return this.nbProjects.toArray(new Project[this.nbProjects.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project importProject(final EclipseProject eclipseProject, final List<String> list) {
        assert (eclipseProject != null) : "Eclipse project cannot be null";
        final ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(eclipseProject.getImportProblems());
        try {
            Boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    try {
                        Importer.this.importProjectStage0(eclipseProject, arrayList);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "import of Eclipse project " + eclipseProject.getDirectory().getPath() + " failed", throwable);
                        arrayList.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportFailed", (Object)throwable.getMessage()));
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            });
            if (!bl.booleanValue()) {
                Project project = null;
                return project;
            }
            Project project = (Project)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Project>(){

                public Project run() {
                    try {
                        return Importer.this.importProjectStage1(eclipseProject, list, arrayList);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "import of Eclipse project " + eclipseProject.getDirectory().getPath() + " failed", throwable);
                        arrayList.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportFailed", (Object)throwable.getMessage()));
                        return null;
                    }
                }
            });
            return project;
        }
        finally {
            if (arrayList.size() > 0) {
                list.add(NbBundle.getMessage(Importer.class, (String)"MSG_ImportResults", (Object)eclipseProject.getName()));
                for (String string : arrayList) {
                    list.add(" " + string);
                }
            }
        }
    }

    private void importProjectStage0(EclipseProject eclipseProject, List<String> list) throws IOException {
        eclipseProject.resolveContainers(list, true);
        eclipseProject.setupEnvironmentVariables(list);
    }

    private Project importProjectStage1(EclipseProject eclipseProject, List<String> list, List<String> list2) throws IOException {
        Project project;
        ++this.nOfProcessed;
        this.progressInfo = NbBundle.getMessage(Importer.class, (String)"MSG_Progress_ProcessingProject", (Object)eclipseProject.getName());
        Project project2 = null;
        File file = this.destination == null ? eclipseProject.getDirectory() : FileUtil.normalizeFile((File)new File(this.destination, eclipseProject.getDirectory().getName()));
        if (file.exists()) {
            project2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
        }
        ProjectImportModel projectImportModel = new ProjectImportModel(eclipseProject, file, JavaPlatformSupport.getJavaPlatformSupport().getJavaPlatform(eclipseProject, list2), this.nbProjects, this.extraPanels);
        if (project2 != null) {
            project = project2;
            list2.add(NbBundle.getMessage(Importer.class, (String)"MSG_AlreadyImportedProjectFound"));
        } else {
            if (!eclipseProject.isImportSupported()) {
                list.add(NbBundle.getMessage(Importer.class, (String)"MSG_UnknownProject"));
                return null;
            }
            project = eclipseProject.getProjectTypeFactory().createProject(projectImportModel, list2);
            if (project != null && eclipseProject.getProjectTypeFactory() instanceof ProjectTypeUpdater) {
                ProjectTypeUpdater projectTypeUpdater = (ProjectTypeUpdater)eclipseProject.getProjectTypeFactory();
                String string = projectTypeUpdater.calculateKey(projectImportModel);
                EclipseProjectReference eclipseProjectReference = new EclipseProjectReference(project, eclipseProject.getDirectory().getAbsolutePath(), eclipseProject.getWorkspace() != null ? eclipseProject.getWorkspace().getDirectory().getAbsolutePath() : null, 0L, string);
                EclipseProjectReference.write(project, eclipseProjectReference);
                ProjectManager.getDefault().saveProject(project);
            }
        }
        return project;
    }

    private void logWarning(String string) {
        this.logWarning(string, false);
    }

    private void logWarning(String string, boolean bl) {
        if (bl) {
            this.warnings.add(string);
        }
        logger.warning(string);
    }
}

