/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseProject
implements Comparable {
    private static final Logger logger = Logger.getLogger(EclipseProject.class.getName());
    private static final Lookup.Result<? extends ProjectTypeFactory> projectTypeFactories = Lookup.getDefault().lookupResult(ProjectTypeFactory.class);
    private Boolean importSupported;
    private ProjectTypeFactory projectFactory;
    private Set<EclipseProject> projectsWeDependOn;
    static final String PROJECT_FILE = ".project";
    static final String CLASSPATH_FILE = ".classpath";
    private Workspace workspace;
    private String name;
    private boolean internal = true;
    private DotClassPath cp;
    private Set<String> natures;
    private final File projectDir;
    private final File cpFile;
    private final File prjFile;
    private String jdkDirectory;
    private List<String> importProblems = new ArrayList<String>();
    private Facets projectFacets;

    static EclipseProject createProject(File file) {
        if (!EclipseUtils.isRegularProject(file)) {
            logger.fine(file + " doesn't contain regular Eclipse project.");
            return null;
        }
        return new EclipseProject(file);
    }

    EclipseProject(File file) {
        this.projectDir = file;
        File file2 = new File(file, CLASSPATH_FILE);
        this.cpFile = file2.exists() ? file2 : null;
        this.prjFile = new File(file, PROJECT_FILE);
    }

    void setFacets(Facets facets) {
        this.projectFacets = facets;
    }

    public Facets getFacets() {
        return this.projectFacets;
    }

    void setNatures(Set<String> set) {
        this.natures = set;
    }

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    void setClassPath(DotClassPath dotClassPath) {
        this.cp = dotClassPath;
        this.calculateAbsolutePaths();
        this.convertFileVariablesToFolderVariables();
        this.updateSourcePathAttribute();
        this.updateJavaDocLocationAttribute();
        try {
            this.resolveContainers(new ArrayList<String>(), false);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public List<DotClassPathEntry> getClassPathEntries() {
        return this.cp.getClassPathEntries();
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    void setInternal(boolean bl) {
        this.internal = bl;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public File getDirectory() {
        return this.projectDir;
    }

    File getProjectFile() {
        return this.prjFile;
    }

    File getClassPathFile() {
        return this.cpFile;
    }

    public Set<String> getNatures() {
        return this.natures;
    }

    public boolean isImportSupported() {
        this.performRecognitionIfNeeded();
        return this.importSupported;
    }

    public ProjectTypeFactory getProjectTypeFactory() {
        this.performRecognitionIfNeeded();
        return this.projectFactory;
    }

    private ProjectTypeFactory.ProjectDescriptor getProjectDescriptor() {
        return new ProjectTypeFactory.ProjectDescriptor(this.getDirectory(), this.natures, this.projectFacets);
    }

    File getProjectFileLocation(String string) {
        if (!this.isImportSupported()) {
            return null;
        }
        return this.getProjectTypeFactory().getProjectFileLocation(this.getProjectDescriptor(), string);
    }

    private void performRecognitionIfNeeded() {
        if (this.importSupported == null) {
            this.importSupported = Boolean.FALSE;
            for (ProjectTypeFactory projectTypeFactory : projectTypeFactories.allInstances()) {
                if (!projectTypeFactory.canHandle(this.getProjectDescriptor())) continue;
                this.projectFactory = projectTypeFactory;
                this.importSupported = Boolean.TRUE;
                break;
            }
        }
    }

    public String getJDKDirectory() {
        if (this.jdkDirectory == null && this.workspace != null && this.cp.getJREContainer() != null) {
            logger.finest("Getting JDK directory for project " + this.getName());
            this.jdkDirectory = this.workspace.getJDKDirectory(this.cp.getJREContainer().getRawPath());
            logger.finest("Resolved JDK directory: " + this.jdkDirectory);
        }
        return this.jdkDirectory;
    }

    public List<DotClassPathEntry> getSourceRoots() {
        return this.cp.getSourceRoots();
    }

    public Set<EclipseProject> getProjects() {
        if (this.workspace != null && this.projectsWeDependOn == null) {
            this.projectsWeDependOn = new HashSet<EclipseProject>();
            for (DotClassPathEntry dotClassPathEntry : this.getClassPathEntries()) {
                EclipseProject eclipseProject;
                if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.PROJECT || (eclipseProject = this.workspace.getProjectByRawPath(dotClassPathEntry.getRawPath())) == null) continue;
                this.projectsWeDependOn.add(eclipseProject);
            }
        }
        return this.projectsWeDependOn == null ? Collections.emptySet() : this.projectsWeDependOn;
    }

    void resolveContainers(List<String> list, boolean bl) throws IOException {
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.CONTAINER) continue;
            ClassPathContainerResolver.resolve(this.workspace, dotClassPathEntry, list, bl);
        }
    }

    void replaceContainers() {
        ArrayList<DotClassPathEntry> arrayList = new ArrayList<DotClassPathEntry>();
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.CONTAINER) {
                arrayList.add(dotClassPathEntry);
                continue;
            }
            List<DotClassPathEntry> list = ClassPathContainerResolver.replaceContainerEntry(this, this.workspace, dotClassPathEntry, this.importProblems);
            if (list != null) {
                arrayList.addAll(list);
                continue;
            }
            arrayList.add(dotClassPathEntry);
        }
        this.cp.updateClasspath(arrayList);
    }

    void setupEnvironmentVariables(List<String> list) throws IOException {
        if (this.workspace == null) {
            return;
        }
        EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
        boolean bl = false;
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.VARIABLE) continue;
            String string = EclipseUtils.splitVariable(dotClassPathEntry.getRawPath())[0];
            Workspace.Variable variable = this.getVariable(string);
            if (variable != null) {
                string = "var." + PropertyUtils.getUsablePropertyName((String)string);
                if (editableProperties.getProperty(string) == null) {
                    editableProperties.setProperty(string, variable.getLocation());
                    bl = true;
                    continue;
                }
                if (editableProperties.getProperty(string).equals(variable.getLocation())) continue;
                list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_IDEVariableMismatch", (Object)string, (Object)editableProperties.getProperty(string), (Object)variable.getLocation()));
                continue;
            }
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_IDEVariableNotFound", (Object)string));
            editableProperties.setProperty(string, "");
            bl = true;
        }
        if (bl) {
            PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
        }
    }

    void convertFileVariablesToFolderVariables() {
        if (this.workspace == null) {
            return;
        }
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            String string;
            Workspace.Variable variable;
            if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.VARIABLE || (variable = this.getVariable(string = EclipseUtils.splitVariable(dotClassPathEntry.getRawPath())[0])) == null || !variable.isFileVariable()) continue;
            dotClassPathEntry.updateVariableValue(variable.getName() + '/' + variable.getFileName());
        }
    }

    private void updateSourcePathAttribute() {
        if (this.workspace == null) {
            return;
        }
        block0: for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            String string = dotClassPathEntry.getProperty("sourcepath");
            if (string == null) continue;
            String string2 = this.resolvePath(string);
            if (string2 != null) {
                dotClassPathEntry.updateSourcePath(string2);
                continue;
            }
            for (Workspace.Variable variable : this.workspace.getVariables()) {
                if (!string.startsWith(variable.getName())) continue;
                String[] stringArray = EclipseUtils.splitVariable(string);
                dotClassPathEntry.updateSourcePath("${" + stringArray[0] + "}" + stringArray[1]);
                continue block0;
            }
        }
    }

    private void updateJavaDocLocationAttribute() {
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            Object object;
            String string = dotClassPathEntry.getProperty("javadoc_location");
            if (string == null) continue;
            String string2 = null;
            if (string.startsWith("jar:")) {
                string2 = string.substring(string.indexOf("!/"));
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string = string.substring(4, string.indexOf("!/"));
            }
            if (string.startsWith("platform:/resource") && (object = this.resolvePath(string.substring(18))) != null) {
                dotClassPathEntry.updateJavadoc((String)object);
                continue;
            }
            if (string.startsWith("platform")) {
                this.importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedProtocol", (Object)string));
                continue;
            }
            if (string.indexOf("file://") > -1 && string.indexOf("file:////") == -1) {
                string = string.replaceFirst("file://", "file:////");
            }
            try {
                object = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedJavadocLocation", (Object)string));
                continue;
            }
            if (!"file".equals(((URL)object).getProtocol())) {
                this.importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedProtocol", (Object)((URL)object).toExternalForm()));
                continue;
            }
            try {
                File file = new File(((URL)object).toURI());
                String string3 = file.getPath();
                if (string2 != null) {
                    string3 = string3 + string2;
                }
                dotClassPathEntry.updateJavadoc(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_JavadocCannotBeResolved", (Object)((URL)object).toExternalForm()));
            }
        }
    }

    public List<String> getImportProblems() {
        return this.importProblems;
    }

    private void calculateAbsolutePaths() {
        for (DotClassPathEntry dotClassPathEntry : this.cp.getClassPathEntries()) {
            this.setAbsolutePathForEntry(dotClassPathEntry);
        }
        for (DotClassPathEntry dotClassPathEntry : this.cp.getSourceRoots()) {
            this.setAbsolutePathForEntry(dotClassPathEntry);
        }
        this.setAbsolutePathForEntry(this.cp.getOutput());
    }

    public DotClassPathEntry getOutput() {
        return this.cp.getOutput();
    }

    private void setAbsolutePathForEntry(DotClassPathEntry dotClassPathEntry) {
        if (dotClassPathEntry == null) {
            return;
        }
        dotClassPathEntry.setAbsolutePath(null);
        if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.CONTAINER) {
            return;
        }
        if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.VARIABLE) {
            String[] stringArray = EclipseUtils.splitVariable(dotClassPathEntry.getRawPath());
            Workspace.Variable variable = this.getVariable(stringArray[0]);
            if (variable != null) {
                dotClassPathEntry.setAbsolutePath(variable.getLocation() + stringArray[1]);
            } else {
                logger.warning("cannot resolve variable '" + stringArray[0] + "'. used in project " + this.getProjectFile().getPath() + " in entry " + dotClassPathEntry);
            }
            return;
        }
        if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.PROJECT) {
            if (this.workspace != null) {
                dotClassPathEntry.setAbsolutePath(this.workspace.getProjectAbsolutePath(dotClassPathEntry.getRawPath().substring(1)));
            }
            return;
        }
        if (!new File(dotClassPathEntry.getRawPath()).isAbsolute()) {
            dotClassPathEntry.setAbsolutePath(this.projectDir.getAbsolutePath() + File.separator + dotClassPathEntry.getRawPath());
        } else {
            String string;
            String string2 = dotClassPathEntry.getRawPath();
            if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.LIBRARY && this.workspace != null && (string = this.resolvePath(dotClassPathEntry.getRawPath())) != null) {
                string2 = string;
            }
            dotClassPathEntry.setAbsolutePath(string2);
        }
    }

    private String resolvePath(String string) {
        String[] stringArray;
        String string2;
        File file = new File(string);
        if (string.startsWith("/") && !file.exists() && (string2 = this.workspace.getProjectAbsolutePath((stringArray = EclipseUtils.splitProject(string))[0])) != null) {
            return string2 + stringArray[1];
        }
        return null;
    }

    private Workspace.Variable getVariable(String string) {
        if (this.workspace == null) {
            logger.fine("Workspace wasn't set for the project \"" + this.getName() + "\"");
            return null;
        }
        return this.workspace.getVariable(string);
    }

    public String toString() {
        return "EclipseProject[" + this.getName() + ", " + this.getDirectory() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EclipseProject)) {
            return false;
        }
        EclipseProject eclipseProject = (EclipseProject)object;
        return this.name.equals(eclipseProject.name);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + System.identityHashCode(this.name);
        return n;
    }

    public int compareTo(Object object) {
        String string = this.getName();
        String string2 = null;
        if (object instanceof EclipseProject) {
            string2 = ((EclipseProject)object).getName();
        }
        if (string2 == null) {
            return string == null ? 0 : -1;
        }
        return string == null ? 1 : string.compareToIgnoreCase(string2);
    }
}

