/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.Util;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DotClassPathParser {
    private DotClassPathParser() {
    }

    public static DotClassPath parse(File file, List<Link> list) throws IOException {
        Document document;
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"classpath".equals(element.getLocalName())) {
            return DotClassPathParser.empty();
        }
        List<Element> list2 = Util.findSubElements(element);
        if (list2 == null) {
            return DotClassPathParser.empty();
        }
        ArrayList<DotClassPathEntry> arrayList = new ArrayList<DotClassPathEntry>();
        ArrayList<DotClassPathEntry> arrayList2 = new ArrayList<DotClassPathEntry>();
        Object object = null;
        Object object2 = null;
        for (Element element2 : list2) {
            Object object3;
            Object object4;
            Object object5;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            NamedNodeMap namedNodeMap = element2.getAttributes();
            Object object6 = null;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                object5 = namedNodeMap.item(i);
                object4 = object5.getNodeName();
                object3 = element2.getAttribute(object5.getNodeName());
                if ("path".equals(object4) && (string = DotClassPathParser.resolveLink((String)object3, list)) != null) {
                    object6 = object3;
                    object3 = string;
                }
                hashMap.put((String)object4, (String)object3);
            }
            Element element3 = Util.findElement(element2, "attributes", null);
            if (element3 != null && (object5 = Util.findSubElements(element3)) != null) {
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (Element)object4.next();
                    hashMap.put(object3.getAttribute("name"), object3.getAttribute("value"));
                }
            }
            if (((DotClassPathEntry)(object5 = new DotClassPathEntry((Map<String, String>)hashMap, (String)object6))).getKind() == DotClassPathEntry.Kind.SOURCE) {
                arrayList2.add((DotClassPathEntry)object5);
                continue;
            }
            if (((DotClassPathEntry)object5).getKind() == DotClassPathEntry.Kind.OUTPUT) {
                assert (object == null) : "there should be always just one default output";
                object = object5;
                continue;
            }
            if (((DotClassPathEntry)object5).getKind() == DotClassPathEntry.Kind.CONTAINER && ((DotClassPathEntry)object5).getRawPath().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                object2 = object5;
                continue;
            }
            arrayList.add((DotClassPathEntry)object5);
        }
        return new DotClassPath((List<DotClassPathEntry>)arrayList, (List<DotClassPathEntry>)arrayList2, (DotClassPathEntry)object, (DotClassPathEntry)object2);
    }

    static DotClassPath empty() {
        return new DotClassPath(new ArrayList<DotClassPathEntry>(), new ArrayList<DotClassPathEntry>(), null, null);
    }

    private static String resolveLink(String string, List<Link> list) {
        for (Link link : list) {
            if (!link.getName().equals(string)) continue;
            return link.getLocation();
        }
        return null;
    }
}

