/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.output;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.print.PrintManager;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.impl.ui.Export;
import org.netbeans.modules.xml.ui.UI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Tree
extends JTree {
    private String myText;
    private Export myExport;
    private boolean myIsReformAll;
    private DefaultMutableTreeNode myRoot = (DefaultMutableTreeNode)this.getModel().getRoot();
    private List<DefaultMutableTreeNode> myOccurences;
    private static final int POPUP_MENU_X = 16;
    private static final int POPUP_MENU_Y = 16;
    private static final Icon EMPTY = UI.icon(Tree.class, "empty");

    Tree() {
        super(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    void addElement(SearchElement searchElement) {
        this.addElement(this.myRoot, searchElement, this.getParents(searchElement));
    }

    private void addElement(MutableTreeNode mutableTreeNode, SearchElement searchElement, Iterator<SearchElement> iterator) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        SearchElement searchElement2 = null;
        if (iterator.hasNext()) {
            searchElement2 = iterator.next();
        }
        if (searchElement2 == null) {
            mutableTreeNode.insert(new DefaultMutableTreeNode(searchElement), 0);
            return;
        }
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isLeaf() || Tree.getUserObject(defaultMutableTreeNode) != searchElement2) continue;
            this.addElement(defaultMutableTreeNode, searchElement, iterator);
            return;
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode(searchElement2);
        mutableTreeNode.insert(defaultMutableTreeNode, 0);
        this.addElement(defaultMutableTreeNode, searchElement, iterator);
    }

    void finished(String string, String string2, int n) {
        this.myText = UI.i18n(Tree.class, "LBL_Search_Tab", string, string2);
        String string3 = UI.i18n(Tree.class, "LBL_Root", string, string2, "" + n);
        String string4 = UI.i18n(Tree.class, "TXT_Root", string, string2, "" + n);
        String string5 = UI.getHtml(string3);
        this.myRoot.setUserObject(new SearchElement.Adapter(string3, string5, UI.icon(Tree.class, "find"), null));
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.name", string4);
        this.createOccurences();
        this.updateRoot();
        this.expose(this.myRoot);
    }

    @Override
    public String toString() {
        return this.myText;
    }

    private void createOccurences() {
        this.myOccurences = new LinkedList<DefaultMutableTreeNode>();
        this.createOccurences(this.myRoot);
    }

    private void createOccurences(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (defaultMutableTreeNode.isLeaf() && !defaultMutableTreeNode.isRoot()) {
            this.myOccurences.add(defaultMutableTreeNode);
        }
        while (enumeration.hasMoreElements()) {
            this.createOccurences((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    private void updateRoot() {
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TreeRenderer());
        this.setShowsRootHandles(false);
        this.setRootVisible(true);
        this.setSelectionPath(new TreePath(this.myRoot.getPath()));
        this.expandPath(new TreePath(this.myRoot.getPath()));
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.collapseChildren(Tree.this.getNode(treeExpansionEvent.getPath()));
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.expandChildren(Tree.this.getNode(treeExpansionEvent.getPath()));
                Tree.this.updateSize();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.updateSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Tree.this.showPopupMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && Tree.this.getSelectedNode().isLeaf()) {
                    Tree.getUserObject(Tree.this.getSelectedNode()).gotoVisual();
                    mouseEvent.consume();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Tree.this.handleEvent(keyEvent);
            }
        });
        this.updateSize();
    }

    private void handleEvent(KeyEvent keyEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (n2 == 121 && UI.isShift(n)) {
            this.showPopupMenu(keyEvent, 16, 16);
        } else if (n2 == 123 && UI.isShift(n)) {
            this.previousOccurence(defaultMutableTreeNode);
        } else if (n2 == 123) {
            this.nextOccurence(defaultMutableTreeNode);
        } else if (n2 == 127) {
            this.remove(defaultMutableTreeNode);
        }
    }

    private void showPopupMenu(ComponentEvent componentEvent, int n, int n2) {
        final DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.createAction(jPopupMenu, defaultMutableTreeNode);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = this.createItem("LBL_Remove");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot());
        jMenuItem.setIcon(EMPTY);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.remove(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = this.createItem("LBL_Previous_Occurence");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(UI.icon(Tree.class, "previous"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.previousOccurence(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 1));
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Next_Occurence");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(UI.icon(Tree.class, "next"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.nextOccurence(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = this.createItem("LBL_Export");
        jMenuItem.setIcon(UI.icon(Tree.class, "export"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.export(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Print_Preview");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(this.getPrintIcon());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.printAction((JComponent)Tree.this).actionPerformed(actionEvent);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 11));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(componentEvent.getComponent(), n, n2);
    }

    private void createAction(JPopupMenu jPopupMenu, final DefaultMutableTreeNode defaultMutableTreeNode) {
        JMenuItem jMenuItem = this.createItem("LBL_Go_to_Visual");
        jMenuItem.setIcon(EMPTY);
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot() && !Tree.getUserObject(defaultMutableTreeNode).isDeleted());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.getUserObject(defaultMutableTreeNode).gotoVisual();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Go_to_Source");
        jMenuItem.setIcon(EMPTY);
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot() && !Tree.getUserObject(defaultMutableTreeNode).isDeleted());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.getUserObject(defaultMutableTreeNode).gotoSource();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Copy");
        jMenuItem.setIcon(UI.icon(Tree.class, "copy"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.copy(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Collapse_Expand");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isLeaf());
        jMenuItem.setIcon(UI.icon(Tree.class, "expose"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.expose(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
    }

    private Icon getPrintIcon() {
        Object object = PrintManager.printAction((JComponent)this).getValue("SmallIcon");
        if (object instanceof Icon) {
            return (Icon)object;
        }
        return EMPTY;
    }

    private void updateSize() {
        this.putClientProperty(Dimension.class, this.getMaximumSize());
    }

    void previousOccurence() {
        this.previousOccurence(this.getSelectedNode());
    }

    private void previousOccurence(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.isLeaf() ? this.myOccurences.indexOf(defaultMutableTreeNode) - 1 : this.myOccurences.indexOf(this.getNearestChild(defaultMutableTreeNode)) - 1;
        this.select(n);
    }

    void nextOccurence() {
        this.nextOccurence(this.getSelectedNode());
    }

    private void nextOccurence(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.isLeaf() ? this.myOccurences.indexOf(defaultMutableTreeNode) + 1 : this.myOccurences.indexOf(this.getNearestChild(defaultMutableTreeNode));
        this.select(n);
    }

    private DefaultMutableTreeNode getNearestChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        for (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode2 != null && !defaultMutableTreeNode2.isLeaf(); defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild()) {
        }
        return defaultMutableTreeNode2;
    }

    private void select(int n) {
        if (0 <= n && n < this.myOccurences.size()) {
            this.select(this.myOccurences.get(n));
        }
    }

    private void select(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        this.requestFocus();
    }

    private void copy(TreeNode treeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        this.copy(treeNode, stringBuffer, "");
        UI.copyToClipboard(stringBuffer.toString());
    }

    private void copy(TreeNode treeNode, StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + UI.removeHtml(Tree.getUserObject(treeNode).getName()) + UI.LS);
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            this.copy(treeNode2, stringBuffer, string + "    ");
        }
    }

    void export() {
        this.export(this.getSelectedNode());
    }

    private void export(DefaultMutableTreeNode defaultMutableTreeNode) {
        LinkedList<List<String>> linkedList = new LinkedList<List<String>>();
        this.export(defaultMutableTreeNode, linkedList);
        linkedList.add(null);
        if (this.myExport == null) {
            this.myExport = new Export();
        }
        this.myExport.show(linkedList, this.myRoot.toString());
        this.requestFocus();
    }

    private void export(DefaultMutableTreeNode defaultMutableTreeNode, List<List<String>> list) {
        Object object;
        if (defaultMutableTreeNode.isLeaf()) {
            object = new LinkedList();
            object.add(this.getDescription(defaultMutableTreeNode));
            object.add(defaultMutableTreeNode.toString());
            list.add((List<String>)object);
        }
        object = defaultMutableTreeNode.children();
        while (object.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.nextElement();
            this.export(defaultMutableTreeNode2, list);
        }
    }

    private String getDescription(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.isRoot()) {
            return "";
        }
        String string = this.getDescription((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
        if (!defaultMutableTreeNode.isLeaf()) {
            if (!((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).isRoot()) {
                string = string + UI.LS;
            }
            string = string + defaultMutableTreeNode;
        }
        return string;
    }

    void expose() {
        this.expose(this.getSelectedNode());
    }

    private void expose(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.isLeaf()) {
            return;
        }
        this.myIsReformAll = true;
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        boolean bl = this.isExpanded(treePath);
        if (defaultMutableTreeNode.isRoot()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            bl = false;
            while (enumeration.hasMoreElements() && !(bl = this.isExpanded(new TreePath((defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement()).getPath())))) {
            }
        }
        if (bl) {
            if (defaultMutableTreeNode.isRoot()) {
                this.collapseChildren(defaultMutableTreeNode);
            } else {
                this.collapsePath(treePath);
            }
        } else {
            this.expandPath(treePath);
            if (this.isExpanded(treePath)) {
                this.expandChildren(defaultMutableTreeNode);
            }
        }
        this.myIsReformAll = false;
        this.requestFocus();
    }

    private void expandChildren(TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        if (this.myIsReformAll) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.expandPath(treePath);
                if (!this.isExpanded(treePath)) continue;
                this.expandChildren(defaultMutableTreeNode);
            }
        } else if (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) {
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.expandPath(treePath);
                if (this.isExpanded(treePath)) {
                    this.expandChildren(defaultMutableTreeNode);
                }
            }
        }
    }

    private void collapseChildren(TreeNode treeNode) {
        if (this.myIsReformAll) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.collapsePath(treePath);
            }
        }
    }

    private void remove(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getParent() == null) {
            return;
        }
        if (UI.printConfirmation(UI.i18n(Tree.class, "LBL_Are_You_Sure"))) {
            this.select(this.removeParent(defaultMutableTreeNode));
            this.updateUI();
        }
        this.requestFocus();
    }

    private DefaultMutableTreeNode removeParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 == null) {
            return null;
        }
        defaultMutableTreeNode2.remove(defaultMutableTreeNode);
        this.myOccurences.remove(defaultMutableTreeNode);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
        if (enumeration.hasMoreElements()) {
            return defaultMutableTreeNode2;
        }
        return this.removeParent(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return this.myRoot;
        }
        TreePath treePath = treePathArray[0];
        if (treePath == null) {
            return this.myRoot;
        }
        return this.getNode(treePath);
    }

    private JMenuItem createItem(String string) {
        return new JMenuItem(UI.i18n(Tree.class, string));
    }

    private Iterator<SearchElement> getParents(SearchElement searchElement) {
        LinkedList<SearchElement> linkedList = new LinkedList<SearchElement>();
        for (SearchElement searchElement2 = searchElement.getParent(); searchElement2 != null; searchElement2 = searchElement2.getParent()) {
            linkedList.add(0, searchElement2);
        }
        return linkedList.iterator();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        if (object != null && (string = object.toString()) != null) {
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                return string;
            }
            return string.substring(n2 + 1);
        }
        return "";
    }

    private static SearchElement getUserObject(Object object) {
        return (SearchElement)((DefaultMutableTreeNode)object).getUserObject();
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        private TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SearchElement searchElement = Tree.getUserObject(object);
            this.setText(UI.getHtml(this.getHtmlName(searchElement.getName(), bl3, n)));
            this.setToolTipText(searchElement.getToolTip());
            this.setIcon(searchElement.getIcon());
            return this;
        }

        private String getHtmlName(String string, boolean bl, int n) {
            if (n == 0) {
                return string;
            }
            if (bl) {
                int n2 = string.lastIndexOf(".");
                if (n2 == -1) {
                    return this.getBold(string);
                }
                return this.getGrey(string.substring(0, n2 + 1)) + this.getBold(string.substring(n2 + 1));
            }
            return this.getGrey(string);
        }

        private String getGrey(String string) {
            return "<font color=\"#999999\">" + string + "</font>";
        }

        private String getBold(String string) {
            return "<b>" + string + "</b>";
        }
    }
}

