/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerXMLCatalog
extends JPanel
implements HelpCtx.Provider {
    private Project project;
    private CatalogWriteModel cwm;
    private List<CatalogEntry> cEntries = Collections.emptyList();
    private List<CatalogEntry> deletedEntries;
    private JLabel cacheLabel;
    private JTextField cacheTextField;
    private JTable catalogTable;
    private JButton clearCacheButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JLabel topLabel;

    public CustomizerXMLCatalog(Project project) {
        this.project = project;
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        try {
            CatalogEntry catalogEntry2;
            this.cwm = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(this.project.getProjectDirectory());
            this.cEntries = new ArrayList<CatalogEntry>(this.cwm.getCatalogEntries());
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.catalogTable.getModel();
            for (CatalogEntry catalogEntry2 : this.cEntries) {
                defaultTableModel.addRow(new String[]{catalogEntry2.getSource(), catalogEntry2.getTarget()});
            }
            this.catalogTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                }

                public void columnMarginChanged(ChangeEvent changeEvent) {
                }

                public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                    if (CustomizerXMLCatalog.this.catalogTable.getSelectedColumnCount() == 0) {
                        CustomizerXMLCatalog.this.removeButton.setEnabled(false);
                    } else {
                        CustomizerXMLCatalog.this.removeButton.setEnabled(true);
                    }
                }
            });
            FileObject fileObject = this.cwm.getCatalogFileObject();
            if (fileObject == null) {
                return;
            }
            catalogEntry2 = DataObject.find((FileObject)fileObject);
            if (catalogEntry2 == null) {
                return;
            }
            SaveCookie saveCookie = (SaveCookie)catalogEntry2.getCookie(SaveCookie.class);
            if (saveCookie == null) {
                return;
            }
            saveCookie.save();
        }
        catch (IOException iOException) {
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.topLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.catalogTable = new JTable();
        this.removeButton = new JButton();
        this.cacheLabel = new JLabel();
        this.cacheTextField = new JTextField();
        this.clearCacheButton = new JButton();
        this.topLabel.setLabelFor(this.catalogTable);
        Mnemonics.setLocalizedText((JLabel)this.topLabel, (String)NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_CatalogEntries"));
        this.topLabel.setToolTipText(NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"HINT_CustomizerXMLCatalog_CatalogEntries"));
        this.catalogTable.setModel(new DefaultTableModel(new String[0][], new String[]{NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_ReferenceKey"), NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_ReferencedLocation")}));
        this.jScrollPane1.setViewportView(this.catalogTable);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_RemoveButton"));
        this.removeButton.setToolTipText(NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"HINT_CustomizerXMLCatalog_RemoveButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerXMLCatalog.this.deleteEntry(actionEvent);
            }
        });
        this.cacheLabel.setLabelFor(this.cacheTextField);
        Mnemonics.setLocalizedText((JLabel)this.cacheLabel, (String)NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_CacheLabel"));
        this.cacheLabel.setToolTipText(NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"HINT_CustomizerXMLCatalog_CacheLabel"));
        this.cacheTextField.setEditable(false);
        this.cacheTextField.setText("nbproject/private/retrieved");
        this.cacheTextField.setBorder(null);
        Mnemonics.setLocalizedText((AbstractButton)this.clearCacheButton, (String)NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"LBL_CustomizerXMLCatalog_ClearCacheButton"));
        this.clearCacheButton.setToolTipText(NbBundle.getMessage(CustomizerXMLCatalog.class, (String)"HINT_CustomizerXMLCatalog_ClearCacheButton"));
        this.clearCacheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerXMLCatalog.this.clearCacheDirectory(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.topLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cacheLabel).addPreferredGap(0).add((Component)this.cacheTextField, -1, 221, Short.MAX_VALUE)).add(2, (Component)this.jScrollPane1, -1, 302, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.removeButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.clearCacheButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.topLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.removeButton).add((Component)this.jScrollPane1, -1, 216, Short.MAX_VALUE)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.cacheLabel).add((Component)this.cacheTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.clearCacheButton).addContainerGap()));
    }

    private void deleteEntry(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.catalogTable.getModel();
        int[] nArray = this.catalogTable.getSelectedRows();
        if (this.deletedEntries == null) {
            this.deletedEntries = new ArrayList<CatalogEntry>(nArray.length);
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            defaultTableModel.removeRow(n);
            this.deletedEntries.add(this.cEntries.remove(n));
        }
        this.catalogTable.clearSelection();
    }

    private void clearCacheDirectory(ActionEvent actionEvent) {
    }

    public void storeProjectData() {
        if (this.deletedEntries != null && this.cwm != null) {
            for (CatalogEntry catalogEntry : this.deletedEntries) {
                try {
                    URI uRI = new URI(catalogEntry.getSource());
                    this.cwm.removeURI(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerXMLCatalog.class);
    }
}

