/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.modules.project.libraries.ui.NewLibraryPanel;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibrariesCustomizer
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager manager;
    private LibrariesModel model = new LibrariesModel();
    private BeanTreeView libraries;
    private LibraryStorageArea libraryStorageArea;
    private JButton createButton;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField libraryLocation;
    private JTextField libraryName;
    private JPanel libsPanel;
    private JTabbedPane properties;

    public LibrariesCustomizer(LibraryStorageArea libraryStorageArea) {
        this.libraryStorageArea = libraryStorageArea != null ? libraryStorageArea : LibrariesModel.GLOBAL_AREA;
        this.initComponents();
        this.postInitComponents();
        this.expandTree();
    }

    private void expandTree() {
        Node[] nodeArray;
        Node[] nodeArray2 = this.getExplorerManager().getRootContext().getChildren().getNodes();
        if (nodeArray2.length != 0 && (nodeArray = nodeArray2[0].getChildren().getNodes()).length != 0) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{nodeArray[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void setLibraryStorageArea(LibraryStorageArea libraryStorageArea) {
        this.libraryStorageArea = libraryStorageArea != null ? libraryStorageArea : LibrariesModel.GLOBAL_AREA;
        this.forceTreeRecreation();
        this.expandTree();
    }

    public LibrariesModel getModel() {
        return this.model;
    }

    public void hideLibrariesList() {
        this.libsPanel.setVisible(false);
        this.jLabel2.setVisible(false);
        this.createButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.jLabel3.setVisible(true);
        this.libraryLocation.setVisible(true);
    }

    public void forceTreeRecreation() {
        this.getExplorerManager().setRootContext(this.buildTree());
    }

    public void setSelectedLibrary(LibraryImplementation libraryImplementation) {
        if (libraryImplementation == null) {
            return;
        }
        ExplorerManager explorerManager = this.getExplorerManager();
        Node node = explorerManager.getRootContext();
        String[] stringArray = new String[]{libraryImplementation.getType(), libraryImplementation.getName()};
        try {
            Node node2 = NodeOp.findPath((Node)node, (String[])stringArray);
            if (node2 != null) {
                explorerManager.setSelectedNodes(new Node[]{node2});
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesCustomizer.class);
    }

    public boolean apply() {
        try {
            this.model.apply();
            return true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        LibrariesCustomizer.expandAllNodes(this.libraries, this.getExplorerManager().getRootContext());
        if (this.getExplorerManager().getSelectedNodes().length == 0) {
            block2: for (Node node : this.getExplorerManager().getRootContext().getChildren().getNodes(true)) {
                Node[] nodeArray = node.getChildren().getNodes(true);
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = 0;
                    Node node2 = nodeArray[i];
                    Node[] nodeArray2 = node2.getChildren().getNodes(true);
                    int n3 = nodeArray2.length;
                    if (n2 >= n3) continue;
                    Node node3 = nodeArray2[n2];
                    try {
                        this.getExplorerManager().setSelectedNodes(new Node[]{node3});
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break block2;
                }
            }
        }
        this.libraries.requestFocus();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                        LibrariesCustomizer.this.selectLibrary(nodeArray);
                        LibrariesCustomizer.this.libraries.requestFocus();
                    }
                }
            });
            this.manager.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                        if (nodeArray.length <= 1) {
                            return;
                        }
                        throw new PropertyVetoException("Invalid length", propertyChangeEvent);
                    }
                }
            });
            this.manager.setRootContext(this.buildTree());
        }
        return this.manager;
    }

    private void postInitComponents() {
        this.libraries = new LibrariesView();
        this.libsPanel.setLayout(new BorderLayout());
        this.libsPanel.add((Component)this.libraries);
        this.libraries.setPreferredSize(new Dimension(200, 334));
        this.libraryName.setColumns(25);
        this.libraryName.setEnabled(false);
        this.libraryName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.nameChanged();
            }
        });
        this.jLabel3.setVisible(false);
        this.libraryLocation.setVisible(false);
    }

    private void nameChanged() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1) {
            LibraryImplementation libraryImplementation = (LibraryImplementation)nodeArray[0].getLookup().lookup(LibraryImplementation.class);
            if (libraryImplementation == null) {
                return;
            }
            String string = this.libraryName.getText();
            if (string.equals(libraryImplementation.getName())) {
                return;
            }
            if (string.length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(LibrariesCustomizer.class, (String)"ERR_InvalidName"), 0));
            } else if (LibrariesCustomizer.isValidName(this.model, string, this.model.getArea(libraryImplementation))) {
                libraryImplementation.setName(string);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(LibrariesCustomizer.class, (String)"ERR_ExistingName", (Object)string), 0));
            }
        }
    }

    private void selectLibrary(Node[] nodeArray) {
        Object object;
        LibraryCustomizerContextWrapper libraryCustomizerContextWrapper;
        int n = this.properties.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.properties.removeTabAt(0);
        }
        this.libraryName.setEnabled(false);
        this.libraryName.setText("");
        this.jLabel1.setVisible(false);
        this.libraryName.setVisible(false);
        this.properties.setVisible(false);
        this.deleteButton.setEnabled(false);
        if (nodeArray.length != 1) {
            return;
        }
        LibraryImplementation libraryImplementation = (LibraryImplementation)nodeArray[0].getLookup().lookup(LibraryImplementation.class);
        if (libraryImplementation == null) {
            return;
        }
        this.jLabel1.setVisible(true);
        this.libraryName.setVisible(true);
        this.properties.setVisible(true);
        boolean bl = this.model.isLibraryEditable(libraryImplementation);
        this.libraryName.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.libraryName.setText(LibrariesCustomizer.getLocalizedString(libraryImplementation.getLocalizingBundle(), libraryImplementation.getName()));
        LibraryTypeProvider libraryTypeProvider = (LibraryTypeProvider)nodeArray[0].getLookup().lookup(LibraryTypeProvider.class);
        if (libraryTypeProvider == null) {
            return;
        }
        LibraryStorageArea libraryStorageArea = (LibraryStorageArea)nodeArray[0].getLookup().lookup(LibraryStorageArea.class);
        if (libraryStorageArea != null && libraryStorageArea != LibrariesModel.GLOBAL_AREA) {
            libraryCustomizerContextWrapper = new LibraryCustomizerContextWrapper(libraryImplementation, libraryStorageArea);
            object = new File(URI.create(libraryStorageArea.getLocation().toExternalForm()));
            this.libraryLocation.setText(((File)object).getPath());
        } else {
            libraryCustomizerContextWrapper = new LibraryCustomizerContextWrapper(libraryImplementation, null);
            this.libraryLocation.setText(NbBundle.getMessage(LibrariesCustomizer.class, (String)"LABEL_Global_Libraries"));
        }
        object = libraryTypeProvider.getSupportedVolumeTypes();
        for (int i = 0; i < ((String[])object).length; ++i) {
            Customizer customizer = libraryTypeProvider.getCustomizer((String)object[i]);
            if (!(customizer instanceof JComponent)) continue;
            customizer.setObject(libraryCustomizerContextWrapper);
            JComponent jComponent = (JComponent)((Object)customizer);
            jComponent.setEnabled(bl);
            Object object2 = jComponent.getName();
            if (object2 == null) {
                object2 = object[i];
            }
            this.properties.addTab((String)object2, jComponent);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryName = new JTextField();
        this.createButton = new JButton();
        this.deleteButton = new JButton();
        this.libsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.properties = new JTabbedPane();
        this.jLabel3 = new JLabel();
        this.libraryLocation = new JTextField();
        this.setMinimumSize(new Dimension(642, 395));
        this.jLabel1.setLabelFor(this.libraryName);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("CTL_CustomizerLibraryName"));
        this.libraryName.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)resourceBundle.getString("CTL_NewLibrary"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.createLibrary(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)resourceBundle.getString("CTL_DeleteLibrary"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.deleteLibrary(actionEvent);
            }
        });
        this.libsPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout groupLayout = new GroupLayout((Container)this.libsPanel);
        this.libsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 190, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 342, Short.MAX_VALUE));
        this.jLabel2.setLabelFor(this.libsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("TXT_LibrariesPanel"));
        this.properties.setPreferredSize(new Dimension(400, 300));
        this.jLabel3.setLabelFor(this.libraryLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("CTL_CustomizerLibraryLocationName"));
        this.libraryLocation.setEditable(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel2, -2, 103, -2).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.createButton).addPreferredGap(0).add((Component)this.deleteButton)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.libsPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.libraryLocation, -1, 358, Short.MAX_VALUE).add((Component)this.libraryName, -1, 358, Short.MAX_VALUE))).add((Component)this.properties, -1, 442, Short.MAX_VALUE)).addPreferredGap(0))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.libraryName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.libraryLocation, -2, -1, -2)).addPreferredGap(0).add((Component)this.properties, -1, 294, Short.MAX_VALUE)).add((Component)this.libsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.createButton).add((Component)this.deleteButton))));
        this.libraryName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_LibraryName"));
        this.createButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_NewLibrary"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_DeleteLibrary"));
        this.libsPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_libsPanel"));
        this.properties.getAccessibleContext().setAccessibleName(resourceBundle.getString("AN_LibrariesCustomizerProperties"));
        this.properties.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_LibrariesCustomizerProperties"));
        this.libraryLocation.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_LibraryLocation"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_LibrariesCustomizer"));
    }

    private void deleteLibrary(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1) {
            LibraryImplementation libraryImplementation = (LibraryImplementation)nodeArray[0].getLookup().lookup(LibraryImplementation.class);
            if (libraryImplementation == null) {
                return;
            }
            Node[] nodeArray2 = nodeArray[0].getParentNode().getChildren().getNodes(true);
            Node node = null;
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (!nodeArray[0].equals((Object)nodeArray2[i])) continue;
                if (i > 0) {
                    node = nodeArray2[i - 1];
                    continue;
                }
                if (i >= nodeArray2.length - 1) continue;
                node = nodeArray2[i + 1];
            }
            this.model.removeLibrary(libraryImplementation);
            try {
                if (node != null) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.libraries.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLibrary(ActionEvent actionEvent) {
        block16: {
            Window window = null;
            try {
                Object object;
                String string = null;
                LibraryStorageArea libraryStorageArea = null;
                Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
                if (nodeArray.length == 1) {
                    object = (LibraryTypeProvider)nodeArray[0].getLookup().lookup(LibraryTypeProvider.class);
                    if (object != null) {
                        string = object.getLibraryType();
                    }
                    libraryStorageArea = (LibraryStorageArea)nodeArray[0].getLookup().lookup(LibraryStorageArea.class);
                }
                if (libraryStorageArea == null) {
                    libraryStorageArea = LibrariesModel.GLOBAL_AREA;
                }
                object = new NewLibraryPanel(this.model, string, libraryStorageArea);
                DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(LibrariesCustomizer.class, (String)"CTL_CreateLibrary"), true, 2, null, null);
                ((NewLibraryPanel)object).setDialogDescriptor(dialogDescriptor);
                window = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                ((Dialog)window).setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    String[] stringArray;
                    LibraryImplementation libraryImplementation;
                    String string2 = ((NewLibraryPanel)object).getLibraryType();
                    String string3 = ((NewLibraryPanel)object).getLibraryName();
                    if (libraryStorageArea != LibrariesModel.GLOBAL_AREA) {
                        libraryImplementation = this.model.createArealLibrary(string2, string3, libraryStorageArea);
                    } else {
                        stringArray = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string2);
                        if (stringArray == null) {
                            return;
                        }
                        libraryImplementation = stringArray.createLibrary();
                        libraryImplementation.setName(string3);
                    }
                    this.model.addLibrary(libraryImplementation);
                    this.forceTreeRecreation();
                    stringArray = new String[]{libraryImplementation.getType(), libraryImplementation.getName()};
                    ExplorerManager explorerManager = this.getExplorerManager();
                    try {
                        Node node = NodeOp.findPath((Node)explorerManager.getRootContext(), (String[])stringArray);
                        if (node != null) {
                            explorerManager.setSelectedNodes(new Node[]{node});
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                    this.libraryName.requestFocus();
                    this.libraryName.selectAll();
                    break block16;
                }
                this.libraries.requestFocus();
            }
            finally {
                if (window != null) {
                    window.dispose();
                }
            }
        }
    }

    static boolean isValidName(LibrariesModel librariesModel, String string, LibraryStorageArea libraryStorageArea) {
        for (LibraryImplementation libraryImplementation : librariesModel.getLibraries()) {
            if (!libraryImplementation.getName().equals(string) || !Utilities.compareObjects((Object)librariesModel.getArea(libraryImplementation), (Object)libraryStorageArea)) continue;
            return false;
        }
        return true;
    }

    static String getLocalizedString(String string, String string2) {
        ResourceBundle resourceBundle;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        try {
            resourceBundle = NbBundle.getBundle((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
            return string2;
        }
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private static void expandAllNodes(BeanTreeView beanTreeView, Node node) {
        beanTreeView.expandNode(node);
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            LibrariesCustomizer.expandAllNodes(beanTreeView, nodeArray[i]);
        }
    }

    static Collection<? extends LibraryStorageArea> getSortedAreas(LibrariesModel librariesModel) {
        ArrayList<? extends LibraryStorageArea> arrayList = new ArrayList<LibraryStorageArea>(librariesModel.getAreas());
        Collections.sort(arrayList, new Comparator<LibraryStorageArea>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(LibraryStorageArea libraryStorageArea, LibraryStorageArea libraryStorageArea2) {
                return this.COLL.compare(libraryStorageArea.getDisplayName(), libraryStorageArea2.getDisplayName());
            }
        });
        arrayList.add(0, LibrariesModel.GLOBAL_AREA);
        assert (!arrayList.contains(null));
        return arrayList;
    }

    private Node buildTree() {
        return new AbstractNode((Children)new TypeChildren(this.libraryStorageArea));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryCustomizerContextWrapper
    extends LibraryCustomizerContext
    implements LibraryImplementation {
        public LibraryCustomizerContextWrapper(LibraryImplementation libraryImplementation, LibraryStorageArea libraryStorageArea) {
            super(libraryImplementation, libraryStorageArea);
        }

        @Override
        public String getType() {
            return this.getLibraryImplementation().getType();
        }

        @Override
        public String getName() {
            return this.getLibraryImplementation().getName();
        }

        @Override
        public String getDescription() {
            return this.getLibraryImplementation().getDescription();
        }

        @Override
        public String getLocalizingBundle() {
            return this.getLibraryImplementation().getLocalizingBundle();
        }

        @Override
        public List<URL> getContent(String string) throws IllegalArgumentException {
            return this.getLibraryImplementation().getContent(string);
        }

        @Override
        public void setName(String string) {
            this.getLibraryImplementation().setName(string);
        }

        @Override
        public void setDescription(String string) {
            this.getLibraryImplementation().setDescription(string);
        }

        @Override
        public void setLocalizingBundle(String string) {
            this.getLibraryImplementation().setLocalizingBundle(string);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.getLibraryImplementation().addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.getLibraryImplementation().removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void setContent(String string, List<URL> list) throws IllegalArgumentException {
            this.getLibraryImplementation().setContent(string, list);
        }
    }

    private static class LibraryNode
    extends AbstractNode {
        private static final String ICON = "org/netbeans/modules/project/libraries/resources/libraries.gif";
        private LibraryImplementation lib;
        private LibraryTypeProvider provider;

        public LibraryNode(LibraryImplementation libraryImplementation, LibraryTypeProvider libraryTypeProvider, LibraryStorageArea libraryStorageArea) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{libraryImplementation, libraryTypeProvider, libraryStorageArea}));
            this.lib = libraryImplementation;
            this.provider = libraryTypeProvider;
            this.setIconBaseWithExtension(ICON);
        }

        public String getName() {
            return this.lib.getName();
        }

        public String getDisplayName() {
            return LibrariesCustomizer.getLocalizedString(this.lib.getLocalizingBundle(), this.lib.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CategoryChildren
    extends Children.Keys<LibraryImplementation>
    implements ChangeListener {
        private LibraryTypeProvider provider;
        private final LibraryStorageArea area;

        public CategoryChildren(LibraryTypeProvider libraryTypeProvider, LibraryStorageArea libraryStorageArea) {
            this.provider = libraryTypeProvider;
            this.area = libraryStorageArea;
            LibrariesCustomizer.this.model.addChangeListener(this);
        }

        public void addNotify() {
            ArrayList<LibraryImplementation> arrayList = new ArrayList<LibraryImplementation>();
            for (LibraryImplementation libraryImplementation : LibrariesCustomizer.this.model.getLibraries()) {
                if (!this.provider.getLibraryType().equals(libraryImplementation.getType()) || !LibrariesCustomizer.this.model.getArea(libraryImplementation).equals(this.area)) continue;
                arrayList.add(libraryImplementation);
            }
            this.setKeys(arrayList);
        }

        public void removeNotify() {
            this.setKeys(new LibraryImplementation[0]);
        }

        protected Node[] createNodes(LibraryImplementation libraryImplementation) {
            return new Node[]{new LibraryNode(libraryImplementation, this.provider, this.area)};
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CategoryChildren.this.addNotify();
                }
            });
        }
    }

    private class CategoryNode
    extends AbstractNode {
        private LibraryTypeProvider provider;
        private Node iconDelegate;

        public CategoryNode(LibraryTypeProvider libraryTypeProvider, LibraryStorageArea libraryStorageArea) {
            super((Children)new CategoryChildren(libraryTypeProvider, libraryStorageArea), Lookups.fixed((Object[])new Object[]{libraryTypeProvider, libraryStorageArea}));
            this.provider = libraryTypeProvider;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.provider.getLibraryType();
        }

        public String getDisplayName() {
            return this.provider.getDisplayName();
        }

        public Image getIcon(int n) {
            return this.iconDelegate.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.iconDelegate.getOpenedIcon(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeChildren
    extends Children.Keys<LibraryTypeProvider> {
        private final LibraryStorageArea area;

        TypeChildren(LibraryStorageArea libraryStorageArea) {
            this.area = libraryStorageArea;
        }

        public void addNotify() {
            this.setKeys(LibraryTypeRegistry.getDefault().getLibraryTypeProviders());
        }

        public void removeNotify() {
            this.setKeys(new LibraryTypeProvider[0]);
        }

        protected Node[] createNodes(LibraryTypeProvider libraryTypeProvider) {
            return new Node[]{new CategoryNode(libraryTypeProvider, this.area)};
        }
    }

    private final class AreaNode
    extends AbstractNode {
        private final LibraryStorageArea area;

        AreaNode(LibraryStorageArea libraryStorageArea) {
            super((Children)new TypeChildren(libraryStorageArea), Lookups.singleton((Object)libraryStorageArea));
            this.area = libraryStorageArea;
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            return this.area.getDisplayName();
        }

        private Node delegate() {
            return DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public Image getIcon(int n) {
            return this.delegate().getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.delegate().getOpenedIcon(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AreaChildren
    extends Children.Keys<LibraryStorageArea>
    implements ChangeListener {
        private AreaChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            LibrariesCustomizer.this.model.addChangeListener(this);
            this.computeKeys();
        }

        protected void removeNotify() {
            super.removeNotify();
            LibrariesCustomizer.this.model.removeChangeListener(this);
            this.setKeys(Collections.emptySet());
        }

        private void computeKeys() {
            this.setKeys(LibrariesCustomizer.getSortedAreas(LibrariesCustomizer.this.model));
        }

        protected Node[] createNodes(LibraryStorageArea libraryStorageArea) {
            return new Node[]{new AreaNode(libraryStorageArea)};
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AreaChildren.this.computeKeys();
                }
            });
        }
    }

    private static class LibrariesView
    extends BeanTreeView {
        public LibrariesView() {
            this.setRootVisible(false);
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
        }
    }
}

