/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInformationParser
extends DefaultHandler
implements Serializable {
    private boolean parsingInProgress;
    private Stack qNameStack = new Stack();
    JBIComponentStatus component = null;
    List<JBIComponentStatus> components = new ArrayList<JBIComponentStatus>();

    public List<JBIComponentStatus> getComponents() {
        return this.components;
    }

    public static List<JBIComponentStatus> parse(String string) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        List<JBIComponentStatus> list = new ArrayList<JBIComponentStatus>();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        ComponentInformationParser componentInformationParser = new ComponentInformationParser();
        if (inputSource != null) {
            sAXParser.parse(inputSource, (DefaultHandler)componentInformationParser);
            list = componentInformationParser.getComponents();
        }
        return list;
    }

    public static List<JBIComponentStatus> parse(File file) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        ArrayList<JBIComponentStatus> arrayList = new ArrayList();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.setProperty("http://apache.org/xml/properties/input-buffer-size", new Integer(8192));
        FileReader fileReader = new FileReader(file);
        InputSource inputSource = new InputSource(fileReader);
        ComponentInformationParser componentInformationParser = new ComponentInformationParser();
        sAXParser.parse(inputSource, (DefaultHandler)componentInformationParser);
        arrayList = componentInformationParser.getComponents();
        return arrayList;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
        this.components.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("component-info-list".equals(string3)) {
            String string4 = null;
            String string5 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                string4 = attributes.getQName(i);
                if (string4 != null && (string5 = attributes.getValue(string4)) == null) continue;
            }
        } else if ("component-info".equals(string3)) {
            this.component = new JBIComponentStatus();
            String string6 = null;
            String string7 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                string6 = attributes.getQName(i);
                if (string6 == null || (string7 = attributes.getValue(string6)) == null) continue;
                if ("name".equals(string6)) {
                    if (this.component == null || string7 == null) continue;
                    this.component.setName(string7);
                    continue;
                }
                if ("state".equals(string6)) {
                    if (this.component == null || string7 == null) continue;
                    this.component.setState(string7);
                    continue;
                }
                if ("type".equals(string6)) {
                    if (this.component == null || string7 == null) continue;
                    String string8 = string7.toLowerCase();
                    if (string8.indexOf("binding") > -1) {
                        this.component.setType("binding");
                        continue;
                    }
                    if (string8.indexOf("engine") > -1) {
                        this.component.setType("engine");
                        continue;
                    }
                    this.component.setType(string8);
                    continue;
                }
                if (!"xmlns".equals(string6) || this.component == null || string7 == null) continue;
                this.component.addNamespace(string7);
            }
        }
        this.qNameStack.push(string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        String string2 = (String)this.qNameStack.peek();
        if ("description".equals(string2)) {
            if (this.component != null && string != null) {
                this.component.setDescription(string);
            }
        } else if ("name".equals(string2)) {
            if (this.component != null && string != null) {
                this.component.setName(string);
            }
        } else if ("state".equals(string2)) {
            if (this.component != null && string != null) {
                this.component.setState(string);
            }
        } else if ("type".equals(string2)) {
            if (this.component != null && string != null) {
                String string3 = string.toLowerCase();
                if (string3.indexOf("binding") > -1) {
                    this.component.setType("binding");
                } else if (string3.indexOf("engine") > -1) {
                    this.component.setType("engine");
                } else {
                    this.component.setType(string3);
                }
            }
        } else if ("xmlns".equals(string2) && this.component != null && string != null) {
            this.component.addNamespace(string);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.qNameStack.pop();
        if (!"component-info-list".equals(string3) && "component-info".equals(string3)) {
            this.components.add(this.component);
            this.component = null;
        }
    }
}

