/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import org.netbeans.modules.sun.manager.jbi.actions.ShutdownAction;
import org.netbeans.modules.sun.manager.jbi.nodes.Uninstallable;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public abstract class UninstallAction
extends NodeAction {
    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    for (Node node : nodeArray) {
                        Lookup lookup = node.getLookup();
                        Uninstallable uninstallable = (Uninstallable)lookup.lookup(Uninstallable.class);
                        if (uninstallable == null) continue;
                        uninstallable.uninstall(UninstallAction.this.isForceAction());
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray != null && nodeArray.length > 0) {
            bl = true;
            for (Node node : nodeArray) {
                Uninstallable uninstallable = (Uninstallable)node.getLookup().lookup(Uninstallable.class);
                try {
                    if (uninstallable == null || uninstallable.canUninstall(this.isForceAction())) continue;
                    bl = false;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected abstract boolean isForceAction();

    public static class Force
    extends UninstallAction {
        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_ForceUninstallAction");
        }

        protected boolean isForceAction() {
            return true;
        }
    }

    public static class Normal
    extends UninstallAction {
        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_UninstallAction");
        }

        protected boolean isForceAction() {
            return false;
        }
    }
}

