/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import org.netbeans.modules.sun.manager.jbi.nodes.Deployable;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public abstract class DeployAction
extends NodeAction {
    private boolean autoStart;

    private DeployAction(boolean bl) {
        this.autoStart = bl;
    }

    protected void performAction(Node[] nodeArray) {
        Lookup lookup = nodeArray[0].getLookup();
        final Deployable deployable = (Deployable)lookup.lookup(Deployable.class);
        if (deployable != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        deployable.deploy(DeployAction.this.autoStart);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static class DeployAndStart
    extends DeployAction {
        public DeployAndStart() {
            super(true);
        }

        public String getName() {
            return NbBundle.getMessage(DeployAction.class, (String)"LBL_DeployAndStartAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    public static class DeployOnly
    extends DeployAction {
        public DeployOnly() {
            super(false);
        }

        public String getName() {
            return NbBundle.getMessage(DeployAction.class, (String)"LBL_DeployAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

