/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNewEntryPanel;
import org.netbeans.modules.cnd.makeproject.packaging.InfoElement;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingInfoPanel
extends ListEditorPanel {
    private String baseDir;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private JButton addButton;
    private JButton addEntryButton;
    private JTextArea docArea;
    private static ResourceBundle bundle;

    public PackagingInfoPanel(List<InfoElement> list, String string) {
        super(list.toArray(), new JButton[]{new JButton(), new JButton()});
        this.getAddButton().setVisible(false);
        this.baseDir = string;
        this.addButton = this.extraButtons[0];
        this.addButton.setText(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.text"));
        this.addButton.setMnemonic(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.mn").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.ad"));
        this.addButton.addActionListener(new AddButtonAction());
        this.addEntryButton = this.extraButtons[1];
        this.addEntryButton.setText(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.text"));
        this.addEntryButton.setMnemonic(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.mn").charAt(0));
        this.addEntryButton.getAccessibleContext().setAccessibleDescription(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.ad"));
        this.addEntryButton.addActionListener(new AddEntryButtonAction());
        this.getEditButton().setVisible(false);
        this.getDefaultButton().setVisible(false);
        if (list.size() > 0 && list.get(0).isMandatory()) {
            this.getRemoveButton().setEnabled(false);
        }
    }

    public void setDocArea(JTextArea jTextArea) {
        this.docArea = jTextArea;
    }

    @Override
    public Object copyAction(Object object) {
        InfoElement infoElement = (InfoElement)object;
        return new InfoElement(new String(infoElement.getName()), new String(infoElement.getValue()));
    }

    @Override
    public String getCopyButtonText() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.text");
    }

    @Override
    public char getCopyButtonMnemonics() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.mn").charAt(0);
    }

    @Override
    public String getCopyButtonAD() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.ad");
    }

    @Override
    public String getListLabelText() {
        return PackagingInfoPanel.getString("PackagingInfoPanel.listlabel.text");
    }

    @Override
    public char getListLabelMnemonic() {
        return PackagingInfoPanel.getString("PackagingInfoPanel.listlabel.mn").toCharArray()[0];
    }

    @Override
    public int getSelectedIndex() {
        int n = this.getTargetList().getSelectedRow();
        if (n >= 0 && n < this.listData.size()) {
            return n;
        }
        return 0;
    }

    @Override
    protected void setSelectedIndex(int n) {
        this.getTargetList().getSelectionModel().setSelectionInterval(n, n);
    }

    @Override
    protected void setData(Vector vector) {
        this.getTargetList().setModel(new MyTableModel());
        this.getTargetList().getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getTargetList().getColumnModel().getColumn(0).setMaxWidth(100);
        this.getTargetList().getSelectionModel().setSelectionMode(0);
        this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    @Override
    protected void ensureIndexIsVisible(int n) {
    }

    @Override
    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.getListLabel().setLabelFor(this.targetList);
            this.setData(null);
        }
        return this.targetList;
    }

    public void refresh() {
        this.updateDoc();
    }

    public void updateDoc() {
        if (this.docArea == null) {
            return;
        }
        this.docArea.setText("");
        int n = this.targetList.getSelectedRow();
        if (this.listData.size() == 0 || n < 0 || n >= this.listData.size()) {
            return;
        }
        InfoElement infoElement = (InfoElement)this.listData.get(n);
        if (infoElement.getName().equals("ARCH")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ARCH_DOC"));
        } else if (infoElement.getName().equals("CATEGORY")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_CATEGORY_DOC"));
        } else if (infoElement.getName().equals("NAME")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_NAME_DOC"));
        } else if (infoElement.getName().equals("PKG")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_PKG_DOC"));
        } else if (infoElement.getName().equals("VERSION")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VERSION_DOC"));
        } else if (infoElement.getName().equals("BASEDIR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_BASEDIR_DOC"));
        } else if (infoElement.getName().equals("CLASSES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_CLASSES_DOC"));
        } else if (infoElement.getName().equals("DESC")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_DESC_DOC"));
        } else if (infoElement.getName().equals("EMAIL")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_EMAIL_DOC"));
        } else if (infoElement.getName().equals("HOTLINE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_HOTLINE_DOC"));
        } else if (infoElement.getName().equals("INTONLY")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_INTONLY_DOC"));
        } else if (infoElement.getName().equals("ISTATES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ISTATES_DOC"));
        } else if (infoElement.getName().equals("MAXINST")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_MAXINST_DOC"));
        } else if (infoElement.getName().equals("ORDER")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ORDER_DOC"));
        } else if (infoElement.getName().equals("PSTAMP")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_PSTAMP_DOC"));
        } else if (infoElement.getName().equals("RSTATES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_RSTATES_DOC"));
        } else if (infoElement.getName().equals("SUNW_ISA")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_ISA_DOC"));
        } else if (infoElement.getName().equals("SUNW_LOC")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_LOC_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKG_DIR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_DIR_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKG_ALLZONES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_ALLZONES_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKG_HOLLOW")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_HOLLOW_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKG_THISZONE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_THISZONE_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKGLIST")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGLIST_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKGTYPE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGTYPE_DOC"));
        } else if (infoElement.getName().equals("SUNW_PKGVERS")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGVERS_DOC"));
        } else if (infoElement.getName().equals("SUNW_PRODNAME")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PRODNAME_DOC"));
        } else if (infoElement.getName().equals("SUNW_PRODVERS")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PRODVERS_DOC"));
        } else if (infoElement.getName().equals("ULIMIT")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ULIMIT_DOC"));
        } else if (infoElement.getName().equals("VENDOR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VENDOR_DOC"));
        } else if (infoElement.getName().equals("VSTOCK")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VSTOCK_DOC"));
        }
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingInfoPanel.class);
        }
        return bundle.getString(string);
    }

    class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{PackagingInfoPanel.access$000("PackagingInfoPanel.column.0.text"), PackagingInfoPanel.access$000("PackagingInfoPanel.column.1.text")};

        MyTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return PackagingInfoPanel.this.listData.size();
        }

        public Object getValueAt(int n, int n2) {
            InfoElement infoElement = (InfoElement)PackagingInfoPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                return infoElement.getName();
            }
            if (n2 == 1) {
                return infoElement.getValue();
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            InfoElement infoElement = (InfoElement)PackagingInfoPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                infoElement.setName((String)object);
            } else if (n2 == 1) {
                infoElement.setValue((String)object);
            } else assert (false);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            InfoElement infoElement = (InfoElement)PackagingInfoPanel.this.listData.elementAt(n);
            if (n2 != 0 && n2 == 1) {
                if (!bl) {
                    jLabel = new JLabel();
                }
                if (!bl && infoElement.getValue().indexOf(60) >= 0) {
                    jLabel.setForeground(Color.RED);
                }
                jLabel.setText(infoElement.getValue());
            }
            return jLabel;
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PackagingInfoPanel.this.updateDoc();
        }
    }

    class MyTable
    extends JTable {
        public MyTable() {
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
            this.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        }

        public boolean getShowHorizontalLines() {
            return false;
        }

        public boolean getShowVerticalLines() {
            return false;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return PackagingInfoPanel.this.myTableCellRenderer;
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            InfoElement infoElement;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            PackagingInfoPanel.this.checkSelection();
            int n = PackagingInfoPanel.this.getSelectedIndex();
            if (PackagingInfoPanel.this.listData.size() >= 0 && n >= 0 && n < PackagingInfoPanel.this.listData.size() && (infoElement = (InfoElement)PackagingInfoPanel.this.listData.get(n)).isMandatory()) {
                PackagingInfoPanel.this.getRemoveButton().setEnabled(false);
            }
        }
    }

    class AddEntryButtonAction
    implements ActionListener {
        AddEntryButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PackagingNewEntryPanel packagingNewEntryPanel = new PackagingNewEntryPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)packagingNewEntryPanel, PackagingInfoPanel.getString("AddNewParameterDialogTitle"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            PackagingInfoPanel.this.addObjectAction(packagingNewEntryPanel.getInfoElement());
        }
    }

    class AddButtonAction
    implements ActionListener {
        AddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PackagingInfoPanel.this.addObjectAction(new InfoElement("", ""));
        }
    }
}

