/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class PackagingConfiguration {
    private MakeConfiguration makeConfiguration;
    private static String[] TYPE_NAMES = new String[]{PackagingConfiguration.getString("Tar"), PackagingConfiguration.getString("Zip"), PackagingConfiguration.getString("SCR4Package")};
    public static final int TYPE_TAR = 0;
    public static final int TYPE_ZIP = 1;
    public static final int TYPE_SVR4_PACKAGE = 2;
    private IntConfiguration type;
    private BooleanConfiguration verbose;
    private VectorConfiguration header;
    private VectorConfiguration files;
    private StringConfiguration output;
    private StringConfiguration tool;
    private StringConfiguration options;
    TypePropertyChangeListener typePropertyChangeListener;

    public PackagingConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.type = new IntConfiguration(null, 0, TYPE_NAMES, null);
        this.verbose = new BooleanConfiguration(null, true);
        this.header = new VectorConfiguration(null);
        this.files = new VectorConfiguration(null);
        this.output = new StringConfiguration(null, "");
        this.tool = new StringConfiguration(null, "");
        this.options = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public IntConfiguration getType() {
        return this.type;
    }

    public void setType(IntConfiguration intConfiguration) {
        this.type = intConfiguration;
    }

    public BooleanConfiguration getVerbose() {
        return this.verbose;
    }

    public void setVerbose(BooleanConfiguration booleanConfiguration) {
        this.verbose = booleanConfiguration;
    }

    public VectorConfiguration getHeader() {
        return this.header;
    }

    public void setHeader(VectorConfiguration vectorConfiguration) {
        this.header = vectorConfiguration;
    }

    public VectorConfiguration getFiles() {
        return this.files;
    }

    public void setFiles(VectorConfiguration vectorConfiguration) {
        this.files = vectorConfiguration;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void setOptions(StringConfiguration stringConfiguration) {
        this.options = stringConfiguration;
    }

    public StringConfiguration getOptions() {
        return this.options;
    }

    public void assign(PackagingConfiguration packagingConfiguration) {
        this.setMakeConfiguration(packagingConfiguration.getMakeConfiguration());
        this.getType().assign(packagingConfiguration.getType());
        this.getVerbose().assign(packagingConfiguration.getVerbose());
        this.getHeader().assign(packagingConfiguration.getHeader());
        this.getFiles().assign(packagingConfiguration.getFiles());
        this.getOutput().assign(packagingConfiguration.getOutput());
        this.getTool().assign(packagingConfiguration.getTool());
        this.getOptions().assign(packagingConfiguration.getOptions());
    }

    public Object clone() {
        PackagingConfiguration packagingConfiguration = new PackagingConfiguration(this.getMakeConfiguration());
        packagingConfiguration.setType((IntConfiguration)this.getType().clone());
        packagingConfiguration.setVerbose((BooleanConfiguration)this.getVerbose().clone());
        packagingConfiguration.setHeader((VectorConfiguration)this.getHeader().clone());
        packagingConfiguration.setFiles((VectorConfiguration)this.getFiles().clone());
        packagingConfiguration.setOutput((StringConfiguration)this.getOutput().clone());
        packagingConfiguration.setTool((StringConfiguration)this.getTool().clone());
        packagingConfiguration.setOptions((StringConfiguration)this.getOptions().clone());
        return packagingConfiguration;
    }

    public Sheet getGeneralSheet(MakeCustomizer makeCustomizer) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(PackagingConfiguration.getString("GeneralTxt"));
        set.setShortDescription(PackagingConfiguration.getString("GeneralHint"));
        IntNodeProp intNodeProp = new IntNodeProp(this.getType(), true, "PackageType", PackagingConfiguration.getString("PackageTypeName"), PackagingConfiguration.getString("PackageTypeHint"));
        set.put((Node.Property)intNodeProp);
        OutputNodeProp outputNodeProp = new OutputNodeProp(this.getOutput(), this.getOutputDefault(), "Output", PackagingConfiguration.getString("OutputTxt"), PackagingConfiguration.getString("OutputHint"));
        set.put((Node.Property)outputNodeProp);
        String[] stringArray = new String[]{"Files", PackagingConfiguration.getString("FilesName"), PackagingConfiguration.getString("FilesHint")};
        set.put((Node.Property)new BooleanNodeProp(this.getVerbose(), true, "Verbose", PackagingConfiguration.getString("VerboseName"), PackagingConfiguration.getString("VerboseHint")));
        set.put((Node.Property)new PackagingNodeProp(this, this.makeConfiguration, stringArray));
        StringNodeProp stringNodeProp = new StringNodeProp(this.getTool(), this.getToolDefault(), "Tool", PackagingConfiguration.getString("ToolTxt1"), PackagingConfiguration.getString("ToolHint1"));
        set.put((Node.Property)stringNodeProp);
        StringNodeProp stringNodeProp2 = new StringNodeProp(this.getOptions(), this.getToolDefault(), "AdditionalOptions", PackagingConfiguration.getString("AdditionalOptionsTxt1"), PackagingConfiguration.getString("AdditionalOptionsHint"));
        set.put((Node.Property)stringNodeProp2);
        sheet.put(set);
        this.typePropertyChangeListener = new TypePropertyChangeListener(makeCustomizer, outputNodeProp, stringNodeProp, stringNodeProp2);
        intNodeProp.getPropertyEditor().addPropertyChangeListener(this.typePropertyChangeListener);
        return sheet;
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        Object object;
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1) {
            string = string.toLowerCase();
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            object = Platforms.getPlatform(this.getMakeConfiguration().getPlatform().getValue());
            string = object.getLibraryName(string);
        }
        string = ConfigurationSupport.makeNameLegal(string);
        object = "dist/" + this.getMakeConfiguration().getName() + "/" + this.getMakeConfiguration().getVariant() + "/";
        if (this.getType().getValue() == 2) {
            object = (String)object + string + ".pkg";
        } else if (this.getType().getValue() == 0) {
            object = (String)object + string + ".tar";
        } else if (this.getType().getValue() == 1) {
            object = (String)object + string + ".zip";
        } else assert (false);
        return object;
    }

    public String getToolValue() {
        if (this.getTool().getModified()) {
            return this.getTool().getValue();
        }
        return this.getToolDefault();
    }

    private String getToolDefault() {
        String string = null;
        if (this.getType().getValue() == 2) {
            string = "pkgmk";
        } else if (this.getType().getValue() == 0) {
            string = "tar";
        } else if (this.getType().getValue() == 1) {
            string = "zip";
        } else assert (false);
        return string;
    }

    public String getOptionsValue() {
        if (this.getOptions().getModified()) {
            return this.getOptions().getValue();
        }
        return this.getOptionsDefault();
    }

    private String getOptionsDefault() {
        String string = null;
        if (this.getType().getValue() == 2) {
            string = "";
        } else if (this.getType().getValue() == 0) {
            string = "-v";
        } else if (this.getType().getValue() == 1) {
            string = "";
        } else assert (false);
        return string;
    }

    public String[] getDisplayNames() {
        return TYPE_NAMES;
    }

    public String getDisplayName() {
        return TYPE_NAMES[this.getType().getValue()];
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PackagingConfiguration.class, (String)string);
    }

    private class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3, String string4) {
            super(stringConfiguration, string, string2, string3, string4);
        }

        public void setValue(Object object) {
            if (IpeUtils.hasMakeSpecialCharacters((String)((String)object))) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PackagingConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(object);
        }
    }

    class TypePropertyChangeListener
    implements PropertyChangeListener {
        private MakeCustomizer makeCustomizer;
        private OutputNodeProp outputNodeProp;
        private StringNodeProp toolNodeProp;
        private StringNodeProp optionsNodeProp;

        TypePropertyChangeListener(MakeCustomizer makeCustomizer, OutputNodeProp outputNodeProp, StringNodeProp stringNodeProp, StringNodeProp stringNodeProp2) {
            this.makeCustomizer = makeCustomizer;
            this.outputNodeProp = outputNodeProp;
            this.toolNodeProp = stringNodeProp;
            this.optionsNodeProp = stringNodeProp2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!PackagingConfiguration.this.output.getModified()) {
                this.outputNodeProp.setDefaultValue(PackagingConfiguration.this.getOutputDefault());
                PackagingConfiguration.this.output.reset();
            }
            if (!PackagingConfiguration.this.tool.getModified()) {
                this.toolNodeProp.setDefaultValue(PackagingConfiguration.this.getToolDefault());
                PackagingConfiguration.this.tool.reset();
            }
            if (!PackagingConfiguration.this.options.getModified()) {
                this.optionsNodeProp.setDefaultValue(PackagingConfiguration.this.getOptionsDefault());
                PackagingConfiguration.this.options.reset();
            }
            this.makeCustomizer.validate();
            this.makeCustomizer.repaint();
        }
    }
}

