/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurations {
    public static final String PROP_DEFAULT = "default";
    public static final String PROP_ACTIVE_CONFIGURATION = "activeconfiguration";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<Configuration> configurations;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public Configurations init(Configuration[] configurationArray, int n) {
        this.configurations = new ArrayList<Configuration>();
        for (int i = 0; i < configurationArray.length; ++i) {
            this.configurations.add(configurationArray[i]);
        }
        if (n >= 0 && configurationArray != null && configurationArray.length > 0) {
            this.setActive(n);
        }
        return this;
    }

    public int size() {
        return this.configurations.size();
    }

    public Configuration[] getConfs() {
        return this.configurations.toArray(new Configuration[this.size()]);
    }

    public Collection<Configuration> getConfsAsCollection() {
        LinkedHashSet<Configuration> linkedHashSet = new LinkedHashSet<Configuration>();
        linkedHashSet.addAll(this.configurations);
        return linkedHashSet;
    }

    public Configuration[] getClonedConfs() {
        Configuration[] configurationArray = new Configuration[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Configuration configuration = this.configurations.get(i);
            configurationArray[i] = configuration.cloneConf();
        }
        return configurationArray;
    }

    public String[] getConfsAsDisplayNames() {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Configuration configuration = this.configurations.get(i);
            stringArray[i] = configuration.toString();
        }
        return stringArray;
    }

    public String[] getConfsAsNames() {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Configuration configuration = this.configurations.get(i);
            stringArray[i] = configuration.getName();
        }
        return stringArray;
    }

    public Configuration getConf(int n) {
        this.checkValidIndex(n);
        return this.configurations.get(n);
    }

    public Configuration getConfByDisplayName(String string) {
        Configuration configuration = null;
        for (Configuration configuration2 : this.configurations) {
            if (!configuration2.getDisplayName().equals(string)) continue;
            configuration = configuration2;
            break;
        }
        return configuration;
    }

    public Configuration getConf(String string) {
        Configuration configuration = null;
        for (Configuration configuration2 : this.configurations) {
            if (!configuration2.getName().equals(string)) continue;
            configuration = configuration2;
            break;
        }
        return configuration;
    }

    public void setActive(Configuration configuration) {
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = this.getActive();
        if (configuration == configuration2) {
            return;
        }
        for (Configuration configuration3 : this.configurations) {
            configuration3.setDefault(false);
            if (configuration3 != configuration) continue;
            configuration.setDefault(true);
            this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, configuration2, configuration);
            this.pcs.firePropertyChange(PROP_DEFAULT, null, null);
        }
    }

    public void setActive(String string) {
        this.setActive(this.getConf(string));
    }

    public void setActive(int n) {
        Configuration configuration = this.getActive();
        this.checkValidIndex(n);
        Configuration configuration2 = this.configurations.get(n);
        if (configuration2 != null) {
            for (Configuration configuration3 : this.configurations) {
                configuration3.setDefault(false);
            }
            configuration2.setDefault(true);
        }
        this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, configuration, configuration2);
        this.pcs.firePropertyChange(PROP_DEFAULT, null, null);
    }

    public String getActiveDisplayName() {
        String string = null;
        Configuration configuration = this.getActive();
        if (configuration != null) {
            string = configuration.getDisplayName();
        }
        return string;
    }

    public Configuration getDefault() {
        return this.getActive();
    }

    public Configuration getActive() {
        for (Configuration configuration : this.configurations) {
            if (!configuration.isDefault()) continue;
            return configuration;
        }
        return null;
    }

    public int getActiveAsIndex() {
        int n = -1;
        Iterator<Configuration> iterator = this.configurations.iterator();
        while (iterator.hasNext()) {
            ++n;
            Configuration configuration = iterator.next();
            if (!configuration.isDefault()) continue;
            return n;
        }
        return -1;
    }

    private void checkValidIndex(int n) {
        if (n < 0 || n >= this.size()) {
            // empty if block
        }
    }

    public Configurations cloneConfs() {
        Configurations configurations = new Configurations();
        configurations.init(this.getClonedConfs(), this.getActiveAsIndex());
        return configurations;
    }
}

