/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ArchiverConfiguration
implements AllOptionsProvider {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private BooleanConfiguration runRanlib;
    private BooleanConfiguration replaceOption;
    private BooleanConfiguration verboseOption;
    private BooleanConfiguration supressOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private StringConfiguration tool;

    public ArchiverConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.runRanlib = new BooleanConfiguration(null, true, "", "$(RANLIB)");
        this.replaceOption = new BooleanConfiguration(null, true, "", "r");
        this.verboseOption = new BooleanConfiguration(null, true, "", "v");
        this.supressOption = new BooleanConfiguration(null, false, "", "c");
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.tool = new StringConfiguration(null, "ar");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setRunRanlib(BooleanConfiguration booleanConfiguration) {
        this.runRanlib = booleanConfiguration;
    }

    public BooleanConfiguration getRunRanlib() {
        return this.runRanlib;
    }

    public void setReplaceOption(BooleanConfiguration booleanConfiguration) {
        this.replaceOption = booleanConfiguration;
    }

    public BooleanConfiguration getReplaceOption() {
        return this.replaceOption;
    }

    public void setVerboseOption(BooleanConfiguration booleanConfiguration) {
        this.verboseOption = booleanConfiguration;
    }

    public BooleanConfiguration getVerboseOption() {
        return this.verboseOption;
    }

    public void setSupressOption(BooleanConfiguration booleanConfiguration) {
        this.supressOption = booleanConfiguration;
    }

    public BooleanConfiguration getSupressOption() {
        return this.supressOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration optionsConfiguration) {
        this.commandLineConfiguration = optionsConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration optionsConfiguration) {
        this.additionalDependencies = optionsConfiguration;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void assign(ArchiverConfiguration archiverConfiguration) {
        this.setMakeConfiguration(archiverConfiguration.getMakeConfiguration());
        this.getOutput().assign(archiverConfiguration.getOutput());
        this.getRunRanlib().assign(archiverConfiguration.getRunRanlib());
        this.getReplaceOption().assign(archiverConfiguration.getReplaceOption());
        this.getVerboseOption().assign(archiverConfiguration.getVerboseOption());
        this.getSupressOption().assign(archiverConfiguration.getSupressOption());
        this.getAdditionalDependencies().assign(archiverConfiguration.getAdditionalDependencies());
        this.getCommandLineConfiguration().assign(archiverConfiguration.getCommandLineConfiguration());
        this.getTool().assign(archiverConfiguration.getTool());
    }

    public Object clone() {
        ArchiverConfiguration archiverConfiguration = new ArchiverConfiguration(this.getMakeConfiguration());
        archiverConfiguration.setOutput((StringConfiguration)this.getOutput().clone());
        archiverConfiguration.setRunRanlib((BooleanConfiguration)this.getRunRanlib().clone());
        archiverConfiguration.setReplaceOption((BooleanConfiguration)this.getReplaceOption().clone());
        archiverConfiguration.setVerboseOption((BooleanConfiguration)this.getVerboseOption().clone());
        archiverConfiguration.setSupressOption((BooleanConfiguration)this.getSupressOption().clone());
        archiverConfiguration.setAdditionalDependencies((OptionsConfiguration)this.getAdditionalDependencies().clone());
        archiverConfiguration.setCommandLineConfiguration((OptionsConfiguration)this.getCommandLineConfiguration().clone());
        archiverConfiguration.setTool((StringConfiguration)this.getTool().clone());
        return archiverConfiguration;
    }

    public String getOptions() {
        String string = this.getAllOptions(false) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        string = string + this.getOutputValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions(BasicCompiler basicCompiler) {
        return this.getAllOptions(true);
    }

    private String getAllOptions(boolean bl) {
        String string = "";
        string = string + this.getReplaceOption().getOption();
        string = string + this.getVerboseOption().getOption();
        string = string + this.getSupressOption().getOption() + " ";
        if (bl) {
            string = string + this.getOutputValue() + " ";
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(ArchiverConfiguration.getString("GeneralTxt"));
        set.setShortDescription(ArchiverConfiguration.getString("GeneralHint"));
        set.put((Node.Property)new OutputNodeProp(this.getOutput(), this.getOutputValue(), "Output", ArchiverConfiguration.getString("OutputTxt"), ArchiverConfiguration.getString("OutputHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getRunRanlib(), true, "RunRanlib", ArchiverConfiguration.getString("RunRanlibTxt"), ArchiverConfiguration.getString("RunRanlibHint")));
        sheet.put(set);
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("Options");
        set2.setDisplayName(ArchiverConfiguration.getString("OptionsTxt"));
        set2.setShortDescription(ArchiverConfiguration.getString("OptionsHint"));
        set2.put((Node.Property)new BooleanNodeProp(this.getVerboseOption(), true, "Verbose", ArchiverConfiguration.getString("VerboseTxt"), ArchiverConfiguration.getString("VerboseHint")));
        set2.put((Node.Property)new BooleanNodeProp(this.getSupressOption(), true, "SupressDiagnostics", ArchiverConfiguration.getString("SupressDiagnosticsTxt"), ArchiverConfiguration.getString("SupressDiagnosticsHint")));
        sheet.put(set2);
        Sheet.Set set3 = new Sheet.Set();
        String[] stringArray = new String[]{ArchiverConfiguration.getString("AdditionalDependenciesTxt1"), ArchiverConfiguration.getString("AdditionalDependenciesHint"), ArchiverConfiguration.getString("AdditionalDependenciesTxt2"), ArchiverConfiguration.getString("InheritedValuesTxt")};
        set3.setName("Input");
        set3.setDisplayName(ArchiverConfiguration.getString("InputTxt"));
        set3.setShortDescription(ArchiverConfiguration.getString("InputHint"));
        set3.put((Node.Property)new OptionsNodeProp(this.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(), null, ",", stringArray));
        sheet.put(set3);
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(ArchiverConfiguration.getString("ToolTxt1"));
        set4.setShortDescription(ArchiverConfiguration.getString("ToolHint1"));
        set4.put((Node.Property)new StringNodeProp(this.getTool(), "Tool", ArchiverConfiguration.getString("ToolTxt2"), ArchiverConfiguration.getString("ToolHint2")));
        sheet.put(set4);
        stringArray = new String[]{ArchiverConfiguration.getString("AdditionalOptionsTxt1"), ArchiverConfiguration.getString("AdditionalOptionsHint"), ArchiverConfiguration.getString("AdditionalOptionsTxt2"), ArchiverConfiguration.getString("AllOptionsTxt")};
        set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(ArchiverConfiguration.getString("CommandLineTxt"));
        set2.setShortDescription(ArchiverConfiguration.getString("CommandLineHint"));
        set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, null, null, stringArray));
        sheet.put(set2);
        return sheet;
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase();
        string = ConfigurationSupport.makeNameLegal(string);
        string = "lib" + string + ".a";
        return "dist/" + this.getMakeConfiguration().getName() + "/" + this.getMakeConfiguration().getVariant() + "/" + string;
    }

    public String getOutputDefault27() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase();
        string = "lib" + string + ".a";
        return "dist/" + this.getMakeConfiguration().getName() + "/" + string;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ArchiverConfiguration.class, (String)string);
    }

    private class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3, String string4) {
            super(stringConfiguration, string, string2, string3, string4);
        }

        public void setValue(Object object) {
            if (IpeUtils.hasMakeSpecialCharacters((String)((String)object))) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ArchiverConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(object);
        }
    }

    class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        AdditionalDependenciesOptions() {
        }

        public String getOptions() {
            return null;
        }

        public String getAllOptions(BasicCompiler basicCompiler) {
            String string = "";
            string = string + ArchiverConfiguration.this.additionalDependencies.getPreDefined();
            return CppUtils.reformatWhitespaces((String)string);
        }
    }
}

