/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String DISPLAY_NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");

    public OpenProject() {
        super(DISPLAY_NAME, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/openProject.png")));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        File[] fileArray;
        OpenProjectListSettings openProjectListSettings;
        File[] fileArray2;
        JFileChooser jFileChooser;
        block5: {
            int n;
            Serializable serializable;
            jFileChooser = ProjectChooserAccessory.createProjectChooser(true);
            jFileChooser.setMultiSelectionEnabled(true);
            for (DataObject dataObject : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
                fileArray2 = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
                if (fileArray2 == null || OpenProjectList.getDefault().isOpen((Project)fileArray2) || (serializable = FileUtil.toFile((FileObject)fileArray2.getProjectDirectory())) == null) continue;
                jFileChooser.setCurrentDirectory(((File)serializable).getParentFile());
                jFileChooser.setSelectedFiles(new File[]{serializable});
                break;
            }
            openProjectListSettings = OpenProjectListSettings.getInstance();
            while ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                fileArray2 = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
                serializable = new ArrayList(fileArray2.length);
                for (File file2 : fileArray2) {
                    Project project = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)file2));
                    if (project == null) continue;
                    ((ArrayList)serializable).add(project);
                }
                if (((ArrayList)serializable).isEmpty()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                    continue;
                }
                fileArray = new Project[((ArrayList)serializable).size()];
                ((ArrayList)serializable).toArray(fileArray);
                file = null;
                if (openProjectListSettings.isOpenAsMain() && fileArray.length == 1) {
                    file = fileArray[0];
                }
                break block5;
            }
            return;
        }
        OpenProjectList.getDefault().open((Project[])fileArray, openProjectListSettings.isOpenSubprojects(), true, (Project)file);
        final ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node node = projectTab.getExplorerManager().getRootContext();
                ArrayList<Node> arrayList = new ArrayList<Node>(fileArray2.length);
                for (int i = 0; i < fileArray2.length; ++i) {
                    Node node2 = node.getChildren().findChild(fileArray2[i].getName());
                    if (node2 == null) continue;
                    arrayList.add(node2);
                }
                try {
                    Node[] nodeArray = new Node[arrayList.size()];
                    arrayList.toArray(nodeArray);
                    projectTab.getExplorerManager().setSelectedNodes(nodeArray);
                    if (!Boolean.getBoolean("project.tab.no.selection")) {
                        projectTab.open();
                        projectTab.requestActive();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        openProjectListSettings.setLastOpenProjectDir(jFileChooser.getCurrentDirectory().getPath());
    }
}

