/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRunnable
implements Runnable {
    protected volatile boolean stop = false;
    protected Notifier notifier;
    private Set<File> roots;
    protected SearchPanel panel;
    protected ProgressHandle progress;
    private int maxLevel;
    private Collection<? extends CustomCLDCPlatformConfigurator> customConfigurators;

    public SearchRunnable(Notifier notifier, Set<File> set, int n) {
        this.notifier = notifier;
        this.roots = new HashSet<File>();
        for (File file : set) {
            this.roots.add(FileUtil.normalizeFile((File)file));
        }
        this.maxLevel = n;
        this.customConfigurators = Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances();
    }

    public SearchRunnable(Notifier notifier, File file, int n) {
        this(notifier, Collections.singleton(file), n);
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public void run() {
        final String string = NbBundle.getMessage(SearchRunnable.class, (String)"Title_SearchRunnable_Searching");
        this.progress = ProgressHandleFactory.createHandle((String)string);
        this.panel = new SearchPanel(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress));
        this.progress.start();
        this.progress.switchToIndeterminate();
        final Dialog[] dialogArray = new Dialog[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    dialogArray[0] = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)SearchRunnable.this.panel, string, true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(SearchPanel.class), new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SearchRunnable.this.stop();
                        }
                    }));
                    if (dialogArray[0] != null) {
                        dialogArray[0].getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_searchingPlatform"));
                        dialogArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_searchingPlatform"));
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!SearchRunnable.this.stop) {
                        dialogArray[0].setVisible(true);
                    }
                }
            });
            for (File file : this.roots) {
                this.checkDirectory(file, this.maxLevel);
            }
            this.stop();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchRunnable.this.progress.finish();
                    dialogArray[0].setVisible(false);
                    SearchRunnable.this.notifier.notifySearchFinished();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void checkDirectory(File file, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.addLast(file);
        int n2 = 0;
        int n3 = 1;
        while (!this.stop && !linkedList.isEmpty() && n != 0) {
            Object object;
            File file2 = (File)linkedList.removeFirst();
            this.checkForPlatform(file2);
            if (n != 1 && (object = file2.listFiles()) != null) {
                for (int i = 0; i < ((File[])object).length; ++i) {
                    File file3 = object[i];
                    if (this.filter(file3)) continue;
                    linkedList.addLast(file3);
                }
            }
            if (++n2 % 100 == 0) {
                object = file2;
                SwingUtilities.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$finalFile;
                    {
                        this.val$finalFile = file;
                    }

                    public void run() {
                        SearchRunnable.this.panel.setCurrentPath(this.val$finalFile);
                    }
                });
            }
            if (--n3 != 0) continue;
            --n;
            n3 = linkedList.size();
        }
    }

    private boolean filter(File file) {
        return !file.isDirectory();
    }

    public boolean isPossibleJ2MEPlatform(File file) {
        for (CustomCLDCPlatformConfigurator customCLDCPlatformConfigurator : this.customConfigurators) {
            if (!customCLDCPlatformConfigurator.isPossiblePlatform(file)) continue;
            return true;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        return fileObject != null && J2MEPlatform.findTool("emulator", Collections.singletonList(fileObject)) != null && J2MEPlatform.findTool("preverify", Collections.singletonList(fileObject)) != null;
    }

    private void checkForPlatform(final File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        if (this.isPossibleJ2MEPlatform(file)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchRunnable.this.panel.increment();
                    SearchRunnable.this.notifier.notifyPossiblePlatformFound(file);
                }
            });
        }
    }

    static class SearchPanel
    extends JPanel {
        private int count = 0;
        private final JLabel searchLabel;
        private final JLabel foundLabel;

        public SearchPanel(JComponent jComponent) {
            this.setLayout(new GridBagLayout());
            this.searchLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 6, 12), 0, 0);
            this.add((Component)this.searchLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 6, 12), 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            this.foundLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 0, 12), 0, 0);
            this.add((Component)this.foundLabel, gridBagConstraints);
            this.updateMessageLabel();
            this.setPreferredSize(new Dimension(400, 70));
        }

        private void updateMessageLabel() {
            int n = this.count;
            if (n <= 0) {
                this.foundLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchRunnable_No_platform_found"));
            } else {
                this.foundLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchRunnable_Found_platforms", (Object)String.valueOf(this.count)));
            }
        }

        public void increment() {
            ++this.count;
            this.updateMessageLabel();
        }

        public void setCurrentPath(File file) {
            this.searchLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchingPath", (Object)file.getAbsolutePath()));
        }
    }

    public static interface Notifier {
        public void notifyPossiblePlatformFound(File var1);

        public void notifySearchFinished();
    }
}

