/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.api.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;

public class CompilerPathPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 1334257510688903149L;
    private JTextField c;
    private JTextField cpp;
    private JTextField f95;
    private JTextField asm;
    private boolean initialized;
    private JFileChooser fc;
    private File chooserDir;

    public CompilerPathPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_CompilerPathPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.getString("LBL_CompilerPaths"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        this.add(jLabel, gridBagConstraints, -1);
        this.c = this.createLine(1, this.getString("LBL_C"), this.getString("MNEM_C"));
        this.cpp = this.createLine(2, this.getString("LBL_Cpp"), this.getString("MNEM_Cpp"));
        this.f95 = this.createLine(4, this.getString("LBL_F95"), this.getString("MNEM_F95"));
        this.asm = this.createLine(5, this.getString("LBL_Asm"), this.getString("MNEM_Asm"));
        this.c.addFocusListener(this);
        this.cpp.addFocusListener(this);
        this.f95.addFocusListener(this);
        this.asm.addFocusListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
    }

    private JTextField createLine(int n, String string, String string2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(string2.charAt(0));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = n == 1 ? new Insets(5, 0, 0, 0) : new Insets(11, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = new JTextField();
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        JButton jButton = new JButton(this.getString("BTN_Chooser"));
        String string3 = "MNEM_Chooser" + new Integer(n);
        jButton.setMnemonic(this.getString(string3).charAt(0));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.createChooser(jTextField, jButton);
        return jTextField;
    }

    protected void createChooser(final JTextField jTextField, JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CompilerPathPanel.this.fc == null) {
                    CompilerPathPanel.this.fc = new JFileChooser();
                    CompilerPathPanel.this.fc.setApproveButtonText(CompilerPathPanel.this.getString("BTN_Approve"));
                    CompilerPathPanel.this.fc.setFileSystemView(new IpeFileSystemView(CompilerPathPanel.this.fc.getFileSystemView()));
                    CompilerPathPanel.this.fc.setDialogTitle(CompilerPathPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                if (CompilerPathPanel.this.chooserDir == null) {
                    CompilerPathPanel.this.chooserDir = new File(CompilerPathPanel.this.getMakefileData().getBaseDirectory());
                }
                CompilerPathPanel.this.fc.setCurrentDirectory(CompilerPathPanel.this.chooserDir);
                int n = CompilerPathPanel.this.fc.showDialog(CompilerPathPanel.this, null);
                if (n == 0) {
                    CompilerPathPanel.this.chooserDir = CompilerPathPanel.this.fc.getCurrentDirectory();
                    jTextField.setText(CompilerPathPanel.this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    public void addNotify() {
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        MakefileData makefileData = this.getMakefileData();
        this.c.setText(makefileData.getCCompiler(makefileData.getToolset()));
        this.cpp.setText(makefileData.getCppCompiler(makefileData.getToolset()));
        this.f95.setText(makefileData.getFCompiler(makefileData.getToolset()));
        this.asm.setText(makefileData.getAsmPath());
        super.addNotify();
        this.c.selectAll();
        IpeUtils.requestFocus(this.c);
    }

    public void removeNotify() {
        Object object;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (object = this.fc.getTopLevelAncestor()) != null && object instanceof JDialog) {
            ((JDialog)object).dispose();
        }
        object = this.getMakefileData();
        if (this.c.getText().length() > 0) {
            ((MakefileData)object).setCCompiler(((MakefileData)object).getToolset(), this.c.getText());
        }
        if (this.cpp.getText().length() > 0) {
            ((MakefileData)object).setCppCompiler(((MakefileData)object).getToolset(), this.cpp.getText());
        }
        if (this.f95.getText().length() > 0) {
            ((MakefileData)object).setFCompiler(((MakefileData)object).getToolset(), this.f95.getText());
        }
        if (this.asm.getText().length() > 0) {
            ((MakefileData)object).setAsmPath(this.asm.getText());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        ((JTextField)focusEvent.getComponent()).setSelectionEnd(0);
    }
}

