/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;

public class BaseDirectoryPanel
extends DirectoryChooserPanel {
    private boolean baseIsValid;
    static final long serialVersionUID = -4831717621793094L;
    private boolean initialized;

    public BaseDirectoryPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_BaseDirectoryPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
        this.baseIsValid = false;
    }

    public void validateData(ArrayList arrayList, int n) {
        File file = new File(this.getMakefileData().getBaseDirectory(true));
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.warn(arrayList, WARN_CWD_NOT_DIR, file.getPath());
            }
        } else {
            this.warn(arrayList, WARN_CWD_DOES_NOT_EXIST, file.getPath());
        }
    }

    public boolean isPanelValid() {
        return this.baseIsValid;
    }

    protected final void onOk() {
        this.checkit();
    }

    private void validateCurrentBase() {
        JTextField jTextField = this.getText();
        File file = null;
        this.baseIsValid = false;
        String string = IpeUtils.expandPath(jTextField.getText());
        if (string.length() > 0) {
            file = string.charAt(0) == File.separatorChar ? new File(string) : new File(".", string);
        }
        if (file != null && !file.isFile()) {
            this.baseIsValid = true;
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    private void create() {
        this.create(this.getString("LBL_BaseDirectory"), 1, this.getString("HLP_BaseDirectory"));
        JTextField jTextField = this.getText();
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                BaseDirectoryPanel.this.checkit();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                BaseDirectoryPanel.this.checkit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BaseDirectoryPanel.this.checkit();
            }
        });
        this.getLabel().setLabelFor(jTextField);
        this.getLabel().setDisplayedMnemonic(this.getString("MNEM_BaseDirectory").charAt(0));
    }

    private final void checkit() {
        boolean bl = this.baseIsValid;
        this.validateCurrentBase();
        if (this.baseIsValid != bl) {
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            MakefileWizard.getMakefileWizard().initDirPaths();
            this.create();
        }
        super.addNotify();
        this.getText().setText(this.getMakefileData().getBaseDirectory());
        this.validateCurrentBase();
    }

    public void removeNotify() {
        super.removeNotify();
        String string = this.getText().getText();
        if (!string.equals(this.getMakefileData().getBaseDirectory())) {
            this.getMakefileData().setBaseDirectory(string);
        }
        MakefileWizard.getMakefileWizard().initMakefileName();
    }
}

