/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.shell;

import java.util.Stack;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cnd.editor.shell.ShellTokenContext;

public class ShellSyntax
extends Syntax {
    private static final int AFTER_COLON = 1;
    private static final int AFTER_DOLLAR = 2;
    private static final int AFTER_BSLASH = 3;
    private static final int AFTER_PLUS = 4;
    private static final int IN_STRING = 5;
    private static final int IN_STRING_AFTER_BSLASH = 6;
    private static final int IN_MACRO = 7;
    private static final int IN_MACRO_AFTER_DELIM = 8;
    private static final int IN_WHITESPACE = 9;
    private static final int IN_LINE_COMMENT = 10;
    private static final int IN_IDENTIFIER = 11;
    private static final int IN_DOT_IDENTIFIER = 12;
    private static final int IN_COLON_IDENTIFIER = 13;
    private static final int IN_SHELL_COMMAND = 14;
    private static final int START_COMMENT = 15;
    private static boolean STRING_IN_DOUBLE_QUOTE = true;
    private static Integer BRACE_DELIM = new Integer(1);
    private static Integer PARAN_DELIM = new Integer(2);
    private Stack macroDelimStack = new Stack();

    public ShellSyntax() {
        this.tokenContextPath = ShellTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        Integer n;
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '#': {
                            this.state = 15;
                            break block0;
                        }
                        case ':': {
                            this.state = 1;
                            break block0;
                        }
                        case '.': {
                            this.state = 12;
                            break block0;
                        }
                        case '$': {
                            this.state = 2;
                            break block0;
                        }
                        case '\\': {
                            this.state = 3;
                            break block0;
                        }
                        case '\"': {
                            this.state = 5;
                            STRING_IN_DOUBLE_QUOTE = true;
                            break block0;
                        }
                        case '\'': {
                            this.state = 5;
                            STRING_IN_DOUBLE_QUOTE = false;
                            break block0;
                        }
                        case '+': {
                            this.state = 4;
                            break block0;
                        }
                        case '-': {
                            ++this.offset;
                            return ShellTokenContext.RULES_MINUS;
                        }
                        case '@': {
                            ++this.offset;
                            return ShellTokenContext.RULES_AT;
                        }
                        case '?': {
                            ++this.offset;
                            return ShellTokenContext.RULES_QUESTION_MARK;
                        }
                        case '!': {
                            ++this.offset;
                            return ShellTokenContext.RULES_EXCLAMATION;
                        }
                        case '%': {
                            ++this.offset;
                            return ShellTokenContext.TARGET_PERCENT;
                        }
                        case '=': {
                            ++this.offset;
                            return ShellTokenContext.MACRO_OP_EQUALS;
                        }
                        case '(': {
                            ++this.offset;
                            return ShellTokenContext.MACRO_LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return ShellTokenContext.MACRO_RPAREN;
                        }
                        case '{': {
                            ++this.offset;
                            return ShellTokenContext.MACRO_LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return ShellTokenContext.MACRO_RBRACE;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = 9;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 11;
                        break;
                    }
                    ++this.offset;
                    return ShellTokenContext.IDENTIFIER;
                }
                case 9: {
                    if (Character.isWhitespace(c)) break;
                    this.state = -1;
                    return ShellTokenContext.WHITESPACE;
                }
                case 15: {
                    if (c == '!') {
                        this.state = 14;
                        break;
                    }
                    this.state = 10;
                    break;
                }
                case 10: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            ++this.offset;
                            return ShellTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 14: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            ++this.offset;
                            return ShellTokenContext.SHELL_COMMAND;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '$': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_ESCAPED_DOLLAR;
                        }
                    }
                    this.state = 11;
                    --this.offset;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '$': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DOLAR_REFERENCE;
                        }
                        case '*': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DYN_TARGET_BASENAME;
                        }
                        case '<': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DYN_DEPENDENCY_FILENAME;
                        }
                        case '@': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DYN_CURRENTTARGET;
                        }
                        case '?': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DYN_DEPENDENCY_LIST;
                        }
                        case '%': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_DYN_LIBRARYNAME;
                        }
                        case '(': 
                        case '{': {
                            --this.offset;
                            this.state = 8;
                            break block0;
                        }
                    }
                    this.state = 7;
                    break;
                }
                case 7: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    switch (c) {
                        case '-': 
                        case '.': {
                            break block0;
                        }
                    }
                    this.state = -1;
                    return ShellTokenContext.MACRO_LITERAL;
                }
                case 8: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    switch (c) {
                        case '(': {
                            this.macroDelimStack.push(PARAN_DELIM);
                            break block0;
                        }
                        case '{': {
                            this.macroDelimStack.push(BRACE_DELIM);
                            break block0;
                        }
                        case ')': 
                        case '}': {
                            Integer n2 = n = c == ')' ? PARAN_DELIM : BRACE_DELIM;
                            if (!this.macroDelimStack.empty() && (Integer)this.macroDelimStack.pop() == n) {
                                if (!this.macroDelimStack.empty()) break block0;
                                this.state = -1;
                                ++this.offset;
                                return ShellTokenContext.MACRO_LITERAL;
                            }
                            this.state = -1;
                            ++this.offset;
                            this.macroDelimStack = new Stack();
                            return ShellTokenContext.ERR_INCOMPLETE_MACRO_LITERAL;
                        }
                        default: {
                            if (this.macroDelimStack.empty()) {
                                this.state = -1;
                                return ShellTokenContext.MACRO_LITERAL;
                            }
                            this.state = -1;
                            return ShellTokenContext.MACRO_LITERAL;
                        }
                    }
                }
                case 4: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_OP_APPEND;
                        }
                    }
                    this.state = -1;
                    ++this.offset;
                    return ShellTokenContext.RULES_PLUS;
                }
                case 1: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.MACRO_OP_CONDITIONAL;
                        }
                        case ':': {
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.TARGET_DOUBLE_COLON;
                        }
                        case 'S': 
                        case 's': {
                            this.state = 13;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return ShellTokenContext.TARGET_COLON;
                }
                case 13: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    n = ShellSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (n != null) {
                        return n;
                    }
                    this.offset = this.tokenOffset + 1;
                    return ShellTokenContext.TARGET_COLON;
                }
                case 12: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    n = ShellSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (n != null) {
                        return n;
                    }
                    this.offset = this.tokenOffset + 1;
                    this.state = -1;
                    return ShellTokenContext.IDENTIFIER;
                }
                case 11: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    n = ShellSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return n != null ? n : ShellTokenContext.IDENTIFIER;
                }
                case 5: {
                    switch (c) {
                        case '\\': {
                            this.state = 6;
                            break;
                        }
                        case '\n': {
                            this.state = -1;
                            ++this.offset;
                            this.supposedTokenID = ShellTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            if (!STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.STRING_LITERAL;
                        }
                        case '\'': {
                            if (STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return ShellTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 5;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 9: {
                    this.state = -1;
                    return ShellTokenContext.WHITESPACE;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.state = -1;
                    n = ShellSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return n != null ? n : ShellTokenContext.IDENTIFIER;
                }
                case 5: 
                case 6: {
                    return ShellTokenContext.STRING_LITERAL;
                }
                case 7: 
                case 8: {
                    this.state = -1;
                    return ShellTokenContext.MACRO_LITERAL;
                }
                case 3: {
                    this.state = -1;
                    return ShellTokenContext.IDENTIFIER;
                }
                case 4: {
                    this.state = -1;
                    return ShellTokenContext.RULES_PLUS;
                }
                case 2: {
                    this.state = -1;
                    return ShellTokenContext.MACRO_DOLLAR;
                }
                case 1: {
                    this.state = -1;
                    return ShellTokenContext.TARGET_COLON;
                }
                case 10: {
                    return ShellTokenContext.LINE_COMMENT;
                }
                case 14: {
                    return ShellTokenContext.SHELL_COMMAND;
                }
            }
        }
        switch (this.state) {
            case 9: {
                return ShellTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int n) {
        switch (n) {
            case 1: {
                return "AFTER_COLON";
            }
            case 2: {
                return "AFTER_DOLLAR";
            }
            case 3: {
                return "AFTER_BSLASH";
            }
            case 4: {
                return "AFTER_PLUS";
            }
            case 5: {
                return "IN_STRING";
            }
            case 6: {
                return "IN_STRING_AFTER_BSLASH";
            }
            case 7: {
                return "IN_MACRO";
            }
            case 8: {
                return "IN_MACRO_AFTER_DELIM";
            }
            case 10: {
                return "IN_LINE_COMMENT";
            }
            case 14: {
                return "IN_SHELL_COMMAND";
            }
            case 11: {
                return "IN_IDENTIFIER";
            }
            case 12: {
                return "IN_DOT_IDENTIFIER";
            }
            case 13: {
                return "IN_COLON_IDENTIFIER";
            }
            case 9: {
                return "IN_WHITESPACE";
            }
        }
        return super.getStateName(n);
    }

    public static TokenID matchKeyword(char[] cArray, int n, int n2) {
        if (n2 <= 1 || n2 > 17) {
            return null;
        }
        switch (Character.toLowerCase(cArray[n++])) {
            case '.': {
                if (n2 < 5 || n2 > 16) {
                    return null;
                }
                switch (Character.toLowerCase(cArray[n++])) {
                    case 'd': {
                        switch (Character.toLowerCase(cArray[n++])) {
                            case 'e': {
                                return n2 == 8 && Character.toLowerCase(cArray[n++]) == 'f' && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'u' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 't' ? ShellTokenContext.TARGET_DEFAULT : null;
                            }
                            case 'o': {
                                return n2 == 5 && Character.toLowerCase(cArray[n++]) == 'n' && Character.toLowerCase(cArray[n++]) == 'e' ? ShellTokenContext.TARGET_DONE : null;
                            }
                        }
                        return null;
                    }
                    case 'f': {
                        return n2 == 7 && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'd' ? ShellTokenContext.TARGET_FAILED : null;
                    }
                    case 'g': {
                        return n2 == 10 && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 't' && Character.toLowerCase(cArray[n++]) == '_' && Character.toLowerCase(cArray[n++]) == 'p' && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'x' ? ShellTokenContext.TARGET_GETPOSIX : null;
                    }
                    case 'i': {
                        switch (Character.toLowerCase(cArray[n++])) {
                            case 'g': {
                                return n2 == 7 && Character.toLowerCase(cArray[n++]) == 'n' && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == 'r' && Character.toLowerCase(cArray[n++]) == 'e' ? ShellTokenContext.TARGET_IGNORE : null;
                            }
                            case 'n': {
                                return n2 == 5 && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 't' ? ShellTokenContext.TARGET_INIT : null;
                            }
                        }
                        return null;
                    }
                    case 'k': {
                        if (n2 >= 11 && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'p' && Character.toLowerCase(cArray[n++]) == '_' && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 't' && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 't' && Character.toLowerCase(cArray[n++]) == 'e') {
                            if (n2 == 11) {
                                return ShellTokenContext.TARGET_KEEPSTATE;
                            }
                            switch (Character.toLowerCase(cArray[n++])) {
                                case '_': {
                                    return n2 == 16 && Character.toLowerCase(cArray[n++]) == 'f' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'e' ? ShellTokenContext.TARGET_KEEPSTATEFILE : null;
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                    case 'm': {
                        return n2 == 13 && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'k' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == '_' && Character.toLowerCase(cArray[n++]) == 'v' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'r' && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == 'n' ? ShellTokenContext.TARGET_MAKEVERSION : null;
                    }
                    case 'n': {
                        return n2 == 12 && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == '_' && Character.toLowerCase(cArray[n++]) == 'p' && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'r' && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'l' ? ShellTokenContext.TARGET_NOPARALLEL : null;
                    }
                    case 'p': {
                        switch (Character.toLowerCase(cArray[n++])) {
                            case 'a': {
                                return n2 == 9 && Character.toLowerCase(cArray[n++]) == 'r' && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'l' ? ShellTokenContext.TARGET_PARALLEL : null;
                            }
                            case 'o': {
                                return n2 == 6 && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'x' ? ShellTokenContext.TARGET_POSIX : null;
                            }
                            case 'r': {
                                return n2 == 9 && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'c' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == 'u' && Character.toLowerCase(cArray[n++]) == 's' ? ShellTokenContext.TARGET_PRECIOUS : null;
                            }
                        }
                        return null;
                    }
                    case 's': {
                        switch (Character.toLowerCase(cArray[n++])) {
                            case 'c': {
                                if (n2 >= 9 && Character.toLowerCase(cArray[n++]) == 'c' && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == '_' && Character.toLowerCase(cArray[n++]) == 'g' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 't') {
                                    if (n2 == 9) {
                                        return ShellTokenContext.TARGET_SCCSGET;
                                    }
                                    switch (Character.toLowerCase(cArray[n++])) {
                                        case '_': {
                                            return n2 == 15 && Character.toLowerCase(cArray[n++]) == 'p' && Character.toLowerCase(cArray[n++]) == 'o' && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'x' ? ShellTokenContext.TARGET_SCCSGETPOSIX : null;
                                        }
                                    }
                                    return null;
                                }
                                return null;
                            }
                            case 'i': {
                                return n2 == 7 && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 'n' && Character.toLowerCase(cArray[n++]) == 't' ? ShellTokenContext.TARGET_SILENT : null;
                            }
                            case 'u': {
                                return n2 == 9 && Character.toLowerCase(cArray[n++]) == 'f' && Character.toLowerCase(cArray[n++]) == 'f' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 'x' && Character.toLowerCase(cArray[n++]) == 'e' && Character.toLowerCase(cArray[n++]) == 's' ? ShellTokenContext.TARGET_SUFFIXES : null;
                            }
                        }
                        return null;
                    }
                    case 'w': {
                        return n2 == 5 && Character.toLowerCase(cArray[n++]) == 'a' && Character.toLowerCase(cArray[n++]) == 'i' && Character.toLowerCase(cArray[n++]) == 't' ? ShellTokenContext.TARGET_WAIT : null;
                    }
                }
                return null;
            }
            case ':': {
                return n2 == 3 && Character.toLowerCase(cArray[n++]) == 's' && Character.toLowerCase(cArray[n++]) == 'h' ? ShellTokenContext.MACRO_COMMAND_SUBSTITUTE : null;
            }
            case 'i': {
                return n2 == 7 && Character.toLowerCase(cArray[n++]) == 'n' && Character.toLowerCase(cArray[n++]) == 'c' && Character.toLowerCase(cArray[n++]) == 'l' && Character.toLowerCase(cArray[n++]) == 'u' && Character.toLowerCase(cArray[n++]) == 'd' && Character.toLowerCase(cArray[n++]) == 'e' ? ShellTokenContext.GLOBAL_INCLUDE : null;
            }
        }
        return null;
    }
}

