/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.loaders.ShellDataLoader;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;

public class ShellFileFilter
extends FileFilter {
    private static ShellFileFilter instance = null;
    private ResourceBundle bundle;

    public static ShellFileFilter getInstance() {
        if (instance == null) {
            instance = new ShellFileFilter();
        }
        return instance;
    }

    public String getDescription() {
        return this.getString("FILECHOOSER_SHELL_FILEFILTER");
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            if (this.checkExtension(file)) {
                return true;
            }
            if (this.checkFirstFewBytes(file)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkExtension(File file) {
        String string = file.getName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        ExtensionList extensionList = ShellDataLoader.getInstance().getExtensions();
        Enumeration enumeration = extensionList.extensions();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3 == null || !string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFirstFewBytes(File file) {
        byte[] byArray = new byte[2];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n = ((InputStream)fileInputStream).read(byArray, 0, 2);
            if (n < 2) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray[0] == 35 && byArray[1] == 33;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ShellFileFilter.class);
        }
        return this.bundle.getString(string);
    }
}

