/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.utils.Path;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolchainManager {
    private static final boolean TRACE = Boolean.getBoolean("cnd.toolchain.personality.trace");
    private static final ToolchainManager instance = new ToolchainManager();
    private List<ToolchainDescriptor> descriptors = new ArrayList<ToolchainDescriptor>();

    static final ToolchainManager getInstance() {
        return instance;
    }

    private ToolchainManager() {
        try {
            TreeMap<Integer, CompilerVendor> treeMap = new TreeMap<Integer, CompilerVendor>();
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Services/CndToolChain");
            int n = 0x3FFFFFFF;
            if (fileObject != null && fileObject.isFolder()) {
                Object object;
                for (Object object2 : object = fileObject.getChildren()) {
                    CompilerVendor compilerVendor = new CompilerVendor();
                    Integer n2 = (Integer)object2.getAttribute("position");
                    if (n2 == null || treeMap.containsKey(n2)) {
                        n2 = new Integer(n++);
                    }
                    if (!this.read((FileObject)object2, (FileObject[])object, compilerVendor, new HashSet<FileObject>())) continue;
                    treeMap.put(n2, compilerVendor);
                }
            }
            if (TRACE) {
                System.out.println("Declared vendors:");
            }
            for (Object object : treeMap.values()) {
                if (TRACE) {
                    System.out.println(((CompilerVendor)object).toString());
                }
                this.descriptors.add(new ToolchainDescriptorImpl((CompilerVendor)object));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    ToolchainDescriptor getToolchain(String string, int n) {
        ToolchainDescriptor toolchainDescriptor = null;
        for (ToolchainDescriptor toolchainDescriptor2 : this.descriptors) {
            if (this.isPlatforSupported(n, toolchainDescriptor2) && string.equals(toolchainDescriptor2.getName())) {
                return toolchainDescriptor2;
            }
            if (toolchainDescriptor != null || !this.isPlatforSupported(6, toolchainDescriptor2)) continue;
            toolchainDescriptor = toolchainDescriptor2;
        }
        return toolchainDescriptor;
    }

    List<ToolchainDescriptor> getAllToolchains() {
        return new ArrayList<ToolchainDescriptor>(this.descriptors);
    }

    List<ToolchainDescriptor> getToolchains(int n) {
        ArrayList<ToolchainDescriptor> arrayList = new ArrayList<ToolchainDescriptor>();
        for (ToolchainDescriptor toolchainDescriptor : this.descriptors) {
            if (!this.isPlatforSupported(n, toolchainDescriptor)) continue;
            arrayList.add(toolchainDescriptor);
        }
        return arrayList;
    }

    boolean isPlatforSupported(int n, ToolchainDescriptor toolchainDescriptor) {
        switch (n) {
            case 0: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_sparc".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_intel".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"linux".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"windows".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"mac".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"unix".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"none".equals(string)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean isMyFolder(String string, ToolchainDescriptor toolchainDescriptor, int n) {
        boolean bl = this.isMyFolderImpl(string, toolchainDescriptor, n);
        if (TRACE && bl) {
            System.out.println("Path [" + string + "] belongs to tool chain " + toolchainDescriptor.getName());
        }
        return bl;
    }

    private boolean isMyFolderImpl(String string, ToolchainDescriptor toolchainDescriptor, int n) {
        Object object;
        Object object2;
        CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
        if (compilerDescriptor == null || compilerDescriptor.getNames().length == 0) {
            return false;
        }
        Pattern pattern = null;
        if (compilerDescriptor.getPathPattern() != null) {
            pattern = n == 3 ? Pattern.compile(compilerDescriptor.getPathPattern(), 2) : Pattern.compile(compilerDescriptor.getPathPattern());
        }
        if (pattern != null && !pattern.matcher(string).find()) {
            object2 = compilerDescriptor.getExistFolder();
            if (object2 == null) {
                return false;
            }
            object = new File(string + "/" + (String)object2);
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                return false;
            }
        }
        if (!((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0]))).exists() && !((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0] + ".exe"))).exists()) {
            return false;
        }
        object = compilerDescriptor.getVersionFlags();
        if (object == null) {
            return true;
        }
        if (compilerDescriptor.getVersionPattern() == null) {
            return true;
        }
        pattern = Pattern.compile(compilerDescriptor.getVersionPattern());
        String string2 = ToolchainManager.getCommandOutput(string, string + "/" + compilerDescriptor.getNames()[0] + " " + (String)object, true);
        boolean bl = pattern.matcher(string2).find();
        if (TRACE && !bl) {
            System.out.println("No match for pattern [" + compilerDescriptor.getVersionPattern() + "]:");
        }
        if (TRACE && !bl) {
            System.out.println("Run " + string + "/" + compilerDescriptor.getNames()[0] + " " + (String)object + "\n" + string2);
        }
        return bl;
    }

    String getBaseFolder(ToolchainDescriptor toolchainDescriptor, int n) {
        if (n != 3) {
            return null;
        }
        String string = toolchainDescriptor.getBaseFolderPattern();
        String string2 = toolchainDescriptor.getBaseFolderKey();
        if (string2 == null || string == null) {
            return null;
        }
        String string3 = this.readRegestry(string2, string);
        if (string3 != null && toolchainDescriptor.getBaseFolderSuffix() != null) {
            string3 = string3 + "/" + toolchainDescriptor.getBaseFolderSuffix();
        }
        return string3;
    }

    String getCommandFolder(ToolchainDescriptor toolchainDescriptor, int n) {
        if (n != 3) {
            return null;
        }
        String string = toolchainDescriptor.getCommandFolderPattern();
        String string2 = toolchainDescriptor.getCommandFolderKey();
        if (string2 == null || string == null) {
            return null;
        }
        String string3 = this.readRegestry(string2, string);
        if (string3 != null && toolchainDescriptor.getCommandFolderSuffix() != null) {
            string3 = string3 + "\\" + toolchainDescriptor.getCommandFolderSuffix();
        }
        if (string3 == null && (string = toolchainDescriptor.getCommandFolderPathPattern()) != null && string.length() > 0) {
            Pattern pattern = Pattern.compile(string);
            for (String string4 : Path.getPath()) {
                if (!pattern.matcher(string4).find()) continue;
                string3 = string4;
                break;
            }
        }
        return string3;
    }

    private String readRegestry(String string, String string2) {
        String string3;
        block5: {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("C:/Windows/System32/reg.exe");
            arrayList.add("query");
            arrayList.add(string);
            arrayList.add("/s");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            string3 = null;
            try {
                String string4;
                if (TRACE) {
                    System.out.println("Read registry " + string);
                }
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Pattern pattern = Pattern.compile(string2);
                while ((string4 = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    string4 = string4.trim();
                    if (TRACE) {
                        System.out.println("\t" + string4);
                    }
                    if (!(matcher = pattern.matcher(string4)).find() || matcher.groupCount() != 1) continue;
                    string3 = matcher.group(1).trim();
                    if (!TRACE) continue;
                    System.out.println("\tFound " + string3);
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block5;
                exception.printStackTrace();
            }
        }
        return string3;
    }

    private static String getCommandOutput(String string, String string2, boolean bl) {
        StringBuilder stringBuilder;
        block21: {
            String iOException;
            Object object;
            stringBuilder = new StringBuilder();
            if (string == null) {
                string = "";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : System.getenv().keySet()) {
                object = System.getenv().get(object2);
                if (object2.equals(Path.getPathName())) {
                    arrayList.add(Path.getPathName() + "=" + string + File.pathSeparatorChar + (String)object);
                    continue;
                }
                iOException = object2 + "=" + (String)(object != null ? object : "");
                arrayList.add(iOException);
            }
            try {
                InputStream inputStream;
                block20: {
                    Process process;
                    block19: {
                        InputStream inputStream2;
                        block18: {
                            process = Runtime.getRuntime().exec(string2, arrayList.toArray(new String[arrayList.size()]));
                            inputStream2 = process.getInputStream();
                            object = new BufferedReader(new InputStreamReader(inputStream2));
                            try {
                                while ((iOException = ((BufferedReader)object).readLine()) != null) {
                                    stringBuilder.append(iOException);
                                    stringBuilder.append('\n');
                                }
                            }
                            catch (IOException iOException2) {
                                if (!TRACE) break block18;
                                iOException2.printStackTrace();
                            }
                        }
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                        }
                        catch (IOException iOException3) {
                            if (!TRACE) break block19;
                            iOException3.printStackTrace();
                        }
                    }
                    inputStream = process.getErrorStream();
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        while ((iOException = ((BufferedReader)object).readLine()) != null) {
                            stringBuilder.append(iOException);
                            stringBuilder.append('\n');
                        }
                    }
                    catch (IOException iOException4) {
                        if (!TRACE) break block20;
                        iOException4.printStackTrace();
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    if (TRACE) {
                        iOException5.printStackTrace();
                    }
                }
            }
            catch (IOException iOException6) {
                if (!TRACE) break block21;
                iOException6.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    private boolean read(FileObject fileObject, FileObject[] fileObjectArray, CompilerVendor compilerVendor, Set<FileObject> set) {
        if (set.contains(fileObject)) {
            return false;
        }
        set.add(fileObject);
        String string = (String)fileObject.getAttribute("extends");
        if (string != null) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (!string.equals(fileObject2.getName()) || this.read(fileObject2, fileObjectArray, compilerVendor, set)) continue;
                return false;
            }
        }
        try {
            this.read(fileObject.getInputStream(), compilerVendor);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private boolean read(InputStream inputStream, CompilerVendor compilerVendor) {
        Object object;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        XMLReader xMLReader = null;
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        object = new SAXHandler(compilerVendor);
        xMLReader.setContentHandler((ContentHandler)object);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DebuggerDescriptorImpl
    extends ToolDescriptorImpl<Debugger>
    implements DebuggerDescriptor {
        public DebuggerDescriptorImpl(Debugger debugger) {
            super(debugger);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MakeDescriptorImpl
    extends ToolDescriptorImpl<Make>
    implements MakeDescriptor {
        private MakeDescriptorImpl(Make make) {
            super(make);
        }

        @Override
        public String getDependencySupportCode() {
            return ((Make)this.tool).dependencySupportCode;
        }
    }

    private static final class LinkerDescriptorImpl
    implements LinkerDescriptor {
        private Linker l;

        private LinkerDescriptorImpl(Linker linker) {
            this.l = linker;
        }

        public String getLibrarySearchFlag() {
            return this.l.librarySearchFlag;
        }

        public String getDynamicLibrarySearchFlag() {
            return this.l.dynamicLibrarySearchFlag;
        }

        public String getLibraryFlag() {
            return this.l.libraryFlag;
        }

        public String getLibraryPrefix() {
            return this.l.library_prefix;
        }

        public String getPICFlag() {
            return this.l.PICFlag;
        }

        public String getStaticLibraryFlag() {
            return this.l.staticLibraryFlag;
        }

        public String getDynamicLibraryFlag() {
            return this.l.dynamicLibraryFlag;
        }

        public String getDynamicLibraryBasicFlag() {
            return this.l.dynamicLibraryBasicFlag;
        }
    }

    private static final class ScannerPatternImpl
    implements ScannerPattern {
        private ErrorPattern e;

        private ScannerPatternImpl(ErrorPattern errorPattern) {
            this.e = errorPattern;
        }

        public String getPattern() {
            return this.e.pattern;
        }

        public String getSeverity() {
            return this.e.severity;
        }

        public String getLanguage() {
            return this.e.language;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerDescriptorImpl
    implements ScannerDescriptor {
        private Scanner s;
        private List<ScannerPattern> patterns;

        private ScannerDescriptorImpl(Scanner scanner) {
            this.s = scanner;
        }

        @Override
        public List<ScannerPattern> getPatterns() {
            if (this.patterns == null) {
                this.patterns = new ArrayList<ScannerPattern>();
                for (ErrorPattern errorPattern : this.s.patterns) {
                    this.patterns.add(new ScannerPatternImpl(errorPattern));
                }
            }
            return this.patterns;
        }

        @Override
        public String getChangeDirectoryPattern() {
            return this.s.changeDirectoryPattern;
        }

        @Override
        public String getEnterDirectoryPattern() {
            return this.s.enterDirectoryPattern;
        }

        @Override
        public String getLeaveDirectoryPattern() {
            return this.s.leaveDirectoryPattern;
        }

        @Override
        public String getStackHeaderPattern() {
            return this.s.stackHeaderPattern;
        }

        @Override
        public String getStackNextPattern() {
            return this.s.stackNextPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompilerDescriptorImpl
    extends ToolDescriptorImpl<Compiler>
    implements CompilerDescriptor {
        private CompilerDescriptorImpl(Compiler compiler) {
            super(compiler);
        }

        @Override
        public String getPathPattern() {
            return ((Compiler)this.tool).pathPattern;
        }

        @Override
        public String getExistFolder() {
            return ((Compiler)this.tool).existFolder;
        }

        @Override
        public String getIncludeFlags() {
            return ((Compiler)this.tool).includeFlags;
        }

        @Override
        public String getIncludeParser() {
            return ((Compiler)this.tool).includeOutputParser;
        }

        @Override
        public String getRemoveIncludePathPrefix() {
            return ((Compiler)this.tool).removeIncludePathPrefix;
        }

        @Override
        public String getRemoveIncludeOutputPrefix() {
            return ((Compiler)this.tool).removeIncludeOutputPrefix;
        }

        @Override
        public String getUserIncludeFlag() {
            return ((Compiler)this.tool).userIncludeFlag;
        }

        @Override
        public String getMacroFlags() {
            return ((Compiler)this.tool).macrosFlags;
        }

        @Override
        public String getMacroParser() {
            return ((Compiler)this.tool).macrosFlags;
        }

        @Override
        public String getUserMacroFlag() {
            return ((Compiler)this.tool).userMacroFlag;
        }

        @Override
        public String[] getDevelopmentModeFlags() {
            return ((Compiler)this.tool).developmentMode.values();
        }

        @Override
        public String[] getWarningLevelFlags() {
            return ((Compiler)this.tool).warningLevel.values();
        }

        @Override
        public String[] getArchitectureFlags() {
            return ((Compiler)this.tool).architecture.values();
        }

        @Override
        public String getStripFlag() {
            return ((Compiler)this.tool).strip;
        }

        @Override
        public String[] getMultithreadingFlags() {
            return ((Compiler)this.tool).multithreading.values();
        }

        @Override
        public String[] getStandardFlags() {
            return ((Compiler)this.tool).standard.values();
        }

        @Override
        public String[] getLanguageExtensionFlags() {
            return ((Compiler)this.tool).languageExtension.values();
        }

        @Override
        public String[] getLibraryFlags() {
            return ((Compiler)this.tool).library.values();
        }

        @Override
        public String getDependencyGenerationFlags() {
            return ((Compiler)this.tool).dependencyGenerationFlags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolDescriptorImpl<T extends Tool>
    implements ToolDescriptor {
        protected T tool;

        public ToolDescriptorImpl(T t) {
            this.tool = t;
        }

        @Override
        public String[] getNames() {
            if (((Tool)this.tool).name != null && ((Tool)this.tool).name.length() > 0) {
                return ((Tool)this.tool).name.split(",");
            }
            return new String[0];
        }

        @Override
        public String getVersionFlags() {
            return ((Tool)this.tool).versionFlags;
        }

        @Override
        public String getVersionPattern() {
            return ((Tool)this.tool).versionPattern;
        }
    }

    private static final class ToolchainDescriptorImpl
    implements ToolchainDescriptor {
        private CompilerVendor v;
        private CompilerDescriptor c;
        private CompilerDescriptor cpp;
        private CompilerDescriptor fortran;
        private LinkerDescriptor linker;
        private ScannerDescriptor scanner;
        private MakeDescriptor make;
        private DebuggerDescriptor debugger;

        private ToolchainDescriptorImpl(CompilerVendor compilerVendor) {
            this.v = compilerVendor;
        }

        public String getName() {
            return this.v.toolChainName;
        }

        public String getDisplayName() {
            return this.v.toolChainDisplay;
        }

        public String[] getFamily() {
            if (this.v.family != null && this.v.family.length() > 0) {
                return this.v.family.split(",");
            }
            return new String[0];
        }

        public String[] getPlatforms() {
            if (this.v.platforms != null && this.v.platforms.length() > 0) {
                return this.v.platforms.split(",");
            }
            return new String[0];
        }

        public String getDriveLetterPrefix() {
            return this.v.driveLetterPrefix;
        }

        public CompilerDescriptor getC() {
            if (this.c == null && this.v.c.isValid()) {
                this.c = new CompilerDescriptorImpl(this.v.c);
            }
            return this.c;
        }

        public String getBaseFolderKey() {
            return this.v.baseFolderKey;
        }

        public String getBaseFolderPattern() {
            return this.v.baseFolderPattern;
        }

        public String getBaseFolderSuffix() {
            return this.v.baseFolderSuffix;
        }

        public String getBaseFolderPathPattern() {
            return this.v.baseFolderPathPattern;
        }

        public String getCommandFolderKey() {
            return this.v.commandFolderKey;
        }

        public String getCommandFolderPattern() {
            return this.v.commandFolderPattern;
        }

        public String getCommandFolderSuffix() {
            return this.v.commandFolderSuffix;
        }

        public String getCommandFolderPathPattern() {
            return this.v.commandFolderPathPattern;
        }

        public CompilerDescriptor getCpp() {
            if (this.cpp == null && this.v.cpp.isValid()) {
                this.cpp = new CompilerDescriptorImpl(this.v.cpp);
            }
            return this.cpp;
        }

        public CompilerDescriptor getFortran() {
            if (this.fortran == null && this.v.fortran.isValid()) {
                this.fortran = new CompilerDescriptorImpl(this.v.fortran);
            }
            return this.fortran;
        }

        public ScannerDescriptor getScanner() {
            if (this.scanner == null) {
                this.scanner = new ScannerDescriptorImpl(this.v.scanner);
            }
            return this.scanner;
        }

        public LinkerDescriptor getLinker() {
            if (this.linker == null) {
                this.linker = new LinkerDescriptorImpl(this.v.linker);
            }
            return this.linker;
        }

        public MakeDescriptor getMake() {
            if (this.make == null) {
                this.make = new MakeDescriptorImpl(this.v.make);
            }
            return this.make;
        }

        public DebuggerDescriptor getDebugger() {
            if (this.debugger == null) {
                this.debugger = new DebuggerDescriptorImpl(this.v.debugger);
            }
            return this.debugger;
        }

        public String toString() {
            return this.v.toolChainName + "/" + this.v.family + "/" + this.v.platforms;
        }
    }

    private static final class SAXHandler
    extends DefaultHandler {
        private String path;
        private CompilerVendor v;
        private boolean isScanerOverrided = false;
        private int version = 1;

        private SAXHandler(CompilerVendor compilerVendor) {
            this.v = compilerVendor;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.path != null) {
                this.path = this.path.equals(string3) ? null : this.path.substring(0, this.path.length() - string3.length() - 1);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            super.startElement(string, string2, string3, attributes);
            this.path = this.path == null ? string3 : this.path + "." + string3;
            if (this.path.equals("toolchaindefinition")) {
                object = attributes.getValue("xmlns");
                if (object != null) {
                    int n = ((String)object).lastIndexOf(47);
                    if (n >= 0 && n + 1 < ((String)object).length()) {
                        String string4 = ((String)object).substring(n + 1);
                        if (string4.length() > 0) {
                            try {
                                this.version = Integer.parseInt(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (TRACE) {
                                    System.out.println("Incorrect version information:" + (String)object);
                                }
                            }
                        }
                    } else if (TRACE) {
                        System.out.println("Incorrect version information:" + (String)object);
                    }
                }
            } else {
                if (this.path.endsWith(".toolchain")) {
                    this.v.toolChainName = attributes.getValue("name");
                    this.v.toolChainDisplay = attributes.getValue("display");
                    this.v.family = attributes.getValue("family");
                    return;
                }
                if (this.path.endsWith(".platforms")) {
                    this.v.platforms = attributes.getValue("stringvalue");
                    return;
                }
                if (this.path.endsWith(".drive_letter_prefix")) {
                    this.v.driveLetterPrefix = attributes.getValue("stringvalue");
                    return;
                }
                if (this.path.endsWith(".base_folder")) {
                    this.v.baseFolderKey = attributes.getValue("regestry");
                    this.v.baseFolderPattern = attributes.getValue("pattern");
                    this.v.baseFolderSuffix = attributes.getValue("suffix");
                    this.v.baseFolderPathPattern = attributes.getValue("path_patern");
                    return;
                }
                if (this.path.endsWith(".command_folder")) {
                    this.v.commandFolderKey = attributes.getValue("regestry");
                    this.v.commandFolderPattern = attributes.getValue("pattern");
                    this.v.commandFolderSuffix = attributes.getValue("suffix");
                    this.v.commandFolderPathPattern = attributes.getValue("path_patern");
                    return;
                }
            }
            if (this.path.indexOf(".linker.") > 0) {
                object = this.v.linker;
                if (this.path.endsWith(".library_prefix")) {
                    ((Linker)object).library_prefix = attributes.getValue("stringvalue");
                    return;
                }
                if (this.path.endsWith(".library_search")) {
                    ((Linker)object).librarySearchFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_search")) {
                    ((Linker)object).dynamicLibrarySearchFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".library")) {
                    ((Linker)object).libraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".PIC")) {
                    ((Linker)object).PICFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".static_library")) {
                    ((Linker)object).staticLibraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library")) {
                    ((Linker)object).dynamicLibraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_basic")) {
                    ((Linker)object).dynamicLibraryBasicFlag = attributes.getValue("flags");
                    return;
                }
                return;
            }
            if (this.path.indexOf(".make.") > 0) {
                object = this.v.make;
                if (this.path.endsWith(".tool")) {
                    ((Make)object).name = attributes.getValue("name");
                } else if (this.path.endsWith(".version")) {
                    ((Make)object).versionFlags = attributes.getValue("flags");
                    ((Make)object).versionPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".dependency_support")) {
                    ((Make)object).dependencySupportCode = attributes.getValue("code").replace("\\n", "\n");
                }
            }
            if (this.path.indexOf(".debugger.") > 0) {
                object = this.v.debugger;
                if (this.path.endsWith(".tool")) {
                    ((Debugger)object).name = attributes.getValue("name");
                } else if (this.path.endsWith(".version")) {
                    ((Debugger)object).versionFlags = attributes.getValue("flags");
                    ((Debugger)object).versionPattern = attributes.getValue("pattern");
                }
            }
            if (this.path.indexOf(".scanner.") > 0) {
                if (!this.isScanerOverrided) {
                    this.v.scanner = new Scanner();
                    this.isScanerOverrided = true;
                }
                object = this.v.scanner;
                if (this.path.endsWith(".error")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    ((Scanner)object).patterns.add(errorPattern);
                    errorPattern.severity = attributes.getValue("error");
                    errorPattern.pattern = attributes.getValue("pattern");
                    errorPattern.language = attributes.getValue("language");
                } else if (this.path.endsWith(".warning")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    ((Scanner)object).patterns.add(errorPattern);
                    errorPattern.severity = attributes.getValue("warning");
                    errorPattern.pattern = attributes.getValue("pattern");
                    errorPattern.language = attributes.getValue("language");
                } else if (this.path.endsWith(".change_directory")) {
                    ((Scanner)object).changeDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".enter_directory")) {
                    ((Scanner)object).enterDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".leave_directory")) {
                    ((Scanner)object).leaveDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".stack_header")) {
                    ((Scanner)object).stackHeaderPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".stack_next")) {
                    ((Scanner)object).stackNextPattern = attributes.getValue("pattern");
                }
            }
            if (this.path.indexOf(".c.") > 0) {
                object = this.v.c;
            } else if (this.path.indexOf(".cpp.") > 0) {
                object = this.v.cpp;
            } else if (this.path.indexOf(".fortran.") > 0) {
                object = this.v.fortran;
            } else {
                return;
            }
            if (this.path.endsWith(".compiler")) {
                ((Compiler)object).name = attributes.getValue("name");
                return;
            }
            if (this.path.endsWith(".recognizer")) {
                ((Compiler)object).pathPattern = attributes.getValue("pattern");
                ((Compiler)object).existFolder = attributes.getValue("or_exist_folder");
                return;
            }
            if (this.path.endsWith(".version")) {
                ((Compiler)object).versionPattern = attributes.getValue("pattern");
                ((Compiler)object).versionFlags = attributes.getValue("flags");
                return;
            }
            String string5 = attributes.getValue("flags");
            if (string5 == null) {
                return;
            }
            boolean bl = "true".equals(attributes.getValue("default"));
            if (this.path.endsWith(".system_include_paths")) {
                ((Compiler)object).includeFlags = string5;
                ((Compiler)object).includeOutputParser = attributes.getValue("parser");
                ((Compiler)object).removeIncludePathPrefix = attributes.getValue("remove_in_path");
                ((Compiler)object).removeIncludeOutputPrefix = attributes.getValue("remove_in_output");
            } else if (this.path.endsWith(".user_include")) {
                ((Compiler)object).userIncludeFlag = string5;
            } else if (this.path.endsWith(".system_macros")) {
                ((Compiler)object).macrosFlags = string5;
                ((Compiler)object).macrosOutputParser = attributes.getValue("parser");
            } else if (this.path.endsWith(".user_macro")) {
                ((Compiler)object).userMacroFlag = string5;
            } else if (this.path.indexOf(".development_mode.") > 0) {
                DevelopmentMode developmentMode = ((Compiler)object).developmentMode;
                if (this.path.endsWith(".fast_build")) {
                    developmentMode.fast_build = string5;
                    if (bl) {
                        developmentMode.default_selection = 0;
                    }
                } else if (this.path.endsWith(".debug")) {
                    developmentMode.debug = string5;
                    if (bl) {
                        developmentMode.default_selection = 1;
                    }
                } else if (this.path.endsWith(".performance_debug")) {
                    developmentMode.performance_debug = string5;
                    if (bl) {
                        developmentMode.default_selection = 2;
                    }
                } else if (this.path.endsWith(".test_coverage")) {
                    developmentMode.test_coverage = string5;
                    if (bl) {
                        developmentMode.default_selection = 3;
                    }
                } else if (this.path.endsWith(".diagnosable_release")) {
                    developmentMode.diagnosable_release = string5;
                    if (bl) {
                        developmentMode.default_selection = 4;
                    }
                } else if (this.path.endsWith(".release")) {
                    developmentMode.release = string5;
                    if (bl) {
                        developmentMode.default_selection = 5;
                    }
                } else if (this.path.endsWith(".performance_release")) {
                    developmentMode.performance_release = string5;
                    if (bl) {
                        developmentMode.default_selection = 6;
                    }
                }
            } else if (this.path.indexOf(".warning_level.") > 0) {
                WarningLevel warningLevel = ((Compiler)object).warningLevel;
                if (this.path.endsWith(".no_warnings")) {
                    warningLevel.no_warnings = string5;
                    if (bl) {
                        warningLevel.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    warningLevel.default_level = string5;
                    if (bl) {
                        warningLevel.default_selection = 1;
                    }
                } else if (this.path.endsWith(".more_warnings")) {
                    warningLevel.more_warnings = string5;
                    if (bl) {
                        warningLevel.default_selection = 2;
                    }
                } else if (this.path.endsWith(".warning2error")) {
                    warningLevel.warning2error = string5;
                    if (bl) {
                        warningLevel.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".architecture.") > 0) {
                Architecture architecture = ((Compiler)object).architecture;
                if (this.path.endsWith(".default")) {
                    architecture.default_architecture = string5;
                    if (bl) {
                        architecture.default_selection = 0;
                    }
                } else if (this.path.endsWith(".bits_32")) {
                    architecture.bits_32 = string5;
                    if (bl) {
                        architecture.default_selection = 1;
                    }
                } else if (this.path.endsWith(".bits_64")) {
                    architecture.bits_64 = string5;
                    if (bl) {
                        architecture.default_selection = 2;
                    }
                }
            } else if (this.path.endsWith(".strip")) {
                ((Compiler)object).strip = string5;
            } else if (this.path.endsWith(".dependency_generation")) {
                ((Compiler)object).dependencyGenerationFlags = string5;
            } else if (this.path.indexOf(".multithreading.") > 0) {
                MultiThreading multiThreading = ((Compiler)object).multithreading;
                if (this.path.endsWith(".none")) {
                    multiThreading.none = string5;
                    if (bl) {
                        multiThreading.default_selection = 0;
                    }
                } else if (this.path.endsWith(".safe")) {
                    multiThreading.safe = string5;
                    if (bl) {
                        multiThreading.default_selection = 1;
                    }
                } else if (this.path.endsWith(".automatic")) {
                    multiThreading.automatic = string5;
                    if (bl) {
                        multiThreading.default_selection = 2;
                    }
                } else if (this.path.endsWith(".open_mp")) {
                    multiThreading.open_mp = string5;
                    if (bl) {
                        multiThreading.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".standard.") > 0) {
                Standard standard = ((Compiler)object).standard;
                if (this.path.endsWith(".old")) {
                    standard.old = string5;
                    if (bl) {
                        standard.default_selection = 0;
                    }
                } else if (this.path.endsWith(".legacy")) {
                    standard.legacy = string5;
                    if (bl) {
                        standard.default_selection = 1;
                    }
                } else if (this.path.endsWith(".default")) {
                    standard.default_standard = string5;
                    if (bl) {
                        standard.default_selection = 2;
                    }
                } else if (this.path.endsWith(".modern")) {
                    standard.modern = string5;
                    if (bl) {
                        standard.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".language_extension.") > 0) {
                LanguageExtension languageExtension = ((Compiler)object).languageExtension;
                if (this.path.endsWith(".none")) {
                    languageExtension.none = string5;
                    if (bl) {
                        languageExtension.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    languageExtension.default_extension = string5;
                    if (bl) {
                        languageExtension.default_selection = 1;
                    }
                } else if (this.path.endsWith(".all")) {
                    languageExtension.all = string5;
                    if (bl) {
                        languageExtension.default_selection = 2;
                    }
                }
            } else if (this.path.indexOf(".library.") > 0) {
                Library library = ((Compiler)object).library;
                if (this.path.endsWith(".none")) {
                    library.none = string5;
                    if (bl) {
                        library.default_selection = 0;
                    }
                } else if (this.path.endsWith(".runtime")) {
                    library.runtime = string5;
                    if (bl) {
                        library.default_selection = 1;
                    }
                } else if (this.path.endsWith(".classic")) {
                    library.classic = string5;
                    if (bl) {
                        library.default_selection = 2;
                    }
                } else if (this.path.endsWith(".binary_standard")) {
                    library.binary_standard = string5;
                    if (bl) {
                        library.default_selection = 3;
                    }
                } else if (this.path.endsWith(".conforming_standard")) {
                    library.conforming_standard = string5;
                    if (bl) {
                        library.default_selection = 4;
                    }
                }
            }
        }
    }

    private static final class Library {
        private String none;
        private String runtime;
        private String classic;
        private String binary_standard;
        private String conforming_standard;
        private int default_selection = 0;

        private Library() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.runtime + ";" + this.classic + ";" + this.binary_standard + ";" + this.conforming_standard + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.runtime != null && this.classic != null && this.binary_standard != null && this.conforming_standard != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.runtime, this.classic, this.binary_standard, this.conforming_standard};
            }
            return null;
        }
    }

    private static final class LanguageExtension {
        private String none;
        private String default_extension;
        private String all;
        private int default_selection = 0;

        private LanguageExtension() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.default_extension + ";" + this.all + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.default_extension != null && this.all != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.default_extension, this.all};
            }
            return null;
        }
    }

    private static final class Standard {
        private String old;
        private String legacy;
        private String default_standard;
        private String modern;
        private int default_selection = 0;

        private Standard() {
        }

        public String toString() {
            return "[" + this.old + ";" + this.legacy + ";" + this.default_standard + ";" + this.modern + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.old != null && this.legacy != null && this.default_standard != null && this.modern != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.old, this.legacy, this.default_standard, this.modern};
            }
            return null;
        }
    }

    private static final class MultiThreading {
        private String none;
        private String safe;
        private String automatic;
        private String open_mp;
        private int default_selection = 0;

        private MultiThreading() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.safe + ";" + this.automatic + ";" + this.open_mp + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.safe != null && this.automatic != null && this.open_mp != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.safe, this.automatic, this.open_mp};
            }
            return null;
        }
    }

    private static final class Architecture {
        private String default_architecture;
        private String bits_32;
        private String bits_64;
        private int default_selection = 0;

        private Architecture() {
        }

        public String toString() {
            return "[" + this.default_architecture + ";" + this.bits_32 + ";" + this.bits_64 + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.default_architecture != null && this.bits_32 != null && this.bits_64 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.default_architecture, this.bits_32, this.bits_64};
            }
            return null;
        }
    }

    private static final class WarningLevel {
        private String no_warnings;
        private String default_level;
        private String more_warnings;
        private String warning2error;
        private int default_selection = 0;

        private WarningLevel() {
        }

        public String toString() {
            return "[" + this.no_warnings + ";" + this.default_level + ";" + this.more_warnings + ";" + this.warning2error + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.no_warnings != null && this.default_level != null && this.more_warnings != null && this.warning2error != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.no_warnings, this.default_level, this.more_warnings, this.warning2error};
            }
            return null;
        }
    }

    private static final class DevelopmentMode {
        private String fast_build;
        private String debug;
        private String performance_debug;
        private String test_coverage;
        private String diagnosable_release;
        private String release;
        private String performance_release;
        private int default_selection = 0;

        private DevelopmentMode() {
        }

        public String toString() {
            return "[" + this.fast_build + ";" + this.debug + ";" + this.performance_debug + ";" + this.test_coverage + ";" + this.diagnosable_release + ";" + this.release + ";" + this.performance_release + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.fast_build != null && this.debug != null && this.performance_debug != null && this.test_coverage != null && this.diagnosable_release != null && this.release != null && this.performance_release != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.fast_build, this.debug, this.performance_debug, this.test_coverage, this.diagnosable_release, this.release, this.performance_release};
            }
            return null;
        }
    }

    private static final class Debugger
    extends Tool {
        private Debugger() {
        }
    }

    private static final class Make
    extends Tool {
        private String dependencySupportCode;

        private Make() {
        }
    }

    private static final class Linker {
        private String library_prefix;
        private String librarySearchFlag;
        private String dynamicLibrarySearchFlag;
        private String libraryFlag;
        private String PICFlag;
        private String staticLibraryFlag;
        private String dynamicLibraryFlag;
        private String dynamicLibraryBasicFlag;

        private Linker() {
        }
    }

    private static final class ErrorPattern {
        private String pattern;
        private String severity;
        private String language;

        private ErrorPattern() {
        }
    }

    private static final class Scanner {
        private List<ErrorPattern> patterns = new ArrayList<ErrorPattern>();
        private String changeDirectoryPattern;
        private String enterDirectoryPattern;
        private String leaveDirectoryPattern;
        private String stackHeaderPattern;
        private String stackNextPattern;

        private Scanner() {
        }
    }

    private static final class Compiler
    extends Tool {
        private String pathPattern;
        private String existFolder;
        private String includeFlags;
        private String includeOutputParser;
        private String removeIncludePathPrefix;
        private String removeIncludeOutputPrefix;
        private String userIncludeFlag;
        private String macrosFlags;
        private String macrosOutputParser;
        private String userMacroFlag;
        private String dependencyGenerationFlags;
        private DevelopmentMode developmentMode = new DevelopmentMode();
        private WarningLevel warningLevel = new WarningLevel();
        private Architecture architecture = new Architecture();
        private String strip;
        private MultiThreading multithreading = new MultiThreading();
        private Standard standard = new Standard();
        private LanguageExtension languageExtension = new LanguageExtension();
        private Library library = new Library();

        private Compiler() {
        }

        public boolean isValid() {
            return this.name != null && this.name.length() > 0;
        }
    }

    private static class Tool {
        protected String name;
        protected String versionFlags;
        protected String versionPattern;

        private Tool() {
        }
    }

    private static final class CompilerVendor {
        private String toolChainName;
        private String toolChainDisplay;
        private String family;
        private String platforms;
        private String driveLetterPrefix;
        private String baseFolderKey;
        private String baseFolderPattern;
        private String baseFolderSuffix;
        private String baseFolderPathPattern;
        private String commandFolderKey;
        private String commandFolderPattern;
        private String commandFolderSuffix;
        private String commandFolderPathPattern;
        private Compiler c = new Compiler();
        private Compiler cpp = new Compiler();
        private Compiler fortran = new Compiler();
        private Scanner scanner = new Scanner();
        private Linker linker = new Linker();
        private Make make = new Make();
        private Debugger debugger = new Debugger();

        private CompilerVendor() {
        }

        public boolean isValid() {
            return this.toolChainName != null && this.toolChainName.length() > 0 && (this.c.isValid() || this.cpp.isValid() || this.fortran.isValid());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Toolchain [" + this.toolChainName + "/" + this.family + "] " + this.toolChainDisplay + "\n");
            stringBuilder.append("\tPlatforms [" + this.platforms + "]\n");
            stringBuilder.append("\tDrive Letter Prefix [" + this.driveLetterPrefix + "]\n");
            stringBuilder.append("\tBase Folder Key [" + this.baseFolderKey + "] Pattern [" + this.baseFolderPattern + "] Suffix [" + this.baseFolderSuffix + "] Path Pattern[" + this.baseFolderPattern + "] \n");
            stringBuilder.append("\tCommand Folder Key [" + this.commandFolderKey + "] Pattern [" + this.commandFolderPattern + "] Suffix [" + this.commandFolderSuffix + "] Path Pattern[" + this.commandFolderPattern + "] \n");
            stringBuilder.append("C compiler [" + this.c.name + "] Recognize path [" + this.c.pathPattern + "] Version [" + this.c.versionFlags + ";" + this.c.versionPattern + "]\n");
            stringBuilder.append("\tInclude flags [" + this.c.includeFlags + "] parser [" + this.c.includeOutputParser + "] remove from path[" + this.c.removeIncludePathPrefix + "] remove from output [" + this.c.removeIncludeOutputPrefix + "]\n");
            stringBuilder.append("\tMacros flags [" + this.c.macrosFlags + "] parser [" + this.c.macrosOutputParser + "]\n");
            stringBuilder.append("\tDevelopment mode " + this.c.developmentMode + "\n");
            stringBuilder.append("\tWarning Level " + this.c.warningLevel + "\n");
            stringBuilder.append("\tArchitecture " + this.c.architecture + "\n");
            stringBuilder.append("\tStrip [" + this.c.strip + "]\n");
            if (this.c.multithreading.isValid()) {
                stringBuilder.append("\tMultithreading [" + this.c.multithreading + "]\n");
            }
            if (this.c.standard.isValid()) {
                stringBuilder.append("\tStandard [" + this.c.standard + "]\n");
            }
            if (this.c.languageExtension.isValid()) {
                stringBuilder.append("\tLanguage [" + this.c.languageExtension + "]\n");
            }
            if (this.c.library.isValid()) {
                stringBuilder.append("\tLibrary [" + this.c.library + "]\n");
            }
            stringBuilder.append("C++ compiler [" + this.cpp.name + "] Recognize path [" + this.cpp.pathPattern + "] Version [" + this.cpp.versionFlags + ";" + this.cpp.versionPattern + "]\n");
            stringBuilder.append("\tInclude flags [" + this.cpp.includeFlags + "] parser [" + this.cpp.includeOutputParser + "] remove from path[" + this.cpp.removeIncludePathPrefix + "] remove from output [" + this.cpp.removeIncludeOutputPrefix + "]\n");
            stringBuilder.append("\tMacros flags [" + this.cpp.macrosFlags + "] parser [" + this.cpp.macrosOutputParser + "]\n");
            stringBuilder.append("\tDevelopment mode " + this.cpp.developmentMode + "\n");
            stringBuilder.append("\tWarning Level " + this.cpp.warningLevel + "\n");
            stringBuilder.append("\tArchitecture " + this.cpp.architecture + "\n");
            stringBuilder.append("\tStrip [" + this.cpp.strip + "]\n");
            stringBuilder.append("\tDependency generation flags [" + this.cpp.dependencyGenerationFlags + "]\n");
            if (this.cpp.multithreading.isValid()) {
                stringBuilder.append("\tMultithreading " + this.cpp.multithreading + "\n");
            }
            if (this.cpp.standard.isValid()) {
                stringBuilder.append("\tStandard " + this.cpp.standard + "\n");
            }
            if (this.cpp.languageExtension.isValid()) {
                stringBuilder.append("\tLanguage " + this.cpp.languageExtension + "\n");
            }
            if (this.cpp.library.isValid()) {
                stringBuilder.append("\tLibrary " + this.cpp.library + "\n");
            }
            if (this.fortran.isValid()) {
                stringBuilder.append("Fortran compiler [" + this.fortran.name + "] Recognize path [" + this.fortran.pathPattern + "] Version [" + this.fortran.versionFlags + ";" + this.fortran.versionPattern + "]\n");
                stringBuilder.append("\tDevelopment mode " + this.fortran.developmentMode + "\n");
                stringBuilder.append("\tWarning Level " + this.fortran.warningLevel + "\n");
                stringBuilder.append("\tArchitecture " + this.fortran.architecture + "\n");
                stringBuilder.append("\tStrip [" + this.fortran.strip + "]\n");
            }
            stringBuilder.append("Scanner\n");
            stringBuilder.append("\tChange Directory [" + this.scanner.changeDirectoryPattern + "]\n");
            stringBuilder.append("\tEnter Directory [" + this.scanner.enterDirectoryPattern + "]\n");
            stringBuilder.append("\tLeave Directory [" + this.scanner.leaveDirectoryPattern + "]\n");
            stringBuilder.append("\tStack Header [" + this.scanner.stackHeaderPattern + "]\n");
            stringBuilder.append("\tStack Next [" + this.scanner.stackNextPattern + "]\n");
            for (ErrorPattern errorPattern : this.scanner.patterns) {
                stringBuilder.append("\tPattern [" + errorPattern.pattern + "] Level [" + errorPattern.severity + "] Language [" + errorPattern.language + "]\n");
            }
            stringBuilder.append("Linker\n");
            stringBuilder.append("\tLibrary prefix [" + this.linker.library_prefix + "]\n");
            stringBuilder.append("\tLibrary search [" + this.linker.librarySearchFlag + "]\n");
            stringBuilder.append("\tDynamic library search [" + this.linker.dynamicLibrarySearchFlag + "]\n");
            stringBuilder.append("\tLibrary [" + this.linker.libraryFlag + "]\n");
            stringBuilder.append("\tPIC [" + this.linker.PICFlag + "]\n");
            stringBuilder.append("\tStatic library [" + this.linker.staticLibraryFlag + "]\n");
            stringBuilder.append("\tDynamic library [" + this.linker.dynamicLibraryFlag + "]\n");
            stringBuilder.append("\tDynamic library basic [" + this.linker.dynamicLibraryBasicFlag + "]\n");
            stringBuilder.append("Make [" + this.make.name + "] Version [" + this.make.versionFlags + "; " + this.make.versionPattern + "]\n");
            stringBuilder.append("\tDependency support code [" + this.make.dependencySupportCode + "]\n");
            stringBuilder.append("Debugger [" + this.debugger.name + "] Version [" + this.debugger.versionFlags + "; " + this.debugger.versionPattern + "]\n");
            return stringBuilder.toString();
        }
    }

    public static interface ScannerPattern {
        public String getPattern();

        public String getSeverity();

        public String getLanguage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ScannerDescriptor {
        public List<ScannerPattern> getPatterns();

        public String getChangeDirectoryPattern();

        public String getEnterDirectoryPattern();

        public String getLeaveDirectoryPattern();

        public String getStackHeaderPattern();

        public String getStackNextPattern();
    }

    public static interface LinkerDescriptor {
        public String getLibraryPrefix();

        public String getLibrarySearchFlag();

        public String getDynamicLibrarySearchFlag();

        public String getLibraryFlag();

        public String getPICFlag();

        public String getStaticLibraryFlag();

        public String getDynamicLibraryFlag();

        public String getDynamicLibraryBasicFlag();
    }

    public static interface DebuggerDescriptor
    extends ToolDescriptor {
    }

    public static interface MakeDescriptor
    extends ToolDescriptor {
        public String getDependencySupportCode();
    }

    public static interface CompilerDescriptor
    extends ToolDescriptor {
        public String getPathPattern();

        public String getExistFolder();

        public String getIncludeFlags();

        public String getUserIncludeFlag();

        public String getIncludeParser();

        public String getRemoveIncludePathPrefix();

        public String getRemoveIncludeOutputPrefix();

        public String getMacroFlags();

        public String getUserMacroFlag();

        public String getMacroParser();

        public String[] getDevelopmentModeFlags();

        public String[] getWarningLevelFlags();

        public String[] getArchitectureFlags();

        public String getStripFlag();

        public String[] getMultithreadingFlags();

        public String[] getStandardFlags();

        public String[] getLanguageExtensionFlags();

        public String[] getLibraryFlags();

        public String getDependencyGenerationFlags();
    }

    public static interface ToolDescriptor {
        public String[] getNames();

        public String getVersionFlags();

        public String getVersionPattern();
    }

    public static interface ToolchainDescriptor {
        public String getName();

        public String getDisplayName();

        public String[] getFamily();

        public String[] getPlatforms();

        public String getDriveLetterPrefix();

        public String getBaseFolderKey();

        public String getBaseFolderPattern();

        public String getBaseFolderSuffix();

        public String getBaseFolderPathPattern();

        public String getCommandFolderKey();

        public String getCommandFolderPattern();

        public String getCommandFolderSuffix();

        public String getCommandFolderPathPattern();

        public CompilerDescriptor getC();

        public CompilerDescriptor getCpp();

        public CompilerDescriptor getFortran();

        public ScannerDescriptor getScanner();

        public LinkerDescriptor getLinker();

        public MakeDescriptor getMake();

        public DebuggerDescriptor getDebugger();
    }
}

