/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd;

import java.io.File;
import java.io.IOException;
import org.netbeans.editor.Settings;
import org.netbeans.modules.cnd.editor.shell.ShellKit;
import org.netbeans.modules.cnd.editor.shell.ShellSettingsInitializer;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.Utilities;

public class CndModule
extends ModuleInstall {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.cnd");

    public void restored() {
        Settings.addInitializer((Settings.Initializer)new ShellSettingsInitializer(ShellKit.class));
        if (Utilities.isUnix()) {
            this.setExecutionPermission("bin/dorun.sh");
            this.setExecutionPermission("bin/stdouterr.sh");
            if (Utilities.getOperatingSystem() == 8) {
                if (System.getProperty("os.arch").equals("sparc")) {
                    this.setExecutionPermission("bin/GdbHelper-SunOS-sparc.so");
                } else {
                    this.setExecutionPermission("bin/GdbHelper-SunOS-x86.so");
                }
            } else if (Utilities.getOperatingSystem() == 16) {
                this.setExecutionPermission("bin/GdbHelper-Linux-x86.so");
            } else if (Utilities.isMac()) {
                this.setExecutionPermission("bin/GdbHelper-Mac_OS_X-x86.dylib");
            }
        }
    }

    private void setExecutionPermission(String string) {
        File file = InstalledFileLocator.getDefault().locate(string, null, false);
        if (file != null && file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/chmod", "755", file.getAbsolutePath());
            try {
                processBuilder.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

