/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionFactory;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.RestServicesImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestServiceDescriptionImpl
extends PersistentObject
implements RestServiceDescription {
    private String name;
    private String uriTemplate;
    private String className;
    private Map<String, RestMethodDescriptionImpl> methods;
    private boolean isRest;

    public RestServiceDescriptionImpl(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        super(annotationModelHelper, typeElement);
        this.name = typeElement.getSimpleName().toString();
        this.uriTemplate = Utils.getUriTemplate(typeElement);
        this.className = typeElement.getQualifiedName().toString();
        this.isRest = true;
        this.initMethods(typeElement);
    }

    private void initMethods(TypeElement typeElement) {
        this.methods = new HashMap<String, RestMethodDescriptionImpl>();
        AnnotationModelHelper annotationModelHelper = this.getHelper();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            this.addMethod(element);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public List<RestMethodDescription> getMethods() {
        ArrayList<RestMethodDescription> arrayList = new ArrayList<RestMethodDescription>();
        for (RestMethodDescriptionImpl restMethodDescriptionImpl : this.methods.values()) {
            arrayList.add((RestMethodDescription)((Object)restMethodDescriptionImpl));
        }
        return arrayList;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isRest() {
        return this.isRest;
    }

    public RestServicesImpl.Status refresh(TypeElement typeElement) {
        String string;
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            return RestServicesImpl.Status.REMOVED;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (Utils.hasUriTemplate(typeElement)) {
            bl = true;
        }
        if (this.name != (string = typeElement.getSimpleName().toString())) {
            this.name = string;
            bl2 = true;
        }
        if (this.className != (string = typeElement.getQualifiedName().toString())) {
            this.className = string;
            bl2 = true;
        }
        if (!this.uriTemplate.equals(string = Utils.getUriTemplate(typeElement))) {
            this.uriTemplate = string;
            bl2 = true;
        }
        Map<String, RestMethodDescriptionImpl> map = this.methods;
        this.methods = new HashMap<String, RestMethodDescriptionImpl>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            String string2 = element.getSimpleName().toString();
            RestMethodDescriptionImpl restMethodDescriptionImpl = map.get(string2);
            if (restMethodDescriptionImpl != null) {
                RestServicesImpl.Status status = restMethodDescriptionImpl.refresh(element);
                switch (status) {
                    case REMOVED: {
                        if (this.addMethod(element)) {
                            bl = true;
                        }
                        bl2 = true;
                        break;
                    }
                    case MODIFIED: {
                        bl = true;
                        bl2 = true;
                        this.methods.put(string2, restMethodDescriptionImpl);
                        break;
                    }
                    case UNMODIFIED: {
                        bl = true;
                        this.methods.put(string2, restMethodDescriptionImpl);
                    }
                }
                continue;
            }
            if (!this.addMethod(element)) continue;
            bl = true;
            bl2 = true;
        }
        if (this.methods.size() != map.size()) {
            bl2 = true;
        }
        if (!bl) {
            this.isRest = false;
            return RestServicesImpl.Status.REMOVED;
        }
        if (bl2) {
            return RestServicesImpl.Status.MODIFIED;
        }
        return RestServicesImpl.Status.UNMODIFIED;
    }

    private boolean addMethod(Element element) {
        RestMethodDescriptionImpl restMethodDescriptionImpl = RestMethodDescriptionFactory.create(element);
        if (restMethodDescriptionImpl != null) {
            this.methods.put(element.getSimpleName().toString(), restMethodDescriptionImpl);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name + "[" + this.uriTemplate + "]";
    }
}

