/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetBinding;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;

public class WidgetMover
implements MoveStrategy,
MoveProvider {
    private CasaWrapperModel mModel;
    private boolean mCanMoveHorizontal;
    private boolean mCanStretchHorizontal;
    private Point mOriginalLocation;
    private boolean mIsWidgetFronted;

    public WidgetMover(CasaWrapperModel casaWrapperModel, boolean bl, boolean bl2) {
        this.mModel = casaWrapperModel;
        this.mCanMoveHorizontal = bl;
        this.mCanStretchHorizontal = bl2;
    }

    public Point locationSuggested(Widget widget, Point point, Point point2) {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        if (casaModelGraphScene.findObject(widget) == null) {
            return null;
        }
        if (point.equals(point2)) {
            return point;
        }
        assert (widget instanceof CasaNodeWidget);
        CasaNodeWidget casaNodeWidget = (CasaNodeWidget)widget;
        Point point3 = new Point();
        point3.x = point.x;
        point3.y = point.y;
        CasaRegionWidget casaRegionWidget = (CasaRegionWidget)casaNodeWidget.getParentWidget();
        Rectangle rectangle = casaRegionWidget.getBounds();
        Rectangle rectangle2 = casaNodeWidget.getBounds();
        if (rectangle != null && rectangle2 != null) {
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.x + 30;
            int n3 = rectangle2.width + 10;
            if (this.mCanMoveHorizontal) {
                if (point2.x < n2) {
                    point3.x = n2;
                } else if (!this.mCanStretchHorizontal && point2.x + n3 > n) {
                    point3.x = n - n3;
                    point3.x = point3.x < 0 ? 0 : point3.x;
                } else {
                    point3.x = point2.x;
                }
            }
            point3.y = point2.y < rectangle.y ? rectangle.y : point2.y;
            if (this.mCanMoveHorizontal && !this.mCanStretchHorizontal && n - (n2 + n3) <= 0) {
                point3.x = point.x;
            }
            if (point3.y < casaRegionWidget.getTitleYOffset()) {
                point3.y = casaRegionWidget.getTitleYOffset();
            }
        }
        return point3;
    }

    private static CasaNodeWidget getOverlappedWidget(Widget widget, Widget[] widgetArray, Rectangle rectangle) {
        for (Widget widget2 : widget.getChildren()) {
            if (!(widget2 instanceof CasaNodeWidget)) continue;
            boolean bl = false;
            Object object = widgetArray;
            int n = ((Widget[])object).length;
            for (int i = 0; i < n; ++i) {
                Widget widget3 = object[i];
                if (widget2 != widget3) continue;
                bl = true;
                break;
            }
            if (bl || !((CasaNodeWidget)((Object)(object = (CasaNodeWidget)widget2))).getEntireBounds().intersects(rectangle)) continue;
            return object;
        }
        return null;
    }

    public void movementStarted(Widget widget) {
        this.mOriginalLocation = widget.getLocation();
        this.mIsWidgetFronted = false;
    }

    public void movementFinished(Widget widget) {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        if (casaModelGraphScene.findObject(widget) == null) {
            return;
        }
        Point point = this.mOriginalLocation;
        this.mOriginalLocation = null;
        this.mIsWidgetFronted = false;
        Point point2 = widget.getPreferredLocation();
        if (point2.equals(point)) {
            return;
        }
        casaModelGraphScene.persistLocation((CasaNodeWidget)widget, point2);
        CasaNodeWidget casaNodeWidget = (CasaNodeWidget)widget;
        CasaNodeWidget casaNodeWidget2 = WidgetMover.getOverlappedWidget(casaNodeWidget.getParentWidget(), new Widget[]{casaNodeWidget}, casaNodeWidget.getEntireBounds());
        if (casaNodeWidget2 != null) {
            if (widget instanceof CasaNodeWidgetEngine) {
                widget.setPreferredLocation(point);
            } else if (widget instanceof CasaNodeWidgetBinding) {
                casaModelGraphScene.progressiveRegionLayout(casaModelGraphScene.getBindingRegion(), true);
            }
        }
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point point) {
        if (point == null) {
            return;
        }
        if (widget.getPreferredLocation().equals(point)) {
            return;
        }
        if (!this.mIsWidgetFronted && this.mOriginalLocation != null && !this.mOriginalLocation.equals(point)) {
            this.mIsWidgetFronted = true;
            widget.bringToFront();
        }
        CasaRegionWidget casaRegionWidget = (CasaRegionWidget)widget.getParentWidget();
        Rectangle rectangle = casaRegionWidget.getBounds();
        Rectangle rectangle2 = widget.getBounds();
        widget.setPreferredLocation(point);
        boolean bl = false;
        boolean bl2 = false;
        if (rectangle != null && rectangle2 != null) {
            if (this.mCanMoveHorizontal && this.mCanStretchHorizontal && point.x + rectangle2.width + 10 > rectangle.x + rectangle.width) {
                bl = true;
            }
            if (point.y + rectangle2.height + 60 > rectangle.y + rectangle.height) {
                bl2 = true;
            }
        }
        if (bl && !bl2) {
            RegionUtilities.stretchSceneWidthOnly((CasaModelGraphScene)widget.getScene());
        } else if (bl2 && !bl) {
            RegionUtilities.stretchSceneHeightOnly((CasaModelGraphScene)widget.getScene());
        } else if (bl && bl2) {
            RegionUtilities.stretchScene((CasaModelGraphScene)widget.getScene());
        }
    }
}

