/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public final class SerialLayoutWithJustifications
implements Layout {
    private boolean verticalOrientation;
    private LayoutFactory.SerialAlignment alignment;
    private int gap;

    public SerialLayoutWithJustifications(boolean bl, LayoutFactory.SerialAlignment serialAlignment, int n) {
        this.verticalOrientation = bl;
        this.alignment = serialAlignment;
        this.gap = n;
    }

    public void layout(Widget widget) {
        int n = 0;
        List list = widget.getChildren();
        if (this.verticalOrientation) {
            for (Object object : list) {
                Rectangle rectangle = object.getPreferredBounds();
                int n2 = rectangle.width;
                if (n2 <= n) continue;
                n = n2;
            }
            int n3 = 0;
            for (Rectangle rectangle : list) {
                Rectangle rectangle2 = rectangle.getPreferredBounds();
                int n4 = rectangle2.x;
                int n5 = rectangle2.y;
                int n6 = rectangle2.width;
                int n7 = rectangle2.height;
                int n8 = -n4;
                int n9 = n3 - n5;
                switch (this.alignment) {
                    case CENTER: {
                        n8 += (n - n6) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        n6 = n;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        n8 += n - n6;
                    }
                }
                rectangle.resolveBounds(new Point(n8, n9), new Rectangle(n4, n5, n6, n7));
                n3 += n7 + this.gap;
            }
        } else {
            for (Object object : list) {
                Rectangle rectangle = object.getPreferredBounds();
                int n10 = rectangle.height;
                if (n10 <= n) continue;
                n = n10;
            }
            int n11 = 0;
            for (Rectangle rectangle : list) {
                Rectangle rectangle3 = rectangle.getPreferredBounds();
                int n12 = rectangle3.x;
                int n13 = rectangle3.y;
                int n14 = rectangle3.width;
                int n15 = rectangle3.height;
                int n16 = n11 - n12;
                int n17 = -n13;
                switch (this.alignment) {
                    case CENTER: {
                        n17 += (n - n15) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        n15 = n;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        n17 += n - n15;
                    }
                }
                rectangle.resolveBounds(new Point(n16, n17), new Rectangle(n12, n13, n14, n15));
                n11 += n14 + this.gap;
            }
        }
    }

    public boolean requiresJustification(Widget widget) {
        return true;
    }

    public void justify(Widget widget) {
        Rectangle rectangle = widget.getParentWidget().getClientArea();
        if (this.alignment == LayoutFactory.SerialAlignment.JUSTIFY || this.alignment == LayoutFactory.SerialAlignment.RIGHT_BOTTOM) {
            this.justifyChildren(widget, rectangle);
        }
        Rectangle rectangle2 = widget.getPreferredBounds();
        rectangle2.width = rectangle.width;
        widget.resolveBounds(widget.getLocation(), rectangle2);
    }

    private void justifyChildren(Widget widget, Rectangle rectangle) {
        int n = 0 - this.gap;
        for (Object object : widget.getChildren()) {
            n += object.getPreferredBounds().width;
            n += this.gap;
        }
        int n2 = rectangle.x + rectangle.width - n;
        for (Widget widget2 : widget.getChildren()) {
            int n3;
            int n4;
            int n5;
            int n6;
            Point point = widget2.getLocation();
            Rectangle rectangle2 = widget2.getBounds();
            if (this.verticalOrientation) {
                n6 = rectangle.x;
                n5 = n6 + rectangle.width;
                n4 = point.x + rectangle2.x;
                n3 = n4 + rectangle2.width;
                rectangle2.x = Math.min(n6, n4);
                rectangle2.width = Math.max(n5, n3) - rectangle2.x;
                rectangle2.x -= point.x;
                widget2.resolveBounds(point, rectangle2);
                continue;
            }
            n6 = rectangle.y;
            n5 = n6 + rectangle.height;
            n4 = point.y + rectangle2.y;
            n3 = n4 + rectangle2.height;
            rectangle2.y = Math.min(n6, n4);
            rectangle2.height = Math.max(n5, n3) - rectangle2.y;
            rectangle2.y -= point.y;
            switch (this.alignment) {
                case RIGHT_BOTTOM: {
                    point.x = n2;
                    n2 += rectangle2.width + this.gap;
                    widget2.resolveBounds(point, null);
                    break;
                }
                case CENTER: 
                case JUSTIFY: 
                case LEFT_TOP: {
                    widget2.resolveBounds(point, rectangle2);
                }
            }
        }
    }
}

