/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaBindingBadges;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetBindingConsumes;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetBindingProvides;
import org.openide.util.NbBundle;

public class CasaNodeWidgetBinding
extends CasaNodeWidget {
    private static final int VERT_TEXT_BAR_WIDTH = 20;
    private static final int VERT_TEXT_BAR_MIN_HEIGHT = 40;
    private static final int VERT_TEXT_BAR_MAX_CHAR = 6;
    private static final int VERT_TEXT_BAR_SPACING = 8;
    private static final int PIN_X_START = 4;
    private static final int PIN_Y_CONSUMES_START = 4;
    private static final int PIN_Y_PROVIDES_START = 26;
    private static final int NAME_LEFT_EDGE_SPACING = 0;
    private static final int BORDER_WIDTH = 2;
    private static final int TRAILING_VERTICAL_GAP = 10;
    private Widget mBodyWidget;
    private ImageWidget mVerticalTextImageWidget;
    private CasaBindingBadges mBadges;
    private LabelWidget mNameWidget;
    private Widget mPinsHolderWidget;
    private String mVertTextBarText;
    private Widget mHeaderHolder;

    public CasaNodeWidgetBinding(Scene scene, String string) {
        super(scene);
        this.setOpaque(true);
        this.setBackground(CasaFactory.getCasaCustomizer().getCOLOR_BC_BACKGROUND());
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.mBadges = new CasaBindingBadges(scene, string);
        this.mVerticalTextImageWidget = new ImageWidget(scene);
        this.mVerticalTextImageWidget.setMinimumSize(new Dimension(20, 0));
        this.mHeaderHolder = new Widget(scene);
        this.mHeaderHolder.setOpaque(true);
        this.mHeaderHolder.setBackground((Paint)CasaFactory.getCasaCustomizer().getCOLOR_BC_TITLE_BACKGROUND());
        this.mHeaderHolder.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)0));
        this.mHeaderHolder.addChild(this.mBadges.getContainerWidget());
        this.mHeaderHolder.addChild((Widget)this.mVerticalTextImageWidget);
        this.mPinsHolderWidget = new Widget(scene);
        this.mPinsHolderWidget.setLayout((Layout)new BindingPinsLayout());
        this.mPinsHolderWidget.setMinimumSize(new Dimension(44, 40));
        this.mBodyWidget = new Widget(scene);
        this.mBodyWidget.setOpaque(true);
        this.mBodyWidget.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)0));
        this.mBodyWidget.setBackground((Paint)CasaFactory.getCasaCustomizer().getCOLOR_BC_BACKGROUND());
        this.mBodyWidget.addChild(this.mHeaderHolder);
        this.mBodyWidget.addChild(this.mPinsHolderWidget);
        this.mContainerWidget = new Widget(scene);
        this.mContainerWidget.setBackground((Paint)CasaFactory.getCasaCustomizer().getCOLOR_BC_BACKGROUND());
        this.mContainerWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)0));
        this.mContainerWidget.addChild(this.mBodyWidget);
        this.addChild(this.mContainerWidget);
        this.mNameWidget = new LabelWidget(this.getScene());
        this.mNameWidget.setFont(CasaFactory.getCasaCustomizer().getFONT_BC_LABEL());
        this.mNameWidget.setForeground(CasaFactory.getCasaCustomizer().getCOLOR_BC_LABEL());
        this.regenerateHeaderBorder();
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
        this.regenerateVerticalTextBarImage();
        Widget.Dependency dependency = new Widget.Dependency(){

            public void revalidateDependency() {
                if (CasaNodeWidgetBinding.this.getPreferredLocation() == null || CasaNodeWidgetBinding.this.getBounds() == null || CasaNodeWidgetBinding.this.getParentWidget() == null) {
                    return;
                }
                Rectangle rectangle = CasaNodeWidgetBinding.this.mNameWidget.getBounds();
                Rectangle rectangle2 = CasaNodeWidgetBinding.this.getBounds();
                int n = (rectangle2.width - rectangle.width) / 2;
                Point point = CasaNodeWidgetBinding.this.getParentWidget().convertLocalToScene(CasaNodeWidgetBinding.this.getPreferredLocation());
                Point point2 = new Point(point.x + n, point.y + rectangle2.height + rectangle.height);
                point2.x = point2.x < 0 ? 0 : point2.x;
                CasaNodeWidgetBinding.this.mNameWidget.setPreferredLocation(point2);
            }
        };
        this.getDependenciesRegistry().registerDependency(dependency);
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.mNameWidget.removeFromParent();
    }

    public void initializeGlassLayer(LayerWidget layerWidget) {
        layerWidget.addChild((Widget)this.mNameWidget);
    }

    public void setLabelFont(Font font) {
        this.mNameWidget.setFont(font);
        this.mNameWidget.revalidate();
        this.revalidate();
    }

    public void setLabelColor(Color color) {
        this.mNameWidget.setForeground(color);
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (!objectState.isSelected() && objectState2.isSelected() || !objectState.isFocused() && objectState2.isFocused()) {
            this.regenerateHeaderBorder();
        } else if (objectState.isSelected() && !objectState2.isSelected() || objectState.isFocused() && !objectState2.isFocused()) {
            this.regenerateHeaderBorder();
        }
    }

    public void attachPinWidget(CasaPinWidget casaPinWidget) {
        this.mPinsHolderWidget.addChild((Widget)casaPinWidget);
    }

    protected Anchor createAnchorPin(Anchor anchor) {
        return anchor;
    }

    public Rectangle getEntireBounds() {
        Point point = this.getLocation();
        Rectangle rectangle = new Rectangle(Math.min(point.x, this.mNameWidget.getLocation().x), point.y, Math.max(this.getBounds().width, this.mNameWidget.getBounds().width), this.getBounds().height + this.mNameWidget.getBounds().height + 10);
        return rectangle;
    }

    public void setEndpointLabel(String string) {
        this.mNameWidget.setToolTipText(string);
        this.mNameWidget.setLabel(string);
        if (this.getBounds() != null) {
            this.mNameWidget.resolveBounds(null, null);
            this.readjustBounds();
        }
    }

    public void setNodeProperties(String string, String string2) {
        this.mVertTextBarText = string2;
        this.setEndpointLabel(string);
    }

    public void regenerateHeaderBorder() {
        BorderDefinition borderDefinition = null;
        if (this.getState().isSelected() || this.getState().isFocused()) {
            borderDefinition = BorderDefinition.createSelectedDefinition();
            this.mBodyWidget.setBorder(org.netbeans.api.visual.border.BorderFactory.createSwingBorder((Scene)this.getScene(), (Border)borderDefinition.getBorder()));
            this.mVerticalTextImageWidget.setBorder(org.netbeans.api.visual.border.BorderFactory.createSwingBorder((Scene)this.getScene(), (Border)BorderFactory.createMatteBorder(0, 0, 0, 1, borderDefinition.getBorderColor())));
        } else {
            borderDefinition = BorderDefinition.createDefaultDefinition();
            this.mBodyWidget.setBorder(org.netbeans.api.visual.border.BorderFactory.createSwingBorder((Scene)this.getScene(), (Border)borderDefinition.getBorder()));
            this.mVerticalTextImageWidget.setBorder(org.netbeans.api.visual.border.BorderFactory.createSwingBorder((Scene)this.getScene(), (Border)BorderFactory.createMatteBorder(0, 0, 0, 1, borderDefinition.getBorderColor())));
        }
    }

    public void regenerateVerticalTextBarImage() {
        String string = this.mVertTextBarText;
        if (this.mVertTextBarText == null) {
            string = "";
        } else if (this.mVertTextBarText.length() > 6) {
            string = string.substring(0, 6) + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ELLIPSIS");
        }
        Graphics2D graphics2D = this.getScene().getGraphics();
        graphics2D.setFont(CasaFactory.getCasaCustomizer().getFONT_BC_HEADER());
        FontMetrics fontMetrics = graphics2D.getFontMetrics(CasaFactory.getCasaCustomizer().getFONT_BC_HEADER());
        int n = fontMetrics.stringWidth(string);
        int n2 = n < 40 ? 40 : n;
        BufferedImage bufferedImage = new BufferedImage(20, n2 += 8, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setColor(new Color(255, 255, 255, 0));
        graphics2D2.fill(new Rectangle(0, 0, 20, n2));
        graphics2D2.setFont(CasaFactory.getCasaCustomizer().getFONT_BC_HEADER());
        graphics2D2.setPaint(CasaFactory.getCasaCustomizer().getCOLOR_BC_TITLE());
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n4 = (n2 - n) / 2;
        graphics2D2.translate(n3, n4 + n);
        graphics2D2.rotate(-Math.toRadians(90.0));
        graphics2D2.drawString(string, 0, -fontMetrics.getDescent());
        graphics2D2.rotate(Math.toRadians(90.0));
        graphics2D2.translate(-n3, -(n4 + n));
        graphics2D2.dispose();
        this.mVerticalTextImageWidget.setImage((Image)bufferedImage);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.mBadges.setBadge(CasaBindingBadges.Badge.IS_EDITABLE, bl);
    }

    public void setWSPolicyAttached(boolean bl) {
        super.setWSPolicyAttached(bl);
        this.mBadges.setBadge(CasaBindingBadges.Badge.WS_POLICY, bl);
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
        this.mBodyWidget.setBackground((Paint)CasaFactory.getCasaCustomizer().getCOLOR_BC_BACKGROUND());
        this.mContainerWidget.setBackground((Paint)CasaFactory.getCasaCustomizer().getCOLOR_BC_BACKGROUND());
    }

    public void setTitleBackgroundColor(Color color) {
        this.mHeaderHolder.setBackground((Paint)color);
        this.mHeaderHolder.repaint();
    }

    public CasaBindingBadges getBadges() {
        return this.mBadges;
    }

    public void updatePinImage() {
        for (Widget widget : this.mPinsHolderWidget.getChildren()) {
            if (!(widget instanceof CasaPinWidget)) continue;
            ((CasaPinWidget)widget).updatePinImage();
        }
    }

    private static class BorderDefinition {
        private Border mBorder;
        private Color mBorderColor;

        private BorderDefinition(Color color) {
            this.mBorderColor = color;
            this.mBorder = BorderFactory.createMatteBorder(2, 2, 2, 0, color);
        }

        public Border getBorder() {
            return this.mBorder;
        }

        public Color getBorderColor() {
            return this.mBorderColor;
        }

        public static BorderDefinition createDefaultDefinition() {
            return new BorderDefinition(CasaFactory.getCasaCustomizer().getCOLOR_BC_BORDER());
        }

        public static BorderDefinition createSelectedDefinition() {
            return new BorderDefinition(CasaFactory.getCasaCustomizer().getCOLOR_SELECTION());
        }
    }

    private static class BindingPinsLayout
    implements Layout {
        private BindingPinsLayout() {
        }

        public void layout(Widget widget) {
            CasaPinWidgetBindingConsumes casaPinWidgetBindingConsumes = null;
            CasaPinWidgetBindingProvides casaPinWidgetBindingProvides = null;
            for (Widget widget2 : widget.getChildren()) {
                if (widget2 instanceof CasaPinWidgetBindingConsumes) {
                    casaPinWidgetBindingConsumes = (CasaPinWidgetBindingConsumes)widget2;
                    continue;
                }
                if (!(widget2 instanceof CasaPinWidgetBindingProvides)) continue;
                casaPinWidgetBindingProvides = (CasaPinWidgetBindingProvides)widget2;
            }
            if (casaPinWidgetBindingConsumes != null) {
                casaPinWidgetBindingConsumes.resolveBounds(new Point(4, 4), null);
            }
            if (casaPinWidgetBindingProvides != null) {
                casaPinWidgetBindingProvides.resolveBounds(new Point(4, 26), null);
            }
        }

        public boolean requiresJustification(Widget widget) {
            return false;
        }

        public void justify(Widget widget) {
        }
    }
}

