/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;

public class CasaBindingBadges {
    private static final String SOAP_BINDING = "soap";
    private Widget mContainerWidget;
    private Map<Badge, ImageWidget> mBadgeWidgets = new HashMap<Badge, ImageWidget>();

    public CasaBindingBadges(Scene scene, String string) {
        this.mContainerWidget = new Widget(scene);
        this.mContainerWidget.setOpaque(false);
        this.mContainerWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)1));
        Widget widget = new Widget(scene);
        widget.setPreferredBounds(new Rectangle(16, 0));
        this.mContainerWidget.addChild(widget);
        for (Badge badge : Badge.values()) {
            if (!string.equalsIgnoreCase(SOAP_BINDING) && badge == Badge.WS_POLICY) continue;
            ImageWidget imageWidget = new ImageWidget(scene);
            this.mBadgeWidgets.put(badge, imageWidget);
            this.mContainerWidget.addChild((Widget)imageWidget);
        }
    }

    public void setBadge(Badge badge, boolean bl) {
        this.mBadgeWidgets.get((Object)badge).setImage(bl ? badge.getImage() : null);
    }

    public void setBadgePressed(Badge badge, boolean bl) {
        this.mBadgeWidgets.get((Object)badge).setPaintAsDisabled(bl);
    }

    public Rectangle getBadgeBoundsForParent(Badge badge, Widget widget) {
        Widget widget2 = (Widget)this.mBadgeWidgets.get((Object)badge);
        if (widget2 == null) {
            return null;
        }
        Point point = widget2.getLocation();
        for (Widget widget3 = widget2.getParentWidget(); widget3 != null && widget3 != widget; widget3 = widget3.getParentWidget()) {
            point.x += widget3.getLocation().x;
            point.y += widget3.getLocation().y;
        }
        return new Rectangle(point, widget2.getBounds().getSize());
    }

    public Widget getContainerWidget() {
        return this.mContainerWidget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Badge {
        IS_EDITABLE(RegionUtilities.IMAGE_EDIT_16_ICON),
        WS_POLICY(RegionUtilities.IMAGE_WS_POLICY_16_ICON);

        private Image mImage;

        private Badge(Image image) {
            this.mImage = image;
        }

        public Image getImage() {
            return this.mImage;
        }
    }
}

