/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetBinding;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;

public class CasaDesignModelListener
implements PropertyChangeListener {
    private CasaDataObject mDataObject;
    private CasaModelGraphScene mScene;

    public CasaDesignModelListener(CasaDataObject casaDataObject, CasaModelGraphScene casaModelGraphScene) {
        this.mDataObject = casaDataObject;
        this.mScene = casaModelGraphScene;
        this.mScene.getModel().addPropertyChangeListener(this);
    }

    public void cleanup() {
        this.mScene.getModel().removePropertyChangeListener(this);
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CasaDesignModelListener.this.propertyUpdate(propertyChangeEvent);
            }
        });
    }

    private void propertyUpdate(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("model_property_reload")) {
            this.reloadGraph();
        } else if (string.equals("model_property_connection_removed")) {
            this.removeConnection((CasaConnection)object);
        } else if (string.equals("model_property_connection_added")) {
            this.addConnection((CasaConnection)object);
        } else if (string.equals("model_property_casa_port_added")) {
            this.addCasaPort((CasaPort)object);
        } else if (string.equals("model_property_casa_port_removed")) {
            this.removeCasaPort((CasaPort)object);
        } else if (string.equals("model_property_casa_port_refresh")) {
            this.refreshCasaPort((CasaPort)object);
        } else if (string.equals("model_property_endpoint_removed")) {
            this.removeEndpoint((CasaEndpointRef)object);
        } else if (string.equals("model_property_endpoint_added")) {
            this.addEndpoint((CasaEndpointRef)object);
        } else if (string.equals("model_property_service_unit_added")) {
            this.addServiceUnit((CasaServiceEngineServiceUnit)object);
        } else if (string.equals("model_property_service_unit_removed")) {
            this.removeServiceUnit((CasaServiceEngineServiceUnit)object);
        } else if (string.equals("model_property_endpoint_renamed")) {
            this.renameEndpoint((CasaComponent)object);
        } else if (string.equals("model_property_endpoint_service_qname_changed")) {
            this.renameEndpointTooltip((CasaComponent)object);
        } else if (!string.equals("model_property_endpoint_interface_qname_changed") && string.equals("model_property_service_unit_renamed")) {
            this.renameServiceUnit((CasaServiceEngineServiceUnit)object);
        }
    }

    private void reloadGraph() {
        this.mScene.getModel().removePropertyChangeListener(this);
        CasaModelGraphUtilities.renderModel(this.mScene.getModel(), this.mScene);
        this.mScene.getModel().addPropertyChangeListener(this);
    }

    private void removeConnection(CasaConnection casaConnection) {
        if (this.mScene.findWidget(casaConnection) != null) {
            this.mScene.removeEdge(casaConnection);
            this.mScene.updateEdgeRouting(null);
            this.mScene.validate();
        }
    }

    private void addConnection(CasaConnection casaConnection) {
        CasaWrapperModel casaWrapperModel = this.mScene.getModel();
        CasaConsumes casaConsumes = (CasaConsumes)casaWrapperModel.getCasaEndpointRef(casaConnection, true);
        CasaProvides casaProvides = (CasaProvides)casaWrapperModel.getCasaEndpointRef(casaConnection, false);
        CasaModelGraphUtilities.createEdge(casaConnection, casaConsumes, casaProvides, this.mScene, true);
        this.mScene.updateSelectionAndRequestFocus(casaConnection);
    }

    private void addCasaPort(CasaPort casaPort) {
        Widget widget = CasaModelGraphUtilities.createNode(casaPort, this.mScene.getModel(), this.mScene, casaPort.getX(), casaPort.getY());
        this.mScene.updateSelectionAndRequestFocus(casaPort);
        this.mScene.progressiveRegionLayout(this.mScene.getBindingRegion(), true);
        CasaModelGraphUtilities.ensureVisibity(widget);
    }

    private void removeCasaPort(CasaPort casaPort) {
        this.mScene.removeNode(casaPort);
        this.mScene.validate();
    }

    private void refreshCasaPort(CasaPort casaPort) {
        this.mScene.refreshNode(casaPort);
        this.mScene.validate();
    }

    private void addServiceUnit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        Widget widget = CasaModelGraphUtilities.createNode(casaServiceEngineServiceUnit, this.mScene.getModel(), this.mScene, casaServiceEngineServiceUnit.getX(), casaServiceEngineServiceUnit.getY());
        this.mScene.updateSelectionAndRequestFocus(casaServiceEngineServiceUnit);
        this.mScene.progressiveRegionLayout(casaServiceEngineServiceUnit.isInternal() ? this.mScene.getEngineRegion() : this.mScene.getExternalRegion(), true);
        CasaModelGraphUtilities.ensureVisibity(widget);
    }

    private void removeServiceUnit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        this.mScene.removeNode(casaServiceEngineServiceUnit);
        this.mScene.validate();
    }

    private void removeEndpoint(CasaEndpointRef casaEndpointRef) {
        CasaPinWidget casaPinWidget = (CasaPinWidget)this.mScene.findWidget(casaEndpointRef);
        if (casaPinWidget != null) {
            CasaNodeWidget casaNodeWidget = CasaModelGraphUtilities.findNodeWidget(casaPinWidget);
            this.mScene.removePin(casaEndpointRef);
            if (casaNodeWidget instanceof CasaNodeWidgetEngine) {
                ((CasaNodeWidgetEngine)casaNodeWidget).readjustBounds();
            } else {
                this.mScene.validate();
            }
        }
    }

    private void addEndpoint(CasaEndpointRef casaEndpointRef) {
        CasaWrapperModel casaWrapperModel = this.mScene.getModel();
        CasaPort casaPort = casaWrapperModel.getCasaPort(casaEndpointRef);
        CasaRegionWidget casaRegionWidget = null;
        if (casaPort != null) {
            CasaModelGraphUtilities.createPin(casaPort, casaEndpointRef, casaEndpointRef.getEndpointName(), this.mScene, true);
            casaRegionWidget = this.mScene.getBindingRegion();
        } else {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = casaWrapperModel.getCasaEngineServiceUnit(casaEndpointRef);
            CasaModelGraphUtilities.createPin(casaServiceEngineServiceUnit, casaEndpointRef, casaEndpointRef.getEndpointName(), this.mScene, true);
            CasaModelGraphUtilities.ensureVisibity(this.mScene.findWidget(casaServiceEngineServiceUnit));
            casaRegionWidget = casaServiceEngineServiceUnit.isInternal() ? this.mScene.getEngineRegion() : this.mScene.getExternalRegion();
        }
        this.mScene.updateSelectionAndRequestFocus(casaEndpointRef);
        this.mScene.progressiveRegionLayout(casaRegionWidget, true);
    }

    private void renameEndpoint(CasaComponent casaComponent) {
        Widget widget = this.mScene.findWidget(casaComponent);
        if (widget instanceof CasaPinWidget) {
            CasaPinWidget casaPinWidget = (CasaPinWidget)widget;
            CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaComponent;
            casaPinWidget.setProperties(casaEndpointRef.getDisplayName());
            casaPinWidget.setToolTipText(CasaModelGraphUtilities.getToolTipName((CasaComponent)casaEndpointRef.getParent(), casaEndpointRef, this.mScene.getModel()));
        } else if (widget instanceof CasaNodeWidgetBinding) {
            CasaNodeWidgetBinding casaNodeWidgetBinding = (CasaNodeWidgetBinding)widget;
            CasaPort casaPort = (CasaPort)casaComponent;
            CasaWrapperModel casaWrapperModel = this.mScene.getModel();
            casaNodeWidgetBinding.setEndpointLabel(casaPort.getEndpointName());
        }
    }

    private void renameEndpointTooltip(CasaComponent casaComponent) {
        Widget widget = this.mScene.findWidget(casaComponent);
        if (widget instanceof CasaPinWidget) {
            CasaPinWidget casaPinWidget = (CasaPinWidget)widget;
            CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaComponent;
            casaPinWidget.setToolTipText(CasaModelGraphUtilities.getToolTipName((CasaComponent)casaEndpointRef.getParent(), casaEndpointRef, this.mScene.getModel()));
        }
    }

    private void renameServiceUnit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        Widget widget = this.mScene.findWidget(casaServiceEngineServiceUnit);
        if (widget != null) {
            CasaNodeWidget casaNodeWidget = (CasaNodeWidget)widget;
            CasaModelGraphUtilities.updateNodeProperties(this.mScene.getModel(), casaServiceEngineServiceUnit, casaNodeWidget);
        }
    }
}

