/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.RefactoringModule;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient CsmObject origObject;
    private transient CsmObject refObject;
    private final transient ChangeListener parent;
    private String name;
    private Scope defaultScope;
    private boolean initialized = false;
    private CsmClass methodDeclaringSuperClass = null;
    private CsmClass methodDeclaringClass = null;
    private CsmMethod baseVirtualMethod = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JComboBox scope;
    private JLabel scopeLabel;
    private JPanel scopePanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String string, CsmObject csmObject, ChangeListener changeListener) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.origObject = csmObject;
        this.parent = changeListener;
        this.name = string;
        this.defaultScope = Scope.CURRENT;
        this.initComponents();
    }

    public Scope getScope() {
        if (this.scope.getItemCount() == 0) {
            return this.defaultScope;
        }
        if (this.scope.getSelectedIndex() == 1) {
            return Scope.CURRENT;
        }
        return Scope.ALL;
    }

    String getBaseMethodDescription() {
        if (this.baseVirtualMethod != null) {
            CsmVisibility csmVisibility = this.baseVirtualMethod.getVisibility();
            String string = ((Object)this.baseVirtualMethod.getSignature()).toString();
            String string2 = ((Object)this.methodDeclaringSuperClass.getName()).toString();
            return this.getString("DSC_MethodUsages", string, string2);
        }
        return this.name;
    }

    CsmClass getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    public void initialize() {
        Object object;
        CharSequence charSequence;
        JLabel jLabel;
        JLabel jLabel2;
        Object object2;
        Object object3;
        if (this.initialized) {
            return;
        }
        this.initFields();
        if (!CsmKindUtilities.isLocalVariable((CsmObject)this.refObject)) {
            object3 = CsmRefactoringUtils.getContextProject(this.origObject);
            if (object3 != null) {
                object2 = ProjectUtils.getInformation((Project)object3);
                jLabel2 = new JLabel(object2.getDisplayName(), object2.getIcon(), 2);
                jLabel = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AllProjects"), object2.getIcon(), 2);
            } else {
                this.defaultScope = Scope.ALL;
                jLabel2 = null;
                jLabel = null;
            }
        } else {
            this.defaultScope = Scope.CURRENT;
            jLabel2 = null;
            jLabel = null;
        }
        object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (CsmKindUtilities.isMethod((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmMethod)this.refObject).getSignature()).toString();
            this.methodDeclaringClass = ((CsmMember)this.refObject).getContainingClass();
            object = ((Object)this.methodDeclaringClass.getName()).toString();
            object3 = this.getString("DSC_MethodUsages", (String)charSequence, (String)object);
            CsmVirtualInfoQuery csmVirtualInfoQuery = CsmVirtualInfoQuery.getDefault();
            if (csmVirtualInfoQuery.isVirtual((CsmMethod)this.refObject)) {
                Collection collection = csmVirtualInfoQuery.getBaseDeclaration((CsmMethod)this.refObject);
                CsmMethod csmMethod = this.baseVirtualMethod = collection.isEmpty() ? null : (CsmMethod)collection.iterator().next();
                assert (this.baseVirtualMethod != null) : "virtual method must have start virtual declaration";
                this.methodDeclaringSuperClass = this.baseVirtualMethod.getContainingClass();
                if (!this.refObject.equals(this.baseVirtualMethod)) {
                    object2 = this.getString("LBL_UsagesOfBaseClass", ((Object)this.methodDeclaringSuperClass.getName()).toString());
                }
                bl = true;
            }
        } else if (CsmKindUtilities.isFunction((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmFunction)this.refObject).getSignature()).toString();
            charSequence = CsmDisplayUtilities.htmlize((String)charSequence);
            object3 = this.getString("DSC_FunctionUsages", (String)charSequence);
        } else if (CsmKindUtilities.isClass((CsmObject)this.refObject)) {
            charSequence = ((CsmDeclaration)this.refObject).getKind();
            object = charSequence == CsmDeclaration.Kind.STRUCT ? "DSC_StructUsages" : (charSequence == CsmDeclaration.Kind.UNION ? "DSC_UnionUsages" : "DSC_ClassUsages");
            object3 = this.getString((String)object, ((Object)((CsmClassifier)this.refObject).getQualifiedName()).toString());
            bl2 = true;
        } else if (CsmKindUtilities.isTypedef((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmTypedef)this.refObject).getQualifiedName()).toString();
            object3 = this.getString("DSC_TypedefUsages", (String)charSequence);
        } else if (CsmKindUtilities.isEnum((CsmObject)this.refObject)) {
            object3 = this.getString("DSC_EnumUsages", ((Object)((CsmEnum)this.refObject).getQualifiedName()).toString());
        } else if (CsmKindUtilities.isEnumerator((CsmObject)this.refObject)) {
            charSequence = (CsmEnumerator)this.refObject;
            object3 = this.getString("DSC_EnumeratorUsages", ((Object)charSequence.getName()).toString(), ((Object)charSequence.getEnumeration().getName()).toString());
        } else if (CsmKindUtilities.isField((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmField)this.refObject).getName()).toString();
            object = ((Object)((CsmField)this.refObject).getContainingClass().getName()).toString();
            object3 = this.getString("DSC_FieldUsages", (String)charSequence, (String)object);
        } else if (CsmKindUtilities.isVariable((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmVariable)this.refObject).getName()).toString();
            object3 = this.getString("DSC_VariableUsages", (String)charSequence);
        } else if (CsmKindUtilities.isFile((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmFile)this.refObject).getName()).toString();
            object3 = this.getString("DSC_FileUsages", (String)charSequence);
        } else if (CsmKindUtilities.isNamespace((CsmObject)this.refObject)) {
            charSequence = ((Object)((CsmNamespace)this.refObject).getQualifiedName()).toString();
            object3 = this.getString("DSC_NamespaceUsages", (String)charSequence);
        } else if (CsmKindUtilities.isMacro((CsmObject)this.refObject)) {
            charSequence = new StringBuilder(((CsmMacro)this.refObject).getName());
            if (((CsmMacro)this.refObject).getParameters() != null) {
                ((StringBuilder)charSequence).append("(");
                object = ((CsmMacro)this.refObject).getParameters().iterator();
                if (object.hasNext()) {
                    ((StringBuilder)charSequence).append((CharSequence)object.next());
                    while (object.hasNext()) {
                        ((StringBuilder)charSequence).append(", ");
                        ((StringBuilder)charSequence).append((CharSequence)object.next());
                    }
                }
                ((StringBuilder)charSequence).append(")");
            }
            object3 = this.getString("DSC_MacroUsages", ((StringBuilder)charSequence).toString());
        } else {
            object3 = CsmKindUtilities.isQualified((CsmObject)this.refObject) ? ((Object)((CsmQualifiedNamedElement)this.refObject).getQualifiedName()).toString() : this.name;
        }
        this.name = object3;
        charSequence = object2;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        SwingUtilities.invokeLater(new Runnable((String)object3, bl3, (String)charSequence, bl4, jLabel2, jLabel){
            final /* synthetic */ String val$labelText;
            final /* synthetic */ boolean val$showMethodPanel;
            final /* synthetic */ String val$isBaseClassText;
            final /* synthetic */ boolean val$showClassPanel;
            final /* synthetic */ JLabel val$currentProject;
            final /* synthetic */ JLabel val$allProjects;
            {
                this.val$labelText = string;
                this.val$showMethodPanel = bl;
                this.val$isBaseClassText = string2;
                this.val$showClassPanel = bl2;
                this.val$currentProject = jLabel;
                this.val$allProjects = jLabel2;
            }

            public void run() {
                WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                WhereUsedPanel.this.label.setText(this.val$labelText);
                if (this.val$showMethodPanel) {
                    WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                    WhereUsedPanel.this.methodsPanel.setVisible(true);
                    if (this.val$isBaseClassText != null) {
                        Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)this.val$isBaseClassText);
                        WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                        WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                    } else {
                        WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                        WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                    }
                } else if (this.val$showClassPanel) {
                    WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                    WhereUsedPanel.this.classesPanel.setVisible(true);
                }
                if (this.val$currentProject != null) {
                    WhereUsedPanel.this.scope.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.val$allProjects, this.val$currentProject}));
                    int n = RefactoringModule.getOption("whereUsed.scope", 0);
                    WhereUsedPanel.this.scope.setSelectedIndex(n);
                    WhereUsedPanel.this.scope.setRenderer(new JLabelRenderer());
                } else {
                    WhereUsedPanel.this.scopePanel.setVisible(false);
                }
                WhereUsedPanel.this.validate();
            }
        });
        this.initialized = true;
    }

    CsmMethod getBaseMethod() {
        return this.baseVirtualMethod;
    }

    CsmObject getReferencedObject() {
        return this.refObject;
    }

    String getDescription() {
        return this.name;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.scopePanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scope = new JComboBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_overridersActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_overriders"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_usagesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.commentsPanel.setLayout(new BorderLayout());
        this.commentsPanel.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setEnabled(false);
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.commentsPanel.add((Component)this.searchInComments, "Center");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.commentsPanel, "North");
        this.scopeLabel.setDisplayedMnemonic(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope_MNEM").charAt(0));
        this.scopeLabel.setLabelFor(this.scope);
        this.scopeLabel.setText(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        this.scope.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.scopeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.scopePanel);
        this.scopePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.scopeLabel).addPreferredGap(0).add((Component)this.scope, 0, 283, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.scopeLabel).add((Component)this.scope, -2, 20, Short.MAX_VALUE));
        this.add((Component)this.scopePanel, "Last");
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", bl);
    }

    private void m_isBaseClassActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void scopeActionPerformed(ActionEvent actionEvent) {
        RefactoringModule.setOption("whereUsed.scope", this.scope.getSelectedIndex());
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 30, dimension.height + 80);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    boolean isVirtualMethod() {
        return this.baseVirtualMethod != null;
    }

    boolean isClass() {
        return CsmKindUtilities.isClass((CsmObject)this.refObject);
    }

    private void initFields() {
        this.refObject = this.getReferencedElement(this.origObject);
        this.name = this.getSearchElementName(this.refObject, this.name);
    }

    private CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return this.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    private String getSearchElementName(CsmObject csmObject, String string) {
        String string2;
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
            string2 = ((Object)((CsmNamedElement)csmObject).getName()).toString();
        } else {
            System.err.println("Unhandled name for object " + csmObject);
            string2 = string;
        }
        return string2;
    }

    private CsmMethod getOriginalVirtualMethod(CsmMethod csmMethod) {
        return csmMethod;
    }

    private String getString(String string) {
        return NbBundle.getBundle(WhereUsedPanel.class).getString(string);
    }

    private String getString(String string, String string2) {
        return NbBundle.getMessage(WhereUsedPanel.class, (String)string, (Object)string2);
    }

    private String getString(String string, String string2, String string3) {
        return NbBundle.getMessage(WhereUsedPanel.class, (String)string, (Object)string2, (Object)string3);
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                this.setText(((JLabel)object).getText());
                this.setIcon(((JLabel)object).getIcon());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        ALL,
        CURRENT;

    }
}

