/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.elements.CsmRefactoringElementImpl;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmWhereUsedQueryPlugin
extends CsmRefactoringPlugin {
    private final WhereUsedQuery refactoring;
    private final CsmObject startReferenceObject;

    public CsmWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
        this.startReferenceObject = (CsmObject)whereUsedQuery.getRefactoringSource().lookup(CsmObject.class);
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        CsmObject csmObject;
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        CsmObject csmObject2 = csmObject = csmUID == null ? null : (CsmObject)csmUID.getObject();
        if (csmObject == null) {
            return null;
        }
        Collection<RefactoringElementImplementation> collection = this.doPrepareElements(csmObject);
        if (collection != null) {
            refactoringElementsBag.addAll((AbstractRefactoring)this.refactoring, collection);
        }
        this.fireProgressListenerStop();
        return null;
    }

    Collection<RefactoringElementImplementation> doPrepareElements(CsmObject csmObject) {
        Collection<RefactoringElementImplementation> collection = null;
        if (csmObject == null) {
            return null;
        }
        if (this.isFindUsages()) {
            if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
                this.fireProgressListenerStart(1, 2);
                collection = this.processIncludeQuery((CsmFile)csmObject);
            } else {
                Collection<CsmObject> collection2 = this.getObjectsForFindUsages(csmObject);
                CsmFile csmFile = this.getCsmFile(this.startReferenceObject);
                HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
                for (CsmObject csmObject2 : collection2) {
                    hashSet.addAll(this.getRelevantFiles(csmFile, csmObject2, (AbstractRefactoring)this.refactoring));
                }
                this.fireProgressListenerStart(1, hashSet.size() + 2);
                collection = this.processObjectUsagesQuery(collection2, hashSet);
            }
        } else if (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) {
            assert (CsmKindUtilities.isClass((CsmObject)csmObject)) : "must be class";
            this.fireProgressListenerStart(1, 2);
            collection = this.processSubclassesQuery((CsmClass)csmObject);
        } else if (this.isFindOverridingMethods()) {
            assert (CsmKindUtilities.isMethod((CsmObject)csmObject)) : "must be method";
            this.fireProgressListenerStart(1, 2);
            collection = this.processOverridenMethodsQuery((CsmMethod)csmObject);
        }
        this.fireProgressListenerStep();
        return collection;
    }

    @Override
    public Problem checkParameters() {
        return super.checkParameters();
    }

    @Override
    public Problem preCheck() {
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        Problem problem = new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_InvalidObjectNothingToFind"));
        if (csmUID == null) {
            CsmFile csmFile = this.getCsmFile(this.startReferenceObject);
            if (csmFile == null || !csmFile.isValid()) {
                return problem;
            }
            return super.preCheck();
        }
        CsmObject csmObject = (CsmObject)csmUID.getObject();
        if (csmObject == null) {
            return problem;
        }
        if (CsmKindUtilities.isValidable((CsmObject)csmObject) && !((CsmValidable)csmObject).isValid()) {
            return problem;
        }
        return super.preCheck();
    }

    @Override
    public Problem fastCheckParameters() {
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        if (csmUID != null && CsmKindUtilities.isMethod((CsmObject)((CsmObject)csmUID.getObject()))) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return super.fastCheckParameters();
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2) {
        if (!bl2 && !bl) {
            return new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private Collection<CsmObject> getObjectsForFindUsages(CsmObject csmObject) {
        LinkedHashSet<CsmObject> linkedHashSet = new LinkedHashSet<CsmObject>();
        if (this.isFindUsages()) {
            if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                CsmMethod csmMethod = (CsmMethod)csmObject;
                if (this.isFindOverridingMethods() && CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod)) {
                    linkedHashSet.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, this.isSearchFromBaseClass()));
                }
            }
            linkedHashSet.add(csmObject);
        }
        return linkedHashSet;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private Collection<RefactoringElementImplementation> processObjectUsagesQuery(Collection<CsmObject> collection, Collection<CsmFile> collection2) {
        assert (this.isFindUsages()) : "must be find usages mode";
        CsmReferenceRepository csmReferenceRepository = CsmReferenceRepository.getDefault();
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Set set = CsmReferenceKind.ALL;
        CsmObject[] csmObjectArray = collection.toArray(new CsmObject[collection.size()]);
        for (CsmFile csmFile : collection2) {
            if (this.cancelRequest) break;
            Collection collection3 = csmReferenceRepository.getReferences(csmObjectArray, csmFile, set);
            for (CsmReference csmReference : collection3) {
                linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, true));
            }
            this.fireProgressListenerStep();
        }
        return linkedHashSet;
    }

    private Collection<RefactoringElementImplementation> processOverridenMethodsQuery(CsmMethod csmMethod) {
        assert (this.isFindOverridingMethods()) : "must be search for overriden methods";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection collection = CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, this.isSearchFromBaseClass());
        collection.add(csmMethod);
        for (CsmMethod csmMethod2 : collection) {
            CsmFunctionDefinition csmFunctionDefinition;
            CsmReference csmReference = CsmReferenceSupport.createObjectReference((CsmOffsetable)csmMethod2);
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmMethod2) || (csmFunctionDefinition = csmMethod2.getDefinition()) == null) continue;
            CsmReference csmReference2 = CsmReferenceSupport.createObjectReference((CsmOffsetable)csmFunctionDefinition);
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference2, false));
        }
        return linkedHashSet;
    }

    private Collection<RefactoringElementImplementation> processIncludeQuery(CsmFile csmFile) {
        assert (this.isFindUsages()) : "must be find usages";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection collection = CsmIncludeHierarchyResolver.getDefault().getIncludes(csmFile);
        for (CsmReference csmReference : collection) {
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
        }
        return linkedHashSet;
    }

    private Collection<RefactoringElementImplementation> processSubclassesQuery(CsmClass csmClass) {
        assert (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) : "must be search of subclasses";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        boolean bl = this.isFindDirectSubclassesOnly();
        Collection collection = CsmTypeHierarchyResolver.getDefault().getSubTypes(csmClass, bl);
        for (CsmReference csmReference : collection) {
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
        }
        return linkedHashSet;
    }
}

