/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.refactoring.elements.DiffElement;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.support.RefactoringCommit;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    private Phase whatRun = Phase.DEFAULT;
    private Problem problem;
    protected volatile boolean cancelRequest = false;

    public void cancel() {
    }

    public Problem preCheck() {
        return this.run(Phase.PRECHECK);
    }

    public Problem checkParameters() {
        return this.run(Phase.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.run(Phase.FASTCHECKPARAMETERS);
    }

    private Problem run(Phase phase) {
        this.whatRun = phase;
        this.problem = null;
        return this.problem;
    }

    public void cancelRequest() {
        this.cancelRequest = true;
    }

    protected ModificationResult processFiles(Collection<CsmFile> collection) {
        return null;
    }

    private Collection<ModificationResult> processFiles(Iterable<? extends List<CsmFile>> iterable) {
        LinkedList<ModificationResult> linkedList = new LinkedList<ModificationResult>();
        for (List<CsmFile> list : iterable) {
            if (this.cancelRequest) {
                return Collections.emptyList();
            }
            ModificationResult modificationResult = this.processFiles((Collection<CsmFile>)list);
            if (modificationResult == null) continue;
            linkedList.add(modificationResult);
        }
        return linkedList;
    }

    protected final void createAndAddElements(Collection<CsmFile> collection, RefactoringElementsBag refactoringElementsBag, AbstractRefactoring abstractRefactoring) {
        Iterable<? extends List<CsmFile>> iterable = this.groupByRoot(collection);
        Collection<ModificationResult> collection2 = this.processFiles(iterable);
        refactoringElementsBag.registerTransaction((Transaction)new RefactoringCommit(collection2));
        for (ModificationResult modificationResult : collection2) {
            for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                    refactoringElementsBag.add(abstractRefactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                }
            }
        }
    }

    protected static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    private Iterable<? extends List<CsmFile>> groupByRoot(Iterable<? extends CsmFile> iterable) {
        HashMap<CsmProject, LinkedList<CsmFile>> hashMap = new HashMap<CsmProject, LinkedList<CsmFile>>();
        for (CsmFile csmFile : iterable) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject == null) continue;
            LinkedList<CsmFile> linkedList = (LinkedList<CsmFile>)hashMap.get(csmProject);
            if (linkedList == null) {
                linkedList = new LinkedList<CsmFile>();
                hashMap.put(csmProject, linkedList);
            }
            linkedList.add(csmFile);
        }
        return hashMap.values();
    }

    protected final CsmFile getCsmFile(CsmObject csmObject) {
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return (CsmFile)csmObject;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    protected Collection<CsmFile> getRelevantFiles(CsmFile csmFile, CsmObject csmObject, AbstractRefactoring abstractRefactoring) {
        CsmProject[] csmProjectArray;
        CsmObject csmObject2 = csmObject == null ? null : CsmRefactoringUtils.getEnclosingElement(csmObject);
        CsmFile csmFile2 = null;
        if (csmObject2 == null) {
            return Collections.emptyList();
        }
        if (CsmKindUtilities.isFunction((CsmObject)csmObject2)) {
            csmFile2 = ((CsmOffsetable)csmObject2).getContainingFile();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmObject2)) {
            csmProjectArray = ((CsmNamespaceDefinition)csmObject2).getNamespace();
            if (csmProjectArray != null && csmProjectArray.getName().length() == 0 && this.isDeclarationInLeafFile(csmObject2)) {
                csmFile2 = ((CsmNamespaceDefinition)csmObject2).getContainingFile();
            }
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject) && CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject)) && this.isDeclarationInLeafFile(csmObject)) {
            csmFile2 = ((CsmFunction)csmObject).getContainingFile();
        }
        if (csmFile.equals(csmFile2)) {
            return Collections.singleton(csmFile2);
        }
        csmProjectArray = (CsmProject[])abstractRefactoring.getContext().lookup(CsmProject[].class);
        CsmFile csmFile3 = this.getCsmFile(csmObject);
        if (csmProjectArray == null || csmProjectArray.length == 0 || csmFile3 == null) {
            CsmProject csmProject = csmFile.getProject();
            return csmProject.getAllFiles();
        }
        CsmProject csmProject = csmFile3.getProject();
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        for (CsmProject csmProject2 : csmProjectArray) {
            if (!csmProject2.equals(csmProject) && !csmProject2.getLibraries().contains(csmProject)) continue;
            hashSet.add(csmProject2);
        }
        HashSet hashSet2 = new HashSet();
        for (CsmProject csmProject3 : hashSet) {
            hashSet2.addAll(csmProject3.getAllFiles());
        }
        return hashSet2;
    }

    private boolean isDeclarationInLeafFile(CsmObject csmObject) {
        boolean bl = false;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmFile csmFile = ((CsmOffsetable)csmObject).getContainingFile();
            bl = CsmIncludeHierarchyResolver.getDefault().getFiles(csmFile).isEmpty();
        }
        return bl;
    }

    protected Problem isResovledElement(CsmObject csmObject) {
        if (csmObject == null) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        if (csmObject2 == null) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        if (CsmKindUtilities.isValidable((CsmObject)csmObject2) && !((CsmValidable)csmObject2).isValid()) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Phase {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE,
        DEFAULT;

    }
}

