/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.elements;

import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class CsmRefactoringElementImpl
extends SimpleRefactoringElementImplementation {
    private final CsmReference elem;
    private final PositionBounds bounds;
    private final FileObject fo;
    private final String displayText;
    private final Object enclosing;

    public CsmRefactoringElementImpl(PositionBounds positionBounds, CsmReference csmReference, FileObject fileObject, String string) {
        this.elem = csmReference;
        this.bounds = positionBounds;
        this.fo = fileObject;
        assert (string != null);
        this.displayText = string;
        ElementGrip elementGrip = ElementGripFactory.getDefault().putInComposite(fileObject, (CsmOffsetable)csmReference);
        if (elementGrip == null) {
            elementGrip = fileObject;
        }
        this.enclosing = elementGrip;
    }

    public String getText() {
        return ((Object)this.elem.getText()).toString();
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.elem, this.enclosing});
    }

    public FileObject getParentFile() {
        return this.fo;
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public void openInEditor() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null) {
            JumpList.addEntry((JTextComponent)jTextComponent, (int)jTextComponent.getSelectionStart());
        }
        super.openInEditor();
    }

    public static RefactoringElementImplementation create(CsmReference csmReference, boolean bl) {
        CsmFile csmFile = csmReference.getContainingFile();
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        PositionBounds positionBounds = CsmUtilities.createPositionBounds((CsmOffsetable)csmReference);
        String string = ((Object)CsmReferenceSupport.getContextLineHtml((CsmReference)csmReference, (boolean)bl)).toString();
        return new CsmRefactoringElementImpl(positionBounds, csmReference, fileObject, string);
    }
}

