/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.actions.SyncDocumentRegion;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenamePerformer2
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private int span;
    private AttributeSet attribs = null;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private boolean inSync;
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.red});

    private InstantRenamePerformer2(JTextComponent jTextComponent, Collection<CsmReference> collection, int n) throws BadLocationException {
        this.target = jTextComponent;
        this.doc = jTextComponent.getDocument();
        MutablePositionRegion mutablePositionRegion = null;
        ArrayList<MutablePositionRegion> arrayList = new ArrayList<MutablePositionRegion>();
        for (CsmReference csmReference : collection) {
            Position position;
            Position position2 = NbDocument.createPosition((Document)this.doc, (int)csmReference.getStartOffset(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion mutablePositionRegion2 = new MutablePositionRegion(position2, position = NbDocument.createPosition((Document)this.doc, (int)csmReference.getEndOffset(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(mutablePositionRegion2, n)) {
                mutablePositionRegion = mutablePositionRegion2;
                continue;
            }
            arrayList.add(mutablePositionRegion2);
        }
        if (mutablePositionRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        arrayList.add(0, mutablePositionRegion);
        this.region = new SyncDocumentRegion(this.doc, arrayList);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).addPostModificationDocumentListener((DocumentListener)this);
        }
        jTextComponent.addKeyListener(this);
        jTextComponent.putClientProperty(InstantRenamePerformer2.class, this);
        this.requestRepaint();
        jTextComponent.select(mutablePositionRegion.getStartOffset(), mutablePositionRegion.getEndOffset());
        this.span = this.region.getFirstRegionLength();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(InstantRenamePerformer2.class, (String)string);
    }

    public static void invokeInstantRename(JTextComponent jTextComponent) {
        try {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
            CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)dataObject, (boolean)false);
            if (csmFile == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer2.getString("no-instant-rename"));
                return;
            }
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(csmFile, n);
            if (csmReference == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer2.getString("no-instant-rename"));
                return;
            }
            if (InstantRenamePerformer2.allowInstantRename(csmReference)) {
                Collection<CsmReference> collection = InstantRenamePerformer2.computeChangePoints(csmReference);
                InstantRenamePerformer2.doInstantRename(collection, jTextComponent, n);
            } else {
                InstantRenamePerformer2.doFullRename(dataObject, jTextComponent);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static boolean allowInstantRename(CsmReference csmReference) {
        CsmReferenceResolver.Scope scope = CsmReferenceResolver.getDefault().fastCheckScope(csmReference);
        return scope == CsmReferenceResolver.Scope.LOCAL;
    }

    private static void doFullRename(DataObject dataObject, JTextComponent jTextComponent) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        Node node = dataObject.getNodeDelegate();
        if (node == null) {
            Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer2.getString("no-instant-rename"));
            return;
        }
        InstanceContent instanceContent = new InstanceContent();
        if (editorCookie != null) {
            instanceContent.add((Object)editorCookie);
        }
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    private static void doInstantRename(Collection<CsmReference> collection, JTextComponent jTextComponent, int n) throws BadLocationException {
        InstantRenamePerformer2.performInstantRename(jTextComponent, collection, n);
    }

    static Collection<CsmReference> computeChangePoints(CsmReference csmReference) {
        CsmObject csmObject = csmReference.getReferencedObject();
        if (csmObject == null) {
            return Collections.emptyList();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        Collection collection = CsmReferenceRepository.getDefault().getReferences(csmObject, csmFile, CsmReferenceKind.ALL);
        return collection;
    }

    public static void performInstantRename(JTextComponent jTextComponent, Collection<CsmReference> collection, int n) throws BadLocationException {
        new InstantRenamePerformer2(jTextComponent, collection, n);
    }

    private boolean isIn(MutablePositionRegion mutablePositionRegion, int n) {
        return mutablePositionRegion.getStartOffset() <= n && n <= mutablePositionRegion.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (documentEvent.getOffset() < this.region.getFirstRegionStartOffset() || documentEvent.getOffset() + documentEvent.getLength() > this.region.getFirstRegionEndOffset()) {
            this.release();
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.span = this.region.getFirstRegionLength();
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (documentEvent.getLength() == 1) {
            if (documentEvent.getOffset() < this.region.getFirstRegionStartOffset() || documentEvent.getOffset() > this.region.getFirstRegionEndOffset()) {
                this.release();
                return;
            }
            if (documentEvent.getOffset() == this.region.getFirstRegionStartOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                return;
            }
            if (documentEvent.getOffset() == this.region.getFirstRegionEndOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                this.release();
                return;
            }
        } else {
            int n = documentEvent.getLength() + this.region.getFirstRegionLength();
            if (this.span < n) {
                this.release();
                return;
            }
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.span = this.region.getFirstRegionLength();
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.release();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void release() {
        this.target.putClientProperty(InstantRenamePerformer2.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).removePostModificationDocumentListener((DocumentListener)this);
        }
        this.target.removeKeyListener(this);
        this.target = null;
        this.attribs = null;
        this.region = null;
        this.requestRepaint();
        this.doc = null;
    }

    private void requestRepaint() {
        if (this.region == null) {
            OffsetsBag offsetsBag = InstantRenamePerformer2.getHighlightsBag(this.doc);
            offsetsBag.clear();
        } else {
            Object object;
            if (this.attribs == null) {
                this.attribs = InstantRenamePerformer2.getSyncedTextBlocksHighlight();
                object = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                Color color = (Color)this.attribs.getAttribute(StyleConstants.Background);
                this.attribsLeft = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object});
                this.attribsRight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object});
                this.attribsMiddle = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object});
                this.attribsAll = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object});
            }
            object = new OffsetsBag(this.doc);
            int n = this.region.getFirstRegionStartOffset();
            int n2 = this.region.getFirstRegionEndOffset();
            int n3 = this.region.getFirstRegionLength();
            if (n3 == 1) {
                object.addHighlight(n, n2, this.attribsAll);
            } else if (n3 > 1) {
                object.addHighlight(n, n + 1, this.attribsLeft);
                object.addHighlight(n2 - 1, n2, this.attribsRight);
                if (n3 > 2) {
                    object.addHighlight(n + 1, n2 - 1, this.attribsMiddle);
                }
            }
            OffsetsBag offsetsBag = InstantRenamePerformer2.getHighlightsBag(this.doc);
            offsetsBag.setHighlights(object);
        }
    }

    private static AttributeSet getSyncedTextBlocksHighlight() {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings != null ? fontColorSettings.getFontColors("synchronized-text-blocks-ext") : null;
        return attributeSet == null ? defaultSyncedTextBlocksHighlight : attributeSet;
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(InstantRenamePerformer2.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(InstantRenamePerformer2.class, offsetsBag);
        }
        return offsetsBag;
    }
}

