/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.java.project.runner.ProjectRunnerImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ProjectRunnerImpl
implements ProjectRunnerImplementation {
    private static final Logger LOG = Logger.getLogger(ProjectRunnerImpl.class.getName());
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SNIPPETS_CACHE_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "executor-snippets";
    private static File cacheFolder;

    public boolean isSupported(String string, FileObject fileObject) {
        return ProjectRunnerImpl.locateScript(string) != null && ProjectRunnerImpl.checkRunSupported(fileObject);
    }

    public void execute(String string, Properties properties, FileObject fileObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        for (JavaPlatform javaPlatform2 : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!((Object)classPath2.entries()).equals(javaPlatform2.getBootstrapLibraries().entries())) continue;
            LOG.log(Level.FINE, "found platform={0}", javaPlatform2.getDisplayName());
            javaPlatform = javaPlatform2;
            break;
        }
        LOG.log(Level.FINE, "using platform={0}", javaPlatform.getDisplayName());
        LOG.log(Level.FINE, "execute classpath={0}", classPath);
        String string2 = classPath.toString(ClassPath.PathConversionMode.FAIL);
        Properties properties2 = (Properties)properties.clone();
        properties2.setProperty("classpath", string2);
        properties2.setProperty("classname", classPath3.getResourceName(fileObject, '.', false));
        if (properties2.get("work.dir") == null && project != null) {
            FileObject fileObject3 = project.getProjectDirectory();
            assert (fileObject3 != null);
            File file = FileUtil.toFile((FileObject)fileObject3);
            if (file != null) {
                properties2.setProperty("work.dir", file.getAbsolutePath());
            }
        }
        properties2.setProperty("platform.java", FileUtil.toFile((FileObject)javaPlatform.findTool("java")).getAbsolutePath());
        FileObject fileObject2 = ProjectRunnerImpl.buildScript(string);
        String string3 = project != null ? ProjectUtils.getInformation((Project)project).getDisplayName() : "";
        FakeAntProjectCookie fakeAntProjectCookie = new FakeAntProjectCookie(AntScriptUtils.antProjectCookieFor((FileObject)fileObject2), string3);
        AntTargetExecutor.Env env = new AntTargetExecutor.Env();
        Properties properties3 = env.getProperties();
        properties3.putAll((Map<?, ?>)properties2);
        env.setProperties(properties3);
        AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env).execute((AntProjectCookie)fakeAntProjectCookie, null);
    }

    private static boolean checkRunSupported(FileObject fileObject) {
        return true;
    }

    private static URL locateScript(String string) {
        return ProjectRunnerImpl.class.getResource("/org/netbeans/modules/java/source/ant/resources/" + string + "-snippet.xml");
    }

    private static FileObject buildScript(String string) throws IOException {
        URL uRL = ProjectRunnerImpl.locateScript(string);
        if (uRL == null) {
            return null;
        }
        URL uRL2 = ProjectRunnerImpl.class.getProtectionDomain().getCodeSource().getLocation();
        File file = FileUtil.archiveOrDirForURL((URL)uRL2);
        File file2 = new File(ProjectRunnerImpl.getCacheFolder(), string + ".xml");
        if (!file2.canRead() || file != null && file.lastModified() > file2.lastModified()) {
            try {
                file2.delete();
                URLConnection uRLConnection = uRL.openConnection();
                FileObject fileObject = FileUtil.createData((File)file2);
                ProjectRunnerImpl.copyFile(uRLConnection, fileObject);
                return fileObject;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }
        return FileUtil.toFileObject((File)file2);
    }

    private static String getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        return string;
    }

    private static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            String string = ProjectRunnerImpl.getNbUserDir();
            assert (string != null);
            File file = new File(string);
            cacheFolder = FileUtil.normalizeFile((File)new File(file, SNIPPETS_CACHE_DIR));
            if (!cacheFolder.exists()) {
                boolean bl = cacheFolder.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(URLConnection uRLConnection, FileObject fileObject) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            outputStream = fileObject.getOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static final class FakeElement
    implements Element {
        private final Element delegate;
        private final String projectName;

        public FakeElement(Element element, String string) {
            this.delegate = element;
            this.projectName = string;
        }

        public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
            return this.delegate.setUserData(string, object, userDataHandler);
        }

        public void setTextContent(String string) throws DOMException {
            this.delegate.setTextContent(string);
        }

        public void setPrefix(String string) throws DOMException {
            this.delegate.setPrefix(string);
        }

        public void setNodeValue(String string) throws DOMException {
            this.delegate.setNodeValue(string);
        }

        public Node replaceChild(Node node, Node node2) throws DOMException {
            return this.delegate.replaceChild(node, node2);
        }

        public Node removeChild(Node node) throws DOMException {
            return this.delegate.removeChild(node);
        }

        public void normalize() {
            this.delegate.normalize();
        }

        public String lookupPrefix(String string) {
            return this.delegate.lookupPrefix(string);
        }

        public String lookupNamespaceURI(String string) {
            return this.delegate.lookupNamespaceURI(string);
        }

        public boolean isSupported(String string, String string2) {
            return this.delegate.isSupported(string, string2);
        }

        public boolean isSameNode(Node node) {
            return this.delegate.isSameNode(node);
        }

        public boolean isEqualNode(Node node) {
            return this.delegate.isEqualNode(node);
        }

        public boolean isDefaultNamespace(String string) {
            return this.delegate.isDefaultNamespace(string);
        }

        public Node insertBefore(Node node, Node node2) throws DOMException {
            return this.delegate.insertBefore(node, node2);
        }

        public boolean hasChildNodes() {
            return this.delegate.hasChildNodes();
        }

        public boolean hasAttributes() {
            return this.delegate.hasAttributes();
        }

        public Object getUserData(String string) {
            return this.delegate.getUserData(string);
        }

        public String getTextContent() throws DOMException {
            return this.delegate.getTextContent();
        }

        public Node getPreviousSibling() {
            return this.delegate.getPreviousSibling();
        }

        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        public Node getParentNode() {
            return this.delegate.getParentNode();
        }

        public Document getOwnerDocument() {
            return this.delegate.getOwnerDocument();
        }

        public String getNodeValue() throws DOMException {
            return this.delegate.getNodeValue();
        }

        public short getNodeType() {
            return this.delegate.getNodeType();
        }

        public String getNodeName() {
            return this.delegate.getNodeName();
        }

        public Node getNextSibling() {
            return this.delegate.getNextSibling();
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        public String getLocalName() {
            return this.delegate.getLocalName();
        }

        public Node getLastChild() {
            return this.delegate.getLastChild();
        }

        public Node getFirstChild() {
            return this.delegate.getFirstChild();
        }

        public Object getFeature(String string, String string2) {
            return this.delegate.getFeature(string, string2);
        }

        public NodeList getChildNodes() {
            return this.delegate.getChildNodes();
        }

        public String getBaseURI() {
            return this.delegate.getBaseURI();
        }

        public NamedNodeMap getAttributes() {
            return this.delegate.getAttributes();
        }

        public short compareDocumentPosition(Node node) throws DOMException {
            return this.delegate.compareDocumentPosition(node);
        }

        public Node cloneNode(boolean bl) {
            return this.delegate.cloneNode(bl);
        }

        public Node appendChild(Node node) throws DOMException {
            return this.delegate.appendChild(node);
        }

        public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
            this.delegate.setIdAttributeNode(attr, bl);
        }

        public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
            this.delegate.setIdAttributeNS(string, string2, bl);
        }

        public void setIdAttribute(String string, boolean bl) throws DOMException {
            this.delegate.setIdAttribute(string, bl);
        }

        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            return this.delegate.setAttributeNodeNS(attr);
        }

        public Attr setAttributeNode(Attr attr) throws DOMException {
            return this.delegate.setAttributeNode(attr);
        }

        public void setAttributeNS(String string, String string2, String string3) throws DOMException {
            this.delegate.setAttributeNS(string, string2, string3);
        }

        public void setAttribute(String string, String string2) throws DOMException {
            this.delegate.setAttribute(string, string2);
        }

        public Attr removeAttributeNode(Attr attr) throws DOMException {
            return this.delegate.removeAttributeNode(attr);
        }

        public void removeAttributeNS(String string, String string2) throws DOMException {
            this.delegate.removeAttributeNS(string, string2);
        }

        public void removeAttribute(String string) throws DOMException {
            this.delegate.removeAttribute(string);
        }

        public boolean hasAttributeNS(String string, String string2) throws DOMException {
            return this.delegate.hasAttributeNS(string, string2);
        }

        public boolean hasAttribute(String string) {
            return this.delegate.hasAttribute(string);
        }

        public String getTagName() {
            return this.delegate.getTagName();
        }

        public TypeInfo getSchemaTypeInfo() {
            return this.delegate.getSchemaTypeInfo();
        }

        public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
            return this.delegate.getElementsByTagNameNS(string, string2);
        }

        public NodeList getElementsByTagName(String string) {
            return this.delegate.getElementsByTagName(string);
        }

        public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
            return this.delegate.getAttributeNodeNS(string, string2);
        }

        public Attr getAttributeNode(String string) {
            return this.delegate.getAttributeNode(string);
        }

        public String getAttributeNS(String string, String string2) throws DOMException {
            return this.delegate.getAttributeNS(string, string2);
        }

        public String getAttribute(String string) {
            if ("name".equals(string)) {
                String string2 = this.delegate.getAttribute(string);
                return MessageFormat.format(string2, this.projectName);
            }
            return this.delegate.getAttribute(string);
        }
    }

    private static final class FakeAntProjectCookie
    implements AntProjectCookie,
    ChangeListener {
        private final AntProjectCookie apc;
        private final String projectName;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FakeAntProjectCookie(AntProjectCookie antProjectCookie, String string) {
            this.apc = antProjectCookie;
            this.apc.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.apc));
            this.projectName = string;
        }

        public File getFile() {
            return this.apc.getFile();
        }

        public FileObject getFileObject() {
            return this.apc.getFileObject();
        }

        public Document getDocument() {
            return this.apc.getDocument();
        }

        public Element getProjectElement() {
            return new FakeElement(this.apc.getProjectElement(), this.projectName);
        }

        public Throwable getParseException() {
            return this.apc.getParseException();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.cs.fireChange();
        }
    }
}

