/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.complib.BuiltInComplib;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.ui.HelpSourcesDetailPanel;
import org.netbeans.modules.visualweb.complib.ui.ImportComplibPanel;
import org.netbeans.modules.visualweb.complib.ui.MainDetailPanel;
import org.netbeans.modules.visualweb.complib.ui.PathDetailPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CompLibManagerPanel
extends JPanel {
    private static final ChildUserObject DESIGN_TIME_UO = new ChildUserObject("manager.designTimeNode");
    private static final ChildUserObject RUNTIME_UO = new ChildUserObject("manager.runtimeNode");
    private static final ChildUserObject JAVADOC_UO = new ChildUserObject("manager.javadocNode");
    private static final ChildUserObject SOURCE_UO = new ChildUserObject("manager.sourceNode");
    private static final ChildUserObject WEB_RESOURCES_UO = new ChildUserObject("manager.webResourcesNode");
    private static final ChildUserObject HELP_UO = new ChildUserObject("manager.helpNode");
    private static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
    private JButton btnImport;
    private JButton btnRemove;
    private JPanel buttonPanel;
    private JPanel compLibDetailPanel;
    private JLabel compLibListLabel;
    private JPanel compLibListPanel;
    private JSplitPane compLibSplit;
    private JScrollPane complibListScroll;
    private JTree treeCompLib;
    private GridBagConstraints clGBConstraints;

    public CompLibManagerPanel() {
        this.initComponents();
        this.compLibDetailPanel.setLayout(new GridBagLayout());
        this.clGBConstraints = new GridBagConstraints();
        this.clGBConstraints.fill = 1;
        this.clGBConstraints.weightx = 1.0;
        this.clGBConstraints.weighty = 1.0;
        this.treeCompLib.setCellRenderer(new TreeCellRenderer());
        this.treeCompLib.getSelectionModel().setSelectionMode(1);
        this.initTreeModel(null);
        JScrollBar jScrollBar = this.complibListScroll.getHorizontalScrollBar();
        jScrollBar.setValue(jScrollBar.getMinimum());
    }

    public void addNotify() {
        super.addNotify();
        this.compLibSplit.setDividerLocation(0.5);
    }

    private void initTreeModel(Complib complib) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Component Libraries");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.treeCompLib.setModel(defaultTreeModel);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        ArrayList<Complib> arrayList = csp.getInstalledComplibs();
        int n = 0;
        for (Complib complib2 : arrayList) {
            if (complib == null && n == 0) {
                complib = complib2;
            }
            CompLibUserObject compLibUserObject = new CompLibUserObject(complib2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(compLibUserObject);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(DESIGN_TIME_UO, false);
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(RUNTIME_UO, false);
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(JAVADOC_UO, false);
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(SOURCE_UO, false);
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(WEB_RESOURCES_UO, false);
            DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(HELP_UO, false);
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode3.add(defaultMutableTreeNode5);
            defaultMutableTreeNode3.add(defaultMutableTreeNode6);
            defaultMutableTreeNode3.add(defaultMutableTreeNode7);
            defaultMutableTreeNode3.add(defaultMutableTreeNode8);
            defaultMutableTreeNode3.add(defaultMutableTreeNode9);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, n++);
            Object[] objectArray = defaultMutableTreeNode5.getPath();
            this.treeCompLib.scrollPathToVisible(new TreePath(objectArray));
            if (!complib2.equals(complib)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        if (defaultMutableTreeNode2 != null) {
            this.treeCompLib.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    private void initComponents() {
        this.compLibSplit = new JSplitPane();
        this.compLibDetailPanel = new JPanel();
        this.compLibListPanel = new JPanel();
        this.compLibListLabel = new JLabel();
        this.complibListScroll = new JScrollPane();
        this.treeCompLib = new JTree();
        this.buttonPanel = new JPanel();
        this.btnImport = new JButton();
        this.btnRemove = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(875, 525));
        this.compLibSplit.setDividerLocation(275);
        this.compLibDetailPanel.setLayout(new GridBagLayout());
        this.compLibSplit.setRightComponent(this.compLibDetailPanel);
        this.compLibListPanel.setLayout(new GridBagLayout());
        this.compLibListLabel.setLabelFor(this.treeCompLib);
        Mnemonics.setLocalizedText((JLabel)this.compLibListLabel, (String)NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.componentLibrariesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.compLibListPanel.add((Component)this.compLibListLabel, gridBagConstraints);
        this.compLibListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.componentLibrariesLabelA11yDescription"));
        this.treeCompLib.setRootVisible(false);
        this.treeCompLib.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                CompLibManagerPanel.this.treeCompLibValueChanged(treeSelectionEvent);
            }
        });
        this.complibListScroll.setViewportView(this.treeCompLib);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.compLibListPanel.add((Component)this.complibListScroll, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImport, (String)NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.ImportButton"));
        this.btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompLibManagerPanel.this.btnImportActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.btnImport);
        this.btnImport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.importButtonA11yDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.RemoveButton"));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompLibManagerPanel.this.btnRemoveActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.btnRemove);
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.RemoveButtonA11YDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.compLibListPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.compLibSplit.setLeftComponent(this.compLibListPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.compLibSplit, gridBagConstraints);
    }

    private void btnImportActionPerformed(ActionEvent actionEvent) {
        this.showImportCompLibDialog();
    }

    private void btnRemoveActionPerformed(ActionEvent actionEvent) {
        TreePath treePath = this.treeCompLib.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        Complib complib = this.getComponentLibraryForNode(defaultMutableTreeNode);
        if (!(complib instanceof ExtensionComplib)) {
            return;
        }
        ExtensionComplib extensionComplib = (ExtensionComplib)complib;
        String string = csp.getInUseProjectNames(extensionComplib);
        if (string == null) {
            String string2 = NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.RemoveComplibConfirm");
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION == object) {
                csp.remove(extensionComplib);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildBefore(defaultMutableTreeNode);
                if (defaultMutableTreeNode3 == null) {
                    this.initTreeModel(null);
                } else {
                    this.initTreeModel(this.getComponentLibraryForNode(defaultMutableTreeNode3));
                }
            }
        } else {
            String string3 = NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.RemoveComplibInUse");
            string3 = MessageFormat.format(string3, string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void treeCompLibValueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeCompLib.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            this.setDetailPanel(null);
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof CompLibUserObject) {
            CompLibUserObject compLibUserObject = (CompLibUserObject)object;
            this.updateRemoveButtonState(compLibUserObject.getComponentLibrary());
            this.setDetailPanel(new MainDetailPanel(compLibUserObject.getComponentLibrary()));
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            CompLibUserObject compLibUserObject = (CompLibUserObject)defaultMutableTreeNode2.getUserObject();
            Complib complib = compLibUserObject.getComponentLibrary();
            this.updateRemoveButtonState(complib);
            if (object == DESIGN_TIME_UO) {
                String string = "manager.DesignTimeLabel";
                String string2 = "manager.DesignTimeDescription";
                String string3 = "manager.DesignTimeMnemonic";
                this.setDetailPanel(new PathDetailPanel(complib.getDesignTimePath(), string, string2, string3));
            } else if (object == RUNTIME_UO) {
                String string = "manager.RuntimeLabel";
                String string4 = "manager.RuntimeDescription";
                String string5 = "manager.RuntimeMnemonic";
                this.setDetailPanel(new PathDetailPanel(complib.getRuntimePath(), string, string4, string5));
            } else if (object == JAVADOC_UO) {
                String string = "manager.JavadocLabel";
                String string6 = "manager.JavadocDescription";
                String string7 = "manager.JavadocMnemonic";
                this.setDetailPanel(new PathDetailPanel(complib.getJavadocPath(), string, string6, string7));
            } else if (object == SOURCE_UO) {
                String string = "manager.SourceLabel";
                String string8 = "manager.SourceDescription";
                String string9 = "manager.SourceMnemonic";
                this.setDetailPanel(new PathDetailPanel(complib.getSourcePath(), string, string8, string9));
            } else if (object == WEB_RESOURCES_UO) {
                String string = "manager.WebResourceLabel";
                String string10 = "manager.WebResourceDescription";
                String string11 = "manager.WebResourceMnemonic";
                this.setDetailPanel(new PathDetailPanel(complib.getWebResourcePath(), string, string10, string11));
            } else if (object == HELP_UO) {
                this.setDetailPanel(new HelpSourcesDetailPanel(complib));
            }
        }
    }

    private Complib getComponentLibraryForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof CompLibUserObject) {
            CompLibUserObject compLibUserObject = (CompLibUserObject)object;
            return compLibUserObject.getComponentLibrary();
        }
        assert (object instanceof ChildUserObject);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        CompLibUserObject compLibUserObject = (CompLibUserObject)defaultMutableTreeNode2.getUserObject();
        return compLibUserObject.getComponentLibrary();
    }

    private synchronized void showImportCompLibDialog() {
        new ImportComplibPanel().showDialog(this);
    }

    synchronized void notifyImportComplete(Complib complib) {
        this.initTreeModel(complib);
    }

    private void updateRemoveButtonState(Complib complib) {
        this.btnRemove.setEnabled(!(complib instanceof BuiltInComplib));
    }

    private void setDetailPanel(Component component) {
        this.compLibDetailPanel.removeAll();
        if (component != null) {
            this.compLibDetailPanel.add(component, this.clGBConstraints);
        }
        this.compLibDetailPanel.updateUI();
    }

    public void showDialog() {
        String string = NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.dialogTitle");
        HelpCtx helpCtx = new HelpCtx("projrave_ui_elements_dialogs_component_library_manager");
        JButton jButton = new JButton();
        jButton.setMnemonic(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.closeButtonMnemonic").charAt(0));
        String string2 = NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.closeButtonLabel");
        jButton.setText(string2);
        jButton.getAccessibleContext().setAccessibleDescription(string2);
        Object[] objectArray = new Object[]{jButton};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string, true, objectArray, (Object)jButton, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.dialogA11yName"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompLibManagerPanel.class, (String)"manager.dialogA11yDescription"));
        dialogDescriptor.setValid(true);
        dialog.setVisible(true);
    }

    public static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static ImageIcon LIBRARY_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/libraries.png"));
        private static ImageIcon HELP_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/help.gif"));
        private static ImageIcon JAVADOC_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/JavaDoc.gif"));
        private static ImageIcon DESIGN_TIME_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/library.png"));
        private static ImageIcon RUNTIME_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/library.png"));
        private static ImageIcon JAR_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/jar.gif"));
        private static ImageIcon WEB_RESOURCES_ICON = new ImageIcon(TreeCellRenderer.class.getResource("images/library.gif"));

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(LIBRARY_ICON);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof ChildUserObject) {
                if (object2 == DESIGN_TIME_UO) {
                    this.setIcon(DESIGN_TIME_ICON);
                } else if (object2 == RUNTIME_UO) {
                    this.setIcon(RUNTIME_ICON);
                } else if (object2 == JAVADOC_UO) {
                    this.setIcon(JAVADOC_ICON);
                } else if (object2 == SOURCE_UO) {
                    this.setIcon(JAR_ICON);
                } else if (object2 == WEB_RESOURCES_UO) {
                    this.setIcon(WEB_RESOURCES_ICON);
                } else if (object2 == HELP_UO) {
                    this.setIcon(HELP_ICON);
                }
            }
            return this;
        }
    }

    private static class ChildUserObject {
        private String key;

        private ChildUserObject(String string) {
            this.key = string;
        }

        public String toString() {
            try {
                return NbBundle.getMessage(CompLibManagerPanel.class, (String)this.key);
            }
            catch (MissingResourceException missingResourceException) {
                IdeUtil.logWarning(missingResourceException);
                return this.key;
            }
        }
    }

    private static class CompLibUserObject {
        private Complib compLib;

        private CompLibUserObject(Complib complib) {
            this.compLib = complib;
        }

        public Complib getComponentLibrary() {
            return this.compLib;
        }

        public String toString() {
            return this.compLib.getVersionedTitle();
        }
    }
}

