/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static Method xalanMethod;
    private Document doc;
    private DocumentBuilder db;

    public XmlUtil() {
        this(null);
    }

    public XmlUtil(Document document) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.db = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            assert (false);
            throw new RuntimeException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        this.doc = document;
    }

    public Document read(File file) throws XmlException {
        try {
            this.doc = this.db.parse(file);
        }
        catch (Exception exception) {
            throw new XmlException("Unable to parse input file: " + file, exception);
        }
        return this.doc;
    }

    public Document read(URI uRI) throws XmlException {
        try {
            this.doc = this.db.parse(uRI.toASCIIString());
        }
        catch (Exception exception) {
            throw new XmlException("Unable to parse input URI: " + uRI, exception);
        }
        return this.doc;
    }

    public Document read(URL uRL) throws XmlException {
        URI uRI;
        try {
            uRI = new URI(uRL.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XmlException("Unable to parse input URL: " + uRL, uRISyntaxException);
        }
        this.read(uRI);
        return this.doc;
    }

    public Document createDocument() {
        this.doc = this.db.newDocument();
        return this.doc;
    }

    public Document getDocument() {
        if (this.doc == null) {
            this.createDocument();
        }
        return this.doc;
    }

    public Element createElement(String string) {
        return this.getDocument().createElementNS(null, string);
    }

    public void write(File file) throws XmlException {
        DOMSource dOMSource = new DOMSource(this.getDocument());
        StreamResult streamResult = new StreamResult(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new XmlException("Unable to write to file: " + file, transformerException);
        }
    }

    public static NodeList selectNodeList(Node node, String string) throws XmlException {
        Object object;
        if (xalanMethod == null) {
            try {
                object = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI", true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                IdeUtil.logWarning("JDK 5 version failed, so will next try JDK 1.4", classNotFoundException);
                try {
                    object = Class.forName("org.apache.xpath.XPathAPI", true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    IdeUtil.logWarning(classNotFoundException2);
                    return null;
                }
            }
            try {
                xalanMethod = ((Class)object).getDeclaredMethod("selectNodeList", Node.class, String.class);
            }
            catch (Exception exception) {
                IdeUtil.logWarning(exception);
                return null;
            }
        }
        object = null;
        try {
            object = xalanMethod.invoke(null, node, string);
        }
        catch (Exception exception) {
            IdeUtil.logWarning(exception);
        }
        return (NodeList)object;
    }

    public static Node selectSingleNode(Node node, String string) throws XmlException {
        NodeList nodeList = XmlUtil.selectNodeList(node, string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }
}

