/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.util.DefaultVisualizer;
import org.netbeans.jemmy.util.MouseVisualizer;

public abstract class Operator
implements Timeoutable,
Outputable {
    public static final String CLASS_DPROP = "Class";
    public static final String TO_STRING_DPROP = "toString";
    private static Vector operatorPkgs;
    private Timeouts timeouts;
    private TestOut output;
    private ClassReference codeDefiner;
    private int model;
    private CharBindingMap map;
    private ComponentVisualizer visualizer;
    private StringComparator comparator;
    private PathParser parser;
    private QueueTool queueTool;
    private boolean verification = false;
    private JemmyProperties properties;

    public Operator() {
        this.initEnvironment();
    }

    public static ComponentVisualizer setDefaultComponentVisualizer(ComponentVisualizer componentVisualizer) {
        return (ComponentVisualizer)JemmyProperties.setCurrentProperty("ComponentOperator.ComponentVisualizer", componentVisualizer);
    }

    public static ComponentVisualizer getDefaultComponentVisualizer() {
        return (ComponentVisualizer)JemmyProperties.getCurrentProperty("ComponentOperator.ComponentVisualizer");
    }

    public static StringComparator setDefaultStringComparator(StringComparator stringComparator) {
        return (StringComparator)JemmyProperties.setCurrentProperty("ComponentOperator.StringComparator", stringComparator);
    }

    public static StringComparator getDefaultStringComparator() {
        return (StringComparator)JemmyProperties.getCurrentProperty("ComponentOperator.StringComparator");
    }

    public static PathParser setDefaultPathParser(PathParser pathParser) {
        return (PathParser)JemmyProperties.setCurrentProperty("ComponentOperator.PathParser", pathParser);
    }

    public static PathParser getDefaultPathParser() {
        return (PathParser)JemmyProperties.getCurrentProperty("ComponentOperator.PathParser");
    }

    public static boolean setDefaultVerification(boolean bl) {
        Boolean bl2 = (Boolean)JemmyProperties.setCurrentProperty("Operator.Verification", bl ? Boolean.TRUE : Boolean.FALSE);
        return bl2 != null ? bl2 : false;
    }

    public static boolean getDefaultVerification() {
        return (Boolean)JemmyProperties.getCurrentProperty("Operator.Verification");
    }

    public static boolean isCaptionEqual(String string, String string2, boolean bl, boolean bl2) {
        return new DefaultStringComparator(bl, bl2).equals(string, string2);
    }

    public static boolean isCaptionEqual(String string, String string2, StringComparator stringComparator) {
        return stringComparator.equals(string, string2);
    }

    public static int getDefaultMouseButton() {
        return 16;
    }

    public static int getPopupMouseButton() {
        return 4;
    }

    public static ComponentOperator createOperator(Component component) {
        try {
            Class<?> clazz = Class.forName("java.awt.Component");
            Class<?> clazz2 = component.getClass();
            do {
                ComponentOperator componentOperator;
                if ((componentOperator = Operator.createOperator(component, clazz2)) == null) continue;
                return componentOperator;
            } while (clazz.isAssignableFrom(clazz2 = clazz2.getSuperclass()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static void addOperatorPackage(String string) {
        operatorPkgs.add(string);
    }

    public static Operator getEnvironmentOperator() {
        return new NullOperator();
    }

    public abstract Component getSource();

    public QueueTool getQueueTool() {
        return this.queueTool;
    }

    public void copyEnvironment(Operator operator) {
        this.setTimeouts(operator.getTimeouts());
        this.setOutput(operator.getOutput());
        this.setVisualizer(operator.getVisualizer());
        this.setComparator(operator.getComparator());
        this.setVerification(operator.getVerification());
        this.setCharBindingMap(operator.getCharBindingMap());
        this.setProperties(operator.getProperties());
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.queueTool.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public ComponentVisualizer getVisualizer() {
        return this.visualizer;
    }

    public void setVisualizer(ComponentVisualizer componentVisualizer) {
        this.visualizer = componentVisualizer;
    }

    public JemmyProperties getProperties() {
        return this.properties;
    }

    public JemmyProperties setProperties(JemmyProperties jemmyProperties) {
        JemmyProperties jemmyProperties2 = this.getProperties();
        this.properties = jemmyProperties;
        return jemmyProperties2;
    }

    public void setCharBindingMap(CharBindingMap charBindingMap) {
        this.map = charBindingMap;
    }

    public CharBindingMap getCharBindingMap() {
        return this.map;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        this.queueTool.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public StringComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(StringComparator stringComparator) {
        this.comparator = stringComparator;
    }

    public PathParser getPathParser() {
        return this.parser;
    }

    public void setPathParser(PathParser pathParser) {
        this.parser = pathParser;
    }

    public boolean setVerification(boolean bl) {
        boolean bl2 = this.verification;
        this.verification = bl;
        return bl2;
    }

    public boolean getVerification() {
        return this.verification;
    }

    public String[] getParentPath(String[] stringArray) {
        if (stringArray.length > 1) {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            return stringArray2;
        }
        return new String[0];
    }

    public ComponentChooser[] getParentPath(ComponentChooser[] componentChooserArray) {
        if (componentChooserArray.length > 1) {
            ComponentChooser[] componentChooserArray2 = new ComponentChooser[componentChooserArray.length - 1];
            for (int i = 0; i < componentChooserArray2.length; ++i) {
                componentChooserArray2[i] = componentChooserArray[i];
            }
            return componentChooserArray2;
        }
        return new ComponentChooser[0];
    }

    public String[] parseString(String string) {
        return this.getPathParser().parse(string);
    }

    public String[] parseString(String string, String string2) {
        return new DefaultPathParser(string2).parse(string);
    }

    public int getCharKey(char c) {
        return this.map.getCharKey(c);
    }

    public int getCharModifiers(char c) {
        return this.map.getCharModifiers(c);
    }

    public int[] getCharsKeys(char[] cArray) {
        int[] nArray = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            nArray[i] = this.getCharKey(cArray[i]);
        }
        return nArray;
    }

    public int[] getCharsModifiers(char[] cArray) {
        int[] nArray = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            nArray[i] = this.getCharModifiers(cArray[i]);
        }
        return nArray;
    }

    public int[] getCharsKeys(String string) {
        return this.getCharsKeys(string.toCharArray());
    }

    public int[] getCharsModifiers(String string) {
        return this.getCharsModifiers(string.toCharArray());
    }

    public boolean isCaptionEqual(String string, String string2) {
        return this.comparator.equals(string, string2);
    }

    public void printDump() {
        Hashtable hashtable = this.getDump();
        Object[] objectArray = hashtable.keySet().toArray();
        for (int i = 0; i < hashtable.size(); ++i) {
            this.output.printLine((String)objectArray[i] + " = " + (String)hashtable.get(objectArray[i]));
        }
    }

    public Hashtable getDump() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(CLASS_DPROP, this.getSource().getClass().getName());
        hashtable.put(TO_STRING_DPROP, this.getSource().toString());
        return hashtable;
    }

    public void waitState(final ComponentChooser componentChooser) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                return componentChooser.checkComponent(Operator.this.getSource()) ? "" : null;
            }

            public String getDescription() {
                return "Wait \"" + componentChooser.getDescription() + "\" state to be reached";
            }
        });
        waiter.setTimeouts(this.getTimeouts().cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("ComponentOperator.WaitStateTimeout"));
        waiter.setOutput(this.getOutput().createErrorOutput());
        try {
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting of \"" + componentChooser.getDescription() + "\" state has been interrupted!");
        }
    }

    protected Object produceTimeRestricted(Action action, Object object, long l) {
        ActionProducer actionProducer = new ActionProducer(action);
        actionProducer.setOutput(this.getOutput().createErrorOutput());
        actionProducer.setTimeouts(this.getTimeouts().cloneThis());
        actionProducer.getTimeouts().setTimeout("ActionProducer.MaxActionTime", l);
        try {
            Object object2 = actionProducer.produceAction(object);
            Throwable throwable = actionProducer.getException();
            if (throwable != null) {
                if (throwable instanceof JemmyException) {
                    throw (JemmyException)throwable;
                }
                throw new JemmyException("Exception during " + action.getDescription(), throwable);
            }
            return object2;
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted!", interruptedException);
        }
    }

    protected Object produceTimeRestricted(Action action, long l) {
        return this.produceTimeRestricted(action, null, l);
    }

    protected void produceNoBlocking(NoBlockingAction noBlockingAction, Object object) {
        try {
            ActionProducer actionProducer = new ActionProducer(noBlockingAction, false);
            actionProducer.setOutput(this.output.createErrorOutput());
            actionProducer.setTimeouts(this.timeouts);
            actionProducer.produceAction(object);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Exception during \"" + noBlockingAction.getDescription() + "\" execution", interruptedException);
        }
        if (noBlockingAction.exception != null) {
            throw new JemmyException("Exception during nonblocking \"" + noBlockingAction.getDescription() + "\"", noBlockingAction.exception);
        }
    }

    protected void produceNoBlocking(NoBlockingAction noBlockingAction) {
        this.produceNoBlocking(noBlockingAction, null);
    }

    protected void lockQueue() {
        this.queueTool.lock();
    }

    protected void unlockQueue() {
        this.queueTool.unlock();
    }

    protected void unlockAndThrow(Exception exception) {
        this.unlockQueue();
        throw new JemmyException("Exception during queue locking", exception);
    }

    protected Object runMapping(MapAction mapAction) {
        return this.runMappingPrimitive(mapAction);
    }

    protected char runMapping(MapCharacterAction mapCharacterAction) {
        return ((Character)this.runMappingPrimitive(mapCharacterAction)).charValue();
    }

    protected byte runMapping(MapByteAction mapByteAction) {
        return (Byte)this.runMappingPrimitive(mapByteAction);
    }

    protected int runMapping(MapIntegerAction mapIntegerAction) {
        return (Integer)this.runMappingPrimitive(mapIntegerAction);
    }

    protected long runMapping(MapLongAction mapLongAction) {
        return (Long)this.runMappingPrimitive(mapLongAction);
    }

    protected float runMapping(MapFloatAction mapFloatAction) {
        return ((Float)this.runMappingPrimitive(mapFloatAction)).floatValue();
    }

    protected double runMapping(MapDoubleAction mapDoubleAction) {
        return (Double)this.runMappingPrimitive(mapDoubleAction);
    }

    protected boolean runMapping(MapBooleanAction mapBooleanAction) {
        return (Boolean)this.runMappingPrimitive(mapBooleanAction);
    }

    protected void runMapping(MapVoidAction mapVoidAction) {
        this.runMappingPrimitive(mapVoidAction);
    }

    protected String[] addToDump(Hashtable hashtable, String string, Object[] objectArray) {
        String[] stringArray = this.createNames(string + "_", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            hashtable.put(stringArray[i], objectArray[i].toString());
        }
        return stringArray;
    }

    protected String[] addToDump(Hashtable hashtable, String string, Object[][] objectArray) {
        String[] stringArray = this.createNames(string + "_", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.addToDump(hashtable, stringArray[i], objectArray[i]);
        }
        return stringArray;
    }

    private Object runMappingPrimitive(QueueTool.QueueAction queueAction) {
        return this.queueTool.invokeSmoothly(queueAction);
    }

    private String[] createNames(String string, int n) {
        String[] stringArray = new String[n];
        int n2 = Integer.toString(n).length();
        String string2 = "";
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + "0";
        }
        for (int i = 0; i < n; ++i) {
            String string3 = Integer.toString(i);
            stringArray[i] = string + string2.substring(0, n2 - string3.length()) + string3;
        }
        return stringArray;
    }

    private static ComponentOperator createOperator(Component component, Class clazz) {
        StringTokenizer stringTokenizer = new StringTokenizer(clazz.getName(), ".");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        Object[] objectArray = new Object[]{component};
        Class[] classArray = new Class[]{clazz};
        for (int i = 0; i < operatorPkgs.size(); ++i) {
            String string2 = (String)operatorPkgs.get(i);
            try {
                return (ComponentOperator)new ClassReference(string2 + "." + string + "Operator").newInstance(objectArray, classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void initEnvironment() {
        try {
            this.codeDefiner = new ClassReference("java.awt.event.KeyEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.queueTool = new QueueTool();
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setCharBindingMap(JemmyProperties.getProperties().getCharBindingMap());
        this.setVisualizer(Operator.getDefaultComponentVisualizer());
        this.setComparator(Operator.getDefaultStringComparator());
        this.setVerification(Operator.getDefaultVerification());
        this.setProperties(JemmyProperties.getProperties());
        this.setPathParser(Operator.getDefaultPathParser());
    }

    private int nextDelimIndex(String string, String string2) {
        String string3 = string;
        int n = 0;
        while ((n = string3.indexOf(string2)) != -1) {
            if (n != 0 && string3.substring(n - 1, n).equals("\\")) continue;
            return n;
        }
        return -1;
    }

    public String toStringSource() {
        return (String)this.runMapping(new MapAction("getSource().toString()"){

            public Object map() {
                return Operator.this.getSource().toString();
            }
        });
    }

    static {
        String string = System.getProperty("os.name").toUpperCase();
        if (string.startsWith("LINUX")) {
            Operator.setDefaultComponentVisualizer(new MouseVisualizer(MouseVisualizer.TOP, 0.5, 10, false));
        } else if (string.startsWith("SUNOS")) {
            Operator.setDefaultComponentVisualizer(new MouseVisualizer());
        } else {
            Operator.setDefaultComponentVisualizer(new DefaultVisualizer());
        }
        operatorPkgs = new Vector();
        Operator.setDefaultStringComparator(new DefaultStringComparator(false, false));
        Operator.setDefaultPathParser(new DefaultPathParser("|"));
        Operator.addOperatorPackage("org.netbeans.jemmy.operators");
        Operator.setDefaultVerification(true);
    }

    private static class NullOperator
    extends Operator {
        public Component getSource() {
            return null;
        }
    }

    protected abstract class MapVoidAction
    extends QueueTool.QueueAction {
        public MapVoidAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            this.map();
            return null;
        }

        public abstract void map() throws Exception;
    }

    protected abstract class MapBooleanAction
    extends QueueTool.QueueAction {
        public MapBooleanAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return this.map() ? Boolean.TRUE : Boolean.FALSE;
        }

        public abstract boolean map() throws Exception;
    }

    protected abstract class MapDoubleAction
    extends QueueTool.QueueAction {
        public MapDoubleAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Double(this.map());
        }

        public abstract double map() throws Exception;
    }

    protected abstract class MapFloatAction
    extends QueueTool.QueueAction {
        public MapFloatAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Float(this.map());
        }

        public abstract float map() throws Exception;
    }

    protected abstract class MapLongAction
    extends QueueTool.QueueAction {
        public MapLongAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Long(this.map());
        }

        public abstract long map() throws Exception;
    }

    protected abstract class MapIntegerAction
    extends QueueTool.QueueAction {
        public MapIntegerAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Integer(this.map());
        }

        public abstract int map() throws Exception;
    }

    protected abstract class MapByteAction
    extends QueueTool.QueueAction {
        public MapByteAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Byte(this.map());
        }

        public abstract byte map() throws Exception;
    }

    protected abstract class MapCharacterAction
    extends QueueTool.QueueAction {
        public MapCharacterAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return new Character(this.map());
        }

        public abstract char map() throws Exception;
    }

    protected abstract class MapAction
    extends QueueTool.QueueAction {
        public MapAction(String string) {
            super(string);
        }

        public final Object launch() throws Exception {
            return this.map();
        }

        public abstract Object map() throws Exception;
    }

    protected abstract class NoBlockingAction
    implements Action {
        String description;
        Exception exception;
        boolean finished;

        public NoBlockingAction(String string) {
            this.description = string;
            this.exception = null;
            this.finished = false;
        }

        public final Object launch(Object object) {
            Object object2 = null;
            try {
                object2 = this.doAction(object);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            this.finished = true;
            return object2;
        }

        public abstract Object doAction(Object var1);

        public String getDescription() {
            return this.description;
        }

        protected void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class Finder
    implements ComponentChooser {
        Class clz;
        ComponentChooser subchooser;

        public Finder(Class clazz, ComponentChooser componentChooser) {
            this.clz = clazz;
            this.subchooser = componentChooser;
        }

        public Finder(Class clazz) {
            this(clazz, ComponentSearcher.getTrueChooser("Any " + clazz.getName()));
        }

        public boolean checkComponent(Component component) {
            if (this.clz.isInstance(component)) {
                return this.subchooser.checkComponent(component);
            }
            return false;
        }

        public String getDescription() {
            return this.subchooser.getDescription();
        }
    }

    public static class DefaultPathParser
    implements PathParser {
        String separator;

        public DefaultPathParser(String string) {
            this.separator = string;
        }

        public String[] parse(String string) {
            if (string.length() > 0) {
                Vector<String> vector = new Vector<String>();
                int n = 0;
                int n2 = 0;
                while ((n2 = string.indexOf(this.separator, n)) != -1) {
                    vector.add(string.substring(n, n2));
                    n = n2 + this.separator.length();
                }
                vector.add(string.substring(n));
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[i] = (String)vector.get(i);
                }
                return stringArray;
            }
            return new String[0];
        }
    }

    public static interface PathParser {
        public String[] parse(String var1);
    }

    public static class DefaultStringComparator
    implements StringComparator {
        boolean ce;
        boolean ccs;

        public DefaultStringComparator(boolean bl, boolean bl2) {
            this.ce = bl;
            this.ccs = bl2;
        }

        public boolean equals(String string, String string2) {
            String string3;
            String string4;
            if (string2 == null) {
                return true;
            }
            if (string == null) {
                return false;
            }
            if (!this.ccs) {
                string4 = string.toUpperCase();
                string3 = string2.toUpperCase();
            } else {
                string4 = string;
                string3 = string2;
            }
            if (this.ce) {
                return string4.equals(string3);
            }
            return string4.indexOf(string3) != -1;
        }
    }

    public static interface StringComparator {
        public boolean equals(String var1, String var2);
    }

    public static interface ComponentVisualizer {
        public void makeVisible(ComponentOperator var1);
    }
}

