/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TreeDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JTreeOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String ROOT_DPROP = "Root";
    public static final String NODE_PREFIX_DPROP = "Node";
    public static final String SELECTION_FIRST_DPROP = "First selected";
    public static final String SELECTION_LAST_DPROP = "Last selected";
    private static final long WAIT_NODE_EXPANDED_TIMEOUT = 60000L;
    private static final long WAIT_NODE_COLLAPSED_TIMEOUT = 60000L;
    private static final long WAIT_AFTER_NODE_EXPANDED_TIMEOUT = 0L;
    private static final long WAIT_NEXT_NODE_TIMEOUT = 60000L;
    private static final long WAIT_NODE_VISIBLE_TIMEOUT = 60000L;
    private static final long BEFORE_EDIT_TIMEOUT = 1000L;
    private static final long WAIT_EDITING_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    private TreeDriver driver = DriverManager.getTreeDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JTree;

    public JTreeOperator(JTree jTree) {
        super(jTree);
    }

    public JTreeOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JTree)containerOperator.waitSubComponent(new JTreeFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JTreeOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JTreeOperator(ContainerOperator containerOperator, String string, int n, int n2) {
        this((JTree)JTreeOperator.waitComponent(containerOperator, (ComponentChooser)new JTreeByItemFinder(string, n, containerOperator.getComparator()), n2));
        this.copyEnvironment(containerOperator);
    }

    public JTreeOperator(ContainerOperator containerOperator, String string, int n) {
        this(containerOperator, string, -1, n);
    }

    public JTreeOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JTreeOperator(ContainerOperator containerOperator, int n) {
        this((JTree)JTreeOperator.waitComponent(containerOperator, (ComponentChooser)new JTreeFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JTreeOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JTree findJTree(Container container, ComponentChooser componentChooser, int n) {
        return (JTree)JTreeOperator.findComponent(container, new JTreeFinder(componentChooser), n);
    }

    public static JTree findJTree(Container container, ComponentChooser componentChooser) {
        return JTreeOperator.findJTree(container, componentChooser, 0);
    }

    public static JTree findJTree(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JTreeOperator.findJTree(container, new JTreeByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JTree findJTree(Container container, String string, boolean bl, boolean bl2, int n) {
        return JTreeOperator.findJTree(container, string, bl, bl2, n, 0);
    }

    public static JTree waitJTree(Container container, ComponentChooser componentChooser, int n) {
        return (JTree)JTreeOperator.waitComponent(container, (ComponentChooser)new JTreeFinder(componentChooser), n);
    }

    public static JTree waitJTree(Container container, ComponentChooser componentChooser) {
        return JTreeOperator.waitJTree(container, componentChooser, 0);
    }

    public static JTree waitJTree(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JTreeOperator.waitJTree(container, new JTreeByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JTree waitJTree(Container container, String string, boolean bl, boolean bl2, int n) {
        return JTreeOperator.waitJTree(container, string, bl, bl2, n, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (TreeDriver)DriverManager.getDriver("drivers.tree", this.getClass(), operator.getProperties());
    }

    public void doExpandPath(TreePath treePath) {
        if (treePath == null) {
            throw new NoSuchPathException();
        }
        this.output.printLine("Expanding \"" + treePath.getPathComponent(treePath.getPathCount() - 1).toString() + "\" node");
        this.output.printGolden("Expanding \"" + treePath.getPathComponent(treePath.getPathCount() - 1).toString() + "\" node");
        this.driver.expandItem(this, this.getRowForPath(treePath));
        this.waitExpanded(treePath);
    }

    public void doExpandRow(int n) {
        this.output.printLine("Expanding " + Integer.toString(n) + " row");
        this.output.printGolden("Expanding " + Integer.toString(n) + " row");
        this.driver.expandItem(this, n);
        this.waitExpanded(n);
    }

    public void doMakeVisible(TreePath treePath) {
        if (treePath == null) {
            throw new NoSuchPathException();
        }
        this.output.printLine("Making \"" + treePath.toString() + "\" path visible");
        this.output.printGolden("Making path visible");
        this.makeVisible(treePath);
        this.waitVisible(treePath);
    }

    public int getChildCount(final Object object) {
        return this.runMapping(new Operator.MapIntegerAction("getChildCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getModel().getChildCount(object);
            }
        });
    }

    public Object[] getChildren(final Object object) {
        return (Object[])this.runMapping(new Operator.MapAction("getChildren"){

            public Object map() {
                TreeModel treeModel = ((JTree)JTreeOperator.this.getSource()).getModel();
                Object[] objectArray = new Object[treeModel.getChildCount(object)];
                for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                    objectArray[i] = treeModel.getChild(object, i);
                }
                return objectArray;
            }
        });
    }

    public Object getChild(final Object object, final int n) {
        return this.runMapping(new Operator.MapAction("getChild"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getModel().getChild(object, n);
            }
        });
    }

    public int getChildCount(TreePath treePath) {
        if (treePath != null) {
            return this.getChildCount(treePath.getLastPathComponent());
        }
        throw new NoSuchPathException();
    }

    public TreePath getChildPath(TreePath treePath, int n) {
        if (treePath != null) {
            return treePath.pathByAddingChild(this.getChild(treePath.getLastPathComponent(), n));
        }
        throw new NoSuchPathException();
    }

    public TreePath[] getChildPaths(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray = this.getChildren(treePath.getLastPathComponent());
            TreePath[] treePathArray = new TreePath[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                treePathArray[i] = treePath.pathByAddingChild(objectArray[i]);
            }
            return treePathArray;
        }
        throw new NoSuchPathException();
    }

    public Object getRoot() {
        Timeouts timeouts = this.timeouts.cloneThis();
        timeouts.setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("JTreeOperator.WaitNodeVisibleTimeout"));
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                Object object2 = JTreeOperator.this.getModel().getRoot();
                if (object2 == null || object2.toString() == null || object2.toString().equals("null")) {
                    return null;
                }
                return object2;
            }

            public String getDescription() {
                return "Wait root node";
            }
        });
        waiter.setTimeouts(timeouts);
        waiter.setOutput(this.output.createErrorOutput());
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
            return null;
        }
    }

    public TreePath findPath(TreePathChooser treePathChooser) {
        this.output.printLine("Search for a tree path " + treePathChooser.getDescription());
        this.output.printGolden("Search for a tree path");
        TreePath treePath = new TreePath(this.getRoot());
        if (treePathChooser.checkPath(treePath, 0)) {
            return treePath;
        }
        Timeouts timeouts = this.timeouts.cloneThis();
        timeouts.setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("JTreeOperator.WaitNextNodeTimeout"));
        Waiter waiter = new Waiter(new Waitable(){
            TreePath currentPath;
            String requestedPath;

            public Object actionProduced(Object object) {
                TreePath treePath;
                TreePathChooser treePathChooser = (TreePathChooser)((Object[])object)[0];
                this.requestedPath = treePathChooser.getDescription();
                this.currentPath = treePath = (TreePath)((Object[])object)[1];
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = JTreeOperator.this.getChildren(treePath.getLastPathComponent());
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray[0] = treePath.pathByAddingChild(objectArray2[i]);
                    if (treePathChooser.checkPath((TreePath)objectArray[0], i)) {
                        objectArray[1] = Boolean.TRUE;
                        return objectArray;
                    }
                    if (!treePathChooser.hasAsParent((TreePath)objectArray[0], i)) continue;
                    objectArray[1] = Boolean.FALSE;
                    return objectArray;
                }
                return null;
            }

            public String getDescription() {
                return "Wait next node loaded under parent " + this.currentPath + " when requested was " + this.requestedPath;
            }
        });
        waiter.setTimeouts(timeouts);
        waiter.setOutput(this.output.createErrorOutput());
        return this.findPathPrimitive(treePath, treePathChooser, waiter);
    }

    public int findRow(TreeRowChooser treeRowChooser, int n) {
        TreeModel treeModel = this.getModel();
        int n2 = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!treeRowChooser.checkRow(this, i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    public int findRow(TreeRowChooser treeRowChooser) {
        return this.findRow(treeRowChooser, 0);
    }

    public int findRow(String string, Operator.StringComparator stringComparator, int n) {
        return this.findRow(new BySubStringTreeRowChooser(string, stringComparator), n);
    }

    public int findRow(String string, boolean bl, boolean bl2, int n) {
        return this.findRow(string, new Operator.DefaultStringComparator(bl, bl2), n);
    }

    public int findRow(String string, int n) {
        return this.findRow(string, this.getComparator(), n);
    }

    public int findRow(String string, Operator.StringComparator stringComparator) {
        return this.findRow(string, stringComparator, 0);
    }

    public int findRow(String string, boolean bl, boolean bl2) {
        return this.findRow(string, bl, bl2, 0);
    }

    public int findRow(String string) {
        return this.findRow(string, this.getComparator(), 0);
    }

    public int findRow(ComponentChooser componentChooser, int n) {
        return this.findRow(new ByRenderedComponentTreeRowChooser(componentChooser), n);
    }

    public int findRow(ComponentChooser componentChooser) {
        return this.findRow(componentChooser, 0);
    }

    public TreePath findPath(String[] stringArray, int[] nArray, Operator.StringComparator stringComparator) {
        return this.findPath(new StringArrayPathChooser(stringArray, nArray, stringComparator));
    }

    public TreePath findPath(String[] stringArray, int[] nArray, boolean bl, boolean bl2) {
        return this.findPath(stringArray, nArray, (Operator.StringComparator)new Operator.DefaultStringComparator(bl, bl2));
    }

    public TreePath findPath(String[] stringArray, int[] nArray) {
        return this.findPath(stringArray, nArray, this.getComparator());
    }

    public TreePath findPath(String[] stringArray, Operator.StringComparator stringComparator) {
        int[] nArray = new int[]{};
        return this.findPath(stringArray, nArray, stringComparator);
    }

    public TreePath findPath(String[] stringArray, boolean bl, boolean bl2) {
        int[] nArray = new int[]{};
        return this.findPath(stringArray, nArray, bl, bl2);
    }

    public TreePath findPath(String[] stringArray) {
        int[] nArray = new int[]{};
        return this.findPath(stringArray, nArray, this.getComparator());
    }

    public TreePath findPath(String string, String string2, String string3, Operator.StringComparator stringComparator) {
        String[] stringArray = this.parseString(string2, string3);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return this.findPath(this.parseString(string, string3), nArray, stringComparator);
    }

    public TreePath findPath(String string, String string2, String string3, boolean bl, boolean bl2) {
        return this.findPath(string, string2, string3, new Operator.DefaultStringComparator(bl, bl2));
    }

    public TreePath findPath(String string, String string2, String string3) {
        return this.findPath(string, string2, string3, this.getComparator());
    }

    public TreePath findPath(String string, String string2, Operator.StringComparator stringComparator) {
        return this.findPath(this.parseString(string, string2), stringComparator);
    }

    public TreePath findPath(String string, Operator.StringComparator stringComparator) {
        return this.findPath(this.parseString(string), stringComparator);
    }

    public TreePath findPath(String string, String string2, boolean bl, boolean bl2) {
        return this.findPath(this.parseString(string, string2), bl, bl2);
    }

    public TreePath findPath(String string, String string2) {
        return this.findPath(this.parseString(string, string2));
    }

    public TreePath findPath(String string) {
        return this.findPath(this.parseString(string));
    }

    public void doCollapsePath(TreePath treePath) {
        if (treePath != null) {
            this.output.printLine("Collapsing \"" + treePath.toString() + "\" path");
            this.output.printGolden("Collapsing path");
            this.driver.collapseItem(this, this.getRowForPath(treePath));
            if (this.getVerification()) {
                this.waitCollapsed(treePath);
            }
        } else {
            throw new NoSuchPathException();
        }
    }

    public void doCollapseRow(int n) {
        this.output.printLine("Collapsing \"" + Integer.toString(n) + "\" row");
        this.output.printGolden("Collapsing path");
        this.driver.collapseItem(this, n);
        if (this.getVerification()) {
            this.waitCollapsed(n);
        }
    }

    public void selectPath(final TreePath treePath) {
        if (treePath != null) {
            this.output.printLine("Selecting \"" + treePath.toString() + "\" path");
            this.output.printGolden("Selecting path");
            this.scrollToPath(treePath);
            this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                public Object launch() {
                    JTreeOperator.this.driver.selectItem(JTreeOperator.this, JTreeOperator.this.getRowForPath(treePath));
                    return null;
                }
            });
            if (this.getVerification()) {
                this.waitSelected(treePath);
            }
        } else {
            throw new NoSuchPathException();
        }
    }

    public void selectRow(int n) {
        this.output.printLine("Collapsing \"" + Integer.toString(n) + "\" row");
        this.output.printGolden("Collapsing path");
        this.driver.selectItem(this, n);
        if (this.getVerification()) {
            this.waitSelected(n);
        }
    }

    public void selectPaths(TreePath[] treePathArray) {
        this.output.printLine("Selecting paths:");
        int[] nArray = new int[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            this.output.printLine("    " + treePathArray[i].toString());
            nArray[i] = this.getRowForPath(treePathArray[i]);
        }
        this.output.printGolden("Selecting paths");
        this.driver.selectItems(this, nArray);
        if (this.getVerification()) {
            this.waitSelected(treePathArray);
        }
    }

    public Point getPointToClick(TreePath treePath) {
        if (treePath != null) {
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                return new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0));
            }
            throw new NoSuchPathException(treePath);
        }
        throw new NoSuchPathException();
    }

    public Point getPointToClick(int n) {
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null) {
            return new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0));
        }
        throw new NoSuchPathException(n);
    }

    public void clickOnPath(TreePath treePath, int n, int n2, int n3) {
        if (treePath != null) {
            this.output.printLine("Click on \"" + treePath.toString() + "\" path");
            this.output.printGolden("Click on path");
            this.makeComponentVisible();
            if (treePath.getParentPath() != null) {
                this.expandPath(treePath.getParentPath());
            }
        } else {
            throw new NoSuchPathException();
        }
        this.makeVisible(treePath);
        this.scrollToPath(treePath);
        Point point = this.getPointToClick(treePath);
        this.clickMouse((int)point.getX(), (int)point.getY(), n, n2, n3);
    }

    public void clickOnPath(TreePath treePath, int n, int n2) {
        this.clickOnPath(treePath, n, n2, 0);
    }

    public void clickOnPath(TreePath treePath, int n) {
        this.clickOnPath(treePath, n, JTreeOperator.getDefaultMouseButton());
    }

    public void clickOnPath(TreePath treePath) {
        this.clickOnPath(treePath, 1);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] treePathArray, int n) {
        int n2;
        if (treePathArray.length == 1) {
            this.output.printLine("Call popup on \"" + treePathArray[0].toString() + "\" path");
            this.output.printGolden("Call popup on path");
        } else {
            this.output.printLine("Call popup on some pathes:");
            for (n2 = 0; n2 < treePathArray.length; ++n2) {
                this.output.printLine("    " + treePathArray[n2].toString());
            }
            this.output.printGolden("Call popup on paths");
        }
        this.makeComponentVisible();
        for (n2 = 0; n2 < treePathArray.length; ++n2) {
            if (treePathArray[n2].getParentPath() == null) continue;
            this.expandPath(treePathArray[n2].getParentPath());
        }
        this.selectPaths(treePathArray);
        this.scrollToPath(treePathArray[treePathArray.length - 1]);
        Point point = this.getPointToClick(treePathArray[treePathArray.length - 1]);
        return JPopupMenuOperator.callPopup(this, (int)point.getX(), (int)point.getY(), n);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] treePathArray) {
        return this.callPopupOnPaths(treePathArray, JTreeOperator.getPopupMouseButton());
    }

    public JPopupMenu callPopupOnPath(TreePath treePath, int n) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            return this.callPopupOnPaths(treePathArray, n);
        }
        throw new NoSuchPathException();
    }

    public JPopupMenu callPopupOnPath(TreePath treePath) {
        return this.callPopupOnPath(treePath, JTreeOperator.getPopupMouseButton());
    }

    public void scrollToPath(TreePath treePath) {
        Rectangle rectangle;
        JScrollPaneOperator jScrollPaneOperator;
        if (treePath != null) {
            this.output.printTrace("Scroll JTree to path \"" + treePath.toString() + "\"\n    : " + this.toStringSource());
            this.output.printGolden("Scroll JTree to path \"" + treePath.toString() + "\"");
            this.makeComponentVisible();
            JScrollPane jScrollPane = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
            if (jScrollPane == null) {
                return;
            }
            jScrollPaneOperator = new JScrollPaneOperator(jScrollPane);
            jScrollPaneOperator.copyEnvironment(this);
            jScrollPaneOperator.setVisualizer(new EmptyVisualizer());
            rectangle = this.getPathBounds(treePath);
            if (rectangle == null) {
                throw new NoSuchPathException(treePath);
            }
        } else {
            throw new NoSuchPathException();
        }
        jScrollPaneOperator.scrollToComponentRectangle(this.getSource(), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public void scrollToRow(int n) {
        this.scrollToPath(this.getPathForRow(n));
    }

    public void clickForEdit(TreePath treePath) {
        this.driver.startEditing(this, this.getRowForPath(treePath), this.timeouts.create("JTreeOperator.WaitEditingTimeout"));
    }

    public Component getRenderedComponent(TreePath treePath, boolean bl, boolean bl2, boolean bl3) {
        if (treePath != null) {
            return this.getCellRenderer().getTreeCellRendererComponent((JTree)this.getSource(), treePath.getLastPathComponent(), bl, bl2, this.getModel().isLeaf(treePath.getLastPathComponent()), this.getRowForPath(treePath), bl3);
        }
        throw new NoSuchPathException();
    }

    public Component getRenderedComponent(TreePath treePath) {
        return this.getRenderedComponent(treePath, this.isPathSelected(treePath), this.isExpanded(treePath), false);
    }

    public void changePathText(TreePath treePath, String string) {
        this.changePathObject(treePath, string);
    }

    public void changePathObject(TreePath treePath, Object object) {
        this.scrollToPath(treePath);
        this.driver.editItem(this, this.getRowForPath(treePath), object, this.timeouts.create("JTreeOperator.WaitEditingTimeout"));
    }

    public void waitExpanded(final TreePath treePath) {
        if (treePath == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + treePath.toString() + "\" path to be expanded in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + treePath.toString() + "\" path to be expanded");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTreeOperator.this.isExpanded(treePath);
            }

            public String getDescription() {
                return "Has \"" + treePath.toString() + "\" path expanded";
            }
        });
    }

    public void waitExpanded(final int n) {
        this.getOutput().printLine("Wait " + Integer.toString(n) + "'th row to be expanded in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(n) + "'th row to be expanded");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTreeOperator.this.isExpanded(n);
            }

            public String getDescription() {
                return "Has " + Integer.toString(n) + "'th row expanded";
            }
        });
    }

    public void waitCollapsed(final TreePath treePath) {
        if (treePath == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + treePath.toString() + "\" path to be collapsed in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + treePath.toString() + "\" path to be collapsed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTreeOperator.this.isCollapsed(treePath);
            }

            public String getDescription() {
                return "Has \"" + treePath.toString() + "\" path collapsed";
            }
        });
    }

    public void waitCollapsed(final int n) {
        this.getOutput().printLine("Wait " + Integer.toString(n) + "'th row to be collapsed in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(n) + "'th row to be collapsed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTreeOperator.this.isCollapsed(n);
            }

            public String getDescription() {
                return "Has " + Integer.toString(n) + "'th row collapsed";
            }
        });
    }

    public void waitVisible(final TreePath treePath) {
        if (treePath == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + treePath.toString() + "\" path to be visible in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + treePath.toString() + "\" path to be visible");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTreeOperator.this.isVisible(treePath);
            }

            public String getDescription() {
                return "Has \"" + treePath.toString() + "\" path visible";
            }
        });
    }

    public void waitSelected(final TreePath[] treePathArray) {
        this.getOutput().printLine("Wait right selection in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait right selection");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                TreePath[] treePathArray2 = JTreeOperator.this.getSelectionModel().getSelectionPaths();
                if (treePathArray2 != null) {
                    for (int i = 0; i < treePathArray2.length; ++i) {
                        if (treePathArray2[i].equals(treePathArray[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Has right selection";
            }
        });
    }

    public void waitSelected(TreePath treePath) {
        this.waitSelected(new TreePath[]{treePath});
    }

    public void waitSelected(int[] nArray) {
        TreePath[] treePathArray = new TreePath[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            treePathArray[i] = this.getPathForRow(nArray[i]);
        }
        this.waitSelected(treePathArray);
    }

    public void waitSelected(int n) {
        this.waitSelected(new int[]{n});
    }

    public void waitRow(String string, int n) {
        this.getOutput().printLine("Wait \"" + string + "\" text in " + Integer.toString(n) + "'th line in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + " \" text in " + Integer.toString(n) + "'th line");
        this.waitState(new JTreeByItemFinder(string, n, this.getComparator()));
    }

    public Object chooseSubnode(Object object, String string, int n, Operator.StringComparator stringComparator) {
        int n2 = -1;
        for (int i = 0; i < this.getChildCount(object); ++i) {
            Object object2;
            try {
                object2 = this.getChild(object, i);
            }
            catch (JemmyException jemmyException) {
                if (jemmyException.getInnerThrowable() instanceof IndexOutOfBoundsException) {
                    return null;
                }
                throw jemmyException;
            }
            if (!stringComparator.equals(object2.toString(), string) || ++n2 != n) continue;
            return object2;
        }
        return null;
    }

    public Object chooseSubnode(Object object, String string, Operator.StringComparator stringComparator) {
        return this.chooseSubnode(object, string, 0, stringComparator);
    }

    public Object chooseSubnode(Object object, String string, int n) {
        return this.chooseSubnode(object, string, n, this.getComparator());
    }

    public Object chooseSubnode(Object object, String string) {
        return this.chooseSubnode(object, string, 0, this.getComparator());
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        Object object = ((JTree)this.getSource()).getModel().getRoot();
        if (object.toString() != null) {
            hashtable.put(ROOT_DPROP, object.toString());
        }
        this.addChildrenToDump(hashtable, NODE_PREFIX_DPROP, object, new TreePath(object));
        int n = ((JTree)this.getSource()).getMinSelectionRow();
        if (n >= 0) {
            Object object2 = ((JTree)this.getSource()).getPathForRow(n).getLastPathComponent();
            hashtable.put(SELECTION_FIRST_DPROP, object2.toString());
            int n2 = ((JTree)this.getSource()).getMaxSelectionRow();
            if (n2 > n) {
                Object object3 = ((JTree)this.getSource()).getPathForRow(n2).getLastPathComponent();
                hashtable.put(SELECTION_LAST_DPROP, object3.toString());
            }
        }
        return hashtable;
    }

    public void addSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("addSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionInterval(n, n2);
            }
        });
    }

    public void addSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("addSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionPath(treePath);
            }
        });
    }

    public void addSelectionPaths(final TreePath[] treePathArray) {
        this.runMapping(new Operator.MapVoidAction("addSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionPaths(treePathArray);
            }
        });
    }

    public void addSelectionRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("addSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionRow(n);
            }
        });
    }

    public void addSelectionRows(final int[] nArray) {
        this.runMapping(new Operator.MapVoidAction("addSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionRows(nArray);
            }
        });
    }

    public void addTreeExpansionListener(final TreeExpansionListener treeExpansionListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeExpansionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeExpansionListener(treeExpansionListener);
            }
        });
    }

    public void addTreeSelectionListener(final TreeSelectionListener treeSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeSelectionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeSelectionListener(treeSelectionListener);
            }
        });
    }

    public void addTreeWillExpandListener(final TreeWillExpandListener treeWillExpandListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeWillExpandListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeWillExpandListener(treeWillExpandListener);
            }
        });
    }

    public void cancelEditing() {
        this.runMapping(new Operator.MapVoidAction("cancelEditing"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).cancelEditing();
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void collapsePath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("collapsePath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).collapsePath(treePath);
            }
        });
    }

    public void collapseRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("collapseRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).collapseRow(n);
            }
        });
    }

    public String convertValueToText(final Object object, final boolean bl, final boolean bl2, final boolean bl3, final int n, final boolean bl4) {
        return (String)this.runMapping(new Operator.MapAction("convertValueToText"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).convertValueToText(object, bl, bl2, bl3, n, bl4);
            }
        });
    }

    public void expandPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("expandPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).expandPath(treePath);
            }
        });
    }

    public void expandRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("expandRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).expandRow(n);
            }
        });
    }

    public void fireTreeCollapsed(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeCollapsed"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).fireTreeCollapsed(treePath);
            }
        });
    }

    public void fireTreeExpanded(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeExpanded"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).fireTreeExpanded(treePath);
            }
        });
    }

    public void fireTreeWillCollapse(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeWillCollapse"){

            public void map() throws ExpandVetoException {
                ((JTree)JTreeOperator.this.getSource()).fireTreeWillCollapse(treePath);
            }
        });
    }

    public void fireTreeWillExpand(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeWillExpand"){

            public void map() throws ExpandVetoException {
                ((JTree)JTreeOperator.this.getSource()).fireTreeWillExpand(treePath);
            }
        });
    }

    public TreeCellEditor getCellEditor() {
        return (TreeCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getCellEditor();
            }
        });
    }

    public TreeCellRenderer getCellRenderer() {
        return (TreeCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getCellRenderer();
            }
        });
    }

    public TreePath getClosestPathForLocation(final int n, final int n2) {
        return (TreePath)this.runMapping(new Operator.MapAction("getClosestPathForLocation"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getClosestPathForLocation(n, n2);
            }
        });
    }

    public int getClosestRowForLocation(final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getClosestRowForLocation"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getClosestRowForLocation(n, n2);
            }
        });
    }

    public TreePath getEditingPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getEditingPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getEditingPath();
            }
        });
    }

    public Enumeration getExpandedDescendants(final TreePath treePath) {
        return (Enumeration)this.runMapping(new Operator.MapAction("getExpandedDescendants"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getExpandedDescendants(treePath);
            }
        });
    }

    public boolean getInvokesStopCellEditing() {
        return this.runMapping(new Operator.MapBooleanAction("getInvokesStopCellEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getInvokesStopCellEditing();
            }
        });
    }

    public Object getLastSelectedPathComponent() {
        return this.runMapping(new Operator.MapAction("getLastSelectedPathComponent"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getLastSelectedPathComponent();
            }
        });
    }

    public TreePath getLeadSelectionPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getLeadSelectionPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getLeadSelectionPath();
            }
        });
    }

    public int getLeadSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getLeadSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getLeadSelectionRow();
            }
        });
    }

    public int getMaxSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getMaxSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getMaxSelectionRow();
            }
        });
    }

    public int getMinSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getMinSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getMinSelectionRow();
            }
        });
    }

    public TreeModel getModel() {
        return (TreeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getModel();
            }
        });
    }

    public Rectangle getPathBounds(final TreePath treePath) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getPathBounds"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathBounds(treePath);
            }
        });
    }

    public TreePath getPathForLocation(final int n, final int n2) {
        return (TreePath)this.runMapping(new Operator.MapAction("getPathForLocation"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathForLocation(n, n2);
            }
        });
    }

    public TreePath getPathForRow(final int n) {
        return (TreePath)this.runMapping(new Operator.MapAction("getPathForRow"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathForRow(n);
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public Rectangle getRowBounds(final int n) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getRowBounds"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowBounds(n);
            }
        });
    }

    public int getRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getRowCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowCount();
            }
        });
    }

    public int getRowForLocation(final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getRowForLocation"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowForLocation(n, n2);
            }
        });
    }

    public int getRowForPath(final TreePath treePath) {
        return this.runMapping(new Operator.MapIntegerAction("getRowForPath"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowForPath(treePath);
            }
        });
    }

    public int getRowHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getRowHeight"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowHeight();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableBlockIncrement(rectangle, n, n2);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableUnitIncrement(rectangle, n, n2);
            }
        });
    }

    public boolean getScrollsOnExpand() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollsOnExpand"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollsOnExpand();
            }
        });
    }

    public int getSelectionCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionCount();
            }
        });
    }

    public TreeSelectionModel getSelectionModel() {
        return (TreeSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public TreePath getSelectionPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getSelectionPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionPath();
            }
        });
    }

    public TreePath[] getSelectionPaths() {
        return (TreePath[])this.runMapping(new Operator.MapAction("getSelectionPaths"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionPaths();
            }
        });
    }

    public int[] getSelectionRows() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectionRows"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionRows();
            }
        });
    }

    public boolean getShowsRootHandles() {
        return this.runMapping(new Operator.MapBooleanAction("getShowsRootHandles"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getShowsRootHandles();
            }
        });
    }

    public TreeUI getUI() {
        return (TreeUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getUI();
            }
        });
    }

    public int getVisibleRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleRowCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getVisibleRowCount();
            }
        });
    }

    public boolean hasBeenExpanded(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("hasBeenExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).hasBeenExpanded(treePath);
            }
        });
    }

    public boolean isCollapsed(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isCollapsed"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isCollapsed(n);
            }
        });
    }

    public boolean isCollapsed(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isCollapsed"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isCollapsed(treePath);
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isEditable();
            }
        });
    }

    public boolean isEditing() {
        return this.runMapping(new Operator.MapBooleanAction("isEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isEditing();
            }
        });
    }

    public boolean isExpanded(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isExpanded(n);
            }
        });
    }

    public boolean isExpanded(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isExpanded(treePath);
            }
        });
    }

    public boolean isFixedRowHeight() {
        return this.runMapping(new Operator.MapBooleanAction("isFixedRowHeight"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isFixedRowHeight();
            }
        });
    }

    public boolean isLargeModel() {
        return this.runMapping(new Operator.MapBooleanAction("isLargeModel"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isLargeModel();
            }
        });
    }

    public boolean isPathEditable(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isPathEditable"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isPathEditable(treePath);
            }
        });
    }

    public boolean isPathSelected(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isPathSelected"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isPathSelected(treePath);
            }
        });
    }

    public boolean isRootVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isRootVisible"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isRootVisible();
            }
        });
    }

    public boolean isRowSelected(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isRowSelected"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isRowSelected(n);
            }
        });
    }

    public boolean isSelectionEmpty() {
        return this.runMapping(new Operator.MapBooleanAction("isSelectionEmpty"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isSelectionEmpty();
            }
        });
    }

    public boolean isVisible(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isVisible"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isVisible(treePath);
            }
        });
    }

    public void makeVisible(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("makeVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).makeVisible(treePath);
            }
        });
    }

    public void removeSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionInterval(n, n2);
            }
        });
    }

    public void removeSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionPath(treePath);
            }
        });
    }

    public void removeSelectionPaths(final TreePath[] treePathArray) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionPaths(treePathArray);
            }
        });
    }

    public void removeSelectionRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionRow(n);
            }
        });
    }

    public void removeSelectionRows(final int[] nArray) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionRows(nArray);
            }
        });
    }

    public void removeTreeExpansionListener(final TreeExpansionListener treeExpansionListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeExpansionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeExpansionListener(treeExpansionListener);
            }
        });
    }

    public void removeTreeSelectionListener(final TreeSelectionListener treeSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeSelectionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeSelectionListener(treeSelectionListener);
            }
        });
    }

    public void removeTreeWillExpandListener(final TreeWillExpandListener treeWillExpandListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeWillExpandListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeWillExpandListener(treeWillExpandListener);
            }
        });
    }

    public void scrollPathToVisible(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("scrollPathToVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).scrollPathToVisible(treePath);
            }
        });
    }

    public void scrollRowToVisible(final int n) {
        this.runMapping(new Operator.MapVoidAction("scrollRowToVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).scrollRowToVisible(n);
            }
        });
    }

    public void setCellEditor(final TreeCellEditor treeCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setCellEditor"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setCellEditor(treeCellEditor);
            }
        });
    }

    public void setCellRenderer(final TreeCellRenderer treeCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setCellRenderer"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setCellRenderer(treeCellRenderer);
            }
        });
    }

    public void setEditable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setEditable(bl);
            }
        });
    }

    public void setInvokesStopCellEditing(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setInvokesStopCellEditing"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setInvokesStopCellEditing(bl);
            }
        });
    }

    public void setLargeModel(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setLargeModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setLargeModel(bl);
            }
        });
    }

    public void setModel(final TreeModel treeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setModel(treeModel);
            }
        });
    }

    public void setRootVisible(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setRootVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setRootVisible(bl);
            }
        });
    }

    public void setRowHeight(final int n) {
        this.runMapping(new Operator.MapVoidAction("setRowHeight"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setRowHeight(n);
            }
        });
    }

    public void setScrollsOnExpand(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setScrollsOnExpand"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setScrollsOnExpand(bl);
            }
        });
    }

    public void setSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionInterval(n, n2);
            }
        });
    }

    public void setSelectionModel(final TreeSelectionModel treeSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionModel(treeSelectionModel);
            }
        });
    }

    public void setSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("setSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionPath(treePath);
            }
        });
    }

    public void setSelectionPaths(final TreePath[] treePathArray) {
        this.runMapping(new Operator.MapVoidAction("setSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionPaths(treePathArray);
            }
        });
    }

    public void setSelectionRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionRow(n);
            }
        });
    }

    public void setSelectionRows(final int[] nArray) {
        this.runMapping(new Operator.MapVoidAction("setSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionRows(nArray);
            }
        });
    }

    public void setShowsRootHandles(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setShowsRootHandles"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setShowsRootHandles(bl);
            }
        });
    }

    public void setUI(final TreeUI treeUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setUI(treeUI);
            }
        });
    }

    public void setVisibleRowCount(final int n) {
        this.runMapping(new Operator.MapVoidAction("setVisibleRowCount"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setVisibleRowCount(n);
            }
        });
    }

    public void startEditingAtPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("startEditingAtPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).startEditingAtPath(treePath);
            }
        });
    }

    public boolean stopEditing() {
        return this.runMapping(new Operator.MapBooleanAction("stopEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).stopEditing();
            }
        });
    }

    public void treeDidChange() {
        this.runMapping(new Operator.MapVoidAction("treeDidChange"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).treeDidChange();
            }
        });
    }

    private TreePath findPathPrimitive(TreePath treePath, TreePathChooser treePathChooser, Waiter waiter) {
        if (!this.isExpanded(treePath)) {
            if (!this.isPathSelected(treePath)) {
                this.clickOnPath(treePath);
            }
            this.expandPath(treePath);
        }
        Object[] objectArray = new Object[]{treePathChooser, treePath};
        Object[] objectArray2 = null;
        try {
            objectArray2 = (Object[])waiter.waitAction(objectArray);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
            return null;
        }
        TreePath treePath2 = (TreePath)objectArray2[0];
        boolean bl = (Boolean)objectArray2[1];
        if (bl) {
            return treePath2;
        }
        return this.findPathPrimitive(treePath2, treePathChooser, waiter);
    }

    private String[] addChildrenToDump(Hashtable hashtable, String string, Object object, TreePath treePath) {
        if (((JTree)this.getSource()).isExpanded(treePath)) {
            Object[] objectArray = this.getChildren(object);
            String[] stringArray = this.addToDump(hashtable, string, objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.addChildrenToDump(hashtable, stringArray[i], objectArray[i], treePath.pathByAddingChild(objectArray[i]));
            }
            return stringArray;
        }
        return new String[0];
    }

    private static String pathToString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + ", ";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 2);
        }
        return "[ " + string + " ]";
    }

    static {
        Timeouts.initDefault("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitNodeCollapsedTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitAfterNodeExpandedTimeout", 0L);
        Timeouts.initDefault("JTreeOperator.WaitNextNodeTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.BeforeEditTimeout", 1000L);
        Timeouts.initDefault("JTreeOperator.WaitEditingTimeout", 60000L);
    }

    public static class JTreeByItemFinder
    implements ComponentChooser {
        String label;
        int rowIndex;
        Operator.StringComparator comparator;

        public JTreeByItemFinder(String string, int n, Operator.StringComparator stringComparator) {
            this.label = string;
            this.rowIndex = n;
            this.comparator = stringComparator;
        }

        public JTreeByItemFinder(String string, int n) {
            this(string, n, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JTree) {
                if (this.label == null) {
                    return true;
                }
                if (((JTree)component).getRowCount() > this.rowIndex) {
                    Object object;
                    int n = this.rowIndex;
                    if (n == -1) {
                        object = ((JTree)component).getSelectionRows();
                        if (object != null && ((int[])object).length > 0) {
                            n = object[0];
                        } else {
                            return false;
                        }
                    }
                    if ((object = (Object)((JTree)component).getPathForRow(n)) != null) {
                        return this.comparator.equals(object.getPathComponent(object.getPathCount() - 1).toString(), this.label);
                    }
                }
            }
            return false;
        }

        public String getDescription() {
            return "JTree with text \"" + this.label + "\" in " + new Integer(this.rowIndex).toString() + "'th row";
        }
    }

    public static class JTreeFinder
    extends Operator.Finder {
        public JTreeFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JTree == null ? (class$javax$swing$JTree = JTreeOperator.class$("javax.swing.JTree")) : class$javax$swing$JTree, componentChooser);
        }

        public JTreeFinder() {
            super(class$javax$swing$JTree == null ? (class$javax$swing$JTree = JTreeOperator.class$("javax.swing.JTree")) : class$javax$swing$JTree);
        }
    }

    private class ByRenderedComponentTreeRowChooser
    implements TreeRowChooser {
        ComponentChooser chooser;

        public ByRenderedComponentTreeRowChooser(ComponentChooser componentChooser) {
            this.chooser = componentChooser;
        }

        public boolean checkRow(JTreeOperator jTreeOperator, int n) {
            return this.chooser.checkComponent(jTreeOperator.getRenderedComponent(jTreeOperator.getPathForRow(n)));
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private class BySubStringTreeRowChooser
    implements TreeRowChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringTreeRowChooser(String string, Operator.StringComparator stringComparator) {
            this.subString = string;
            this.comparator = stringComparator;
        }

        public boolean checkRow(JTreeOperator jTreeOperator, int n) {
            return this.comparator.equals(jTreeOperator.getPathForRow(n).getLastPathComponent().toString(), this.subString);
        }

        public String getDescription() {
            return "Row containing \"" + this.subString + "\" string";
        }
    }

    class StringArrayPathChooser
    implements TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;

        StringArrayPathChooser(String[] stringArray, int[] nArray, Operator.StringComparator stringComparator) {
            this.arr = stringArray;
            this.comparator = stringComparator;
            this.indices = nArray;
        }

        public boolean checkPath(TreePath treePath, int n) {
            return treePath.getPathCount() - 1 == this.arr.length && this.hasAsParent(treePath, n);
        }

        public boolean hasAsParent(TreePath treePath, int n) {
            Object[] objectArray = treePath.getPath();
            for (int i = 1; i < objectArray.length; ++i) {
                if (this.arr.length < treePath.getPathCount() - 1) {
                    return false;
                }
                Object object = this.indices.length >= treePath.getPathCount() - 1 ? JTreeOperator.this.chooseSubnode(objectArray[i - 1], this.arr[i - 1], this.indices[i - 1], this.comparator) : JTreeOperator.this.chooseSubnode(objectArray[i - 1], this.arr[i - 1], this.comparator);
                if (object == objectArray[i]) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return JTreeOperator.pathToString(this.arr);
        }
    }

    public static interface TreePathChooser {
        public boolean checkPath(TreePath var1, int var2);

        public boolean hasAsParent(TreePath var1, int var2);

        public String getDescription();
    }

    public class NoSuchPathException
    extends JemmyInputException {
        public NoSuchPathException() {
            super("Unknown/null/invalid tree path.", (Component)null);
        }

        public NoSuchPathException(String[] stringArray) {
            super("No such path as \"" + JTreeOperator.pathToString(stringArray) + "\"", JTreeOperator.this.getSource());
        }

        public NoSuchPathException(int n) {
            super("Tree does not contain " + n + "'th line", JTreeOperator.this.getSource());
        }

        public NoSuchPathException(TreePath treePath) {
            super("No such path as \"" + treePath.toString() + "\"", JTreeOperator.this.getSource());
        }
    }

    public static interface TreeRowChooser {
        public boolean checkRow(JTreeOperator var1, int var2);

        public String getDescription();
    }
}

