/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JTextComponentOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    public static final String SELECTED_TEXT_DPROP = "Selected text";
    public static final String IS_EDITABLE_DPROP = "Editable";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long BETWEEN_KEYS_TIMEOUT = 0L;
    private static final long CHANGE_CARET_POSITION_TIMEOUT = 60000L;
    private static final long TYPE_TEXT_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    protected int modifiersPressed = 0;
    private TextDriver driver = DriverManager.getTextDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;

    public JTextComponentOperator(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    public JTextComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JTextComponent)containerOperator.waitSubComponent(new JTextComponentFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JTextComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JTextComponentOperator(ContainerOperator containerOperator, String string, int n) {
        this((JTextComponent)JTextComponentOperator.waitComponent(containerOperator, (ComponentChooser)new JTextComponentByTextFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public JTextComponentOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JTextComponentOperator(ContainerOperator containerOperator, int n) {
        this((JTextComponent)JTextComponentOperator.waitComponent(containerOperator, (ComponentChooser)new JTextComponentFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JTextComponentOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JTextComponent findJTextComponent(Container container, ComponentChooser componentChooser, int n) {
        return (JTextComponent)JTextComponentOperator.findComponent(container, new JTextComponentFinder(componentChooser), n);
    }

    public static JTextComponent findJTextComponent(Container container, ComponentChooser componentChooser) {
        return JTextComponentOperator.findJTextComponent(container, componentChooser, 0);
    }

    public static JTextComponent findJTextComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return JTextComponentOperator.findJTextComponent(container, new JTextComponentByTextFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static JTextComponent findJTextComponent(Container container, String string, boolean bl, boolean bl2) {
        return JTextComponentOperator.findJTextComponent(container, string, bl, bl2, 0);
    }

    public static JTextComponent waitJTextComponent(Container container, ComponentChooser componentChooser, int n) {
        return (JTextComponent)JTextComponentOperator.waitComponent(container, (ComponentChooser)new JTextComponentFinder(componentChooser), n);
    }

    public static JTextComponent waitJTextComponent(Container container, ComponentChooser componentChooser) {
        return JTextComponentOperator.waitJTextComponent(container, componentChooser, 0);
    }

    public static JTextComponent waitJTextComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return JTextComponentOperator.waitJTextComponent(container, new JTextComponentByTextFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static JTextComponent waitJTextComponent(Container container, String string, boolean bl, boolean bl2) {
        return JTextComponentOperator.waitJTextComponent(container, string, bl, bl2, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.timeouts.setTimeout("ComponentOperator.PushKeyTimeout", this.timeouts.getTimeout("JTextComponentOperator.PushKeyTimeout"));
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (TextDriver)DriverManager.getDriver("drivers.text", this.getClass(), operator.getProperties());
    }

    public int getPositionByText(String string, TextChooser textChooser, int n) {
        this.output.printLine("Find " + textChooser.getDescription() + "\"" + string + "\" text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Find " + textChooser.getDescription() + "\"" + string + "\" text in text component");
        String string2 = this.getDisplayedText();
        Document document = this.getDocument();
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string2.indexOf(string, n2)) >= 0) {
            if (textChooser.checkPosition(document, n2)) {
                if (n3 == n) {
                    return n2;
                }
                ++n3;
            }
            n2 += string.length();
        }
        return -1;
    }

    public int getPositionByText(String string, TextChooser textChooser) {
        return this.getPositionByText(string, textChooser, 0);
    }

    public int getPositionByText(String string, int n) {
        return this.getPositionByText(string, new TextChooser(){

            public boolean checkPosition(Document document, int n) {
                return true;
            }

            public String getDescription() {
                return "any";
            }
        }, n);
    }

    public int getPositionByText(String string) {
        return this.getPositionByText(string, 0);
    }

    public void enterText(final String string) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JTextComponentOperator.this.driver.enterText(JTextComponentOperator.this, string);
                return null;
            }

            public String getDescription() {
                return "Text entering";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void changeCaretPosition(final int n) {
        this.output.printLine("Change caret position to " + Integer.toString(n));
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JTextComponentOperator.this.driver.changeCaretPosition(JTextComponentOperator.this, n);
                return null;
            }

            public String getDescription() {
                return "Caret moving";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.ChangeCaretPositionTimeout"));
        if (this.getVerification()) {
            this.waitCaretPosition(n);
        }
    }

    public void changeCaretPosition(String string, int n, boolean bl) {
        this.output.printLine("Put caret " + (bl ? "before" : "after") + " " + Integer.toString(n) + "'th instance of \"" + string + "\" text");
        this.makeComponentVisible();
        int n2 = this.getPositionByText(string, n);
        if (n2 == -1) {
            throw new NoSuchTextException(string);
        }
        n2 = bl ? n2 : n2 + string.length();
        this.changeCaretPosition(n2);
    }

    public void changeCaretPosition(String string, boolean bl) {
        this.changeCaretPosition(string, 0, bl);
    }

    public void typeText(final String string, final int n) {
        this.output.printLine("Typing text \"" + string + "\" from " + Integer.toString(n) + " position " + "in text component\n    : " + this.toStringSource());
        this.output.printGolden("Typing text \"" + string + "\" in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JTextComponentOperator.this.driver.typeText(JTextComponentOperator.this, string, n);
                return null;
            }

            public String getDescription() {
                return "Text typing";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
        if (this.getVerification()) {
            this.waitText(string, -1);
        }
    }

    public void typeText(String string) {
        this.typeText(string, this.getCaretPosition());
    }

    public void selectText(final int n, final int n2) {
        this.output.printLine("Select text from " + Integer.toString(n) + " to " + Integer.toString(n2) + " in text component\n    : " + this.toStringSource());
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JTextComponentOperator.this.driver.selectText(JTextComponentOperator.this, n, n2);
                return null;
            }

            public String getDescription() {
                return "Text selecting";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void selectText(String string, int n) {
        this.output.printLine("Select " + Integer.toString(n) + "'th instance of \"" + string + "\" text in component\n    : " + this.toStringSource());
        this.makeComponentVisible();
        int n2 = this.getPositionByText(string, n);
        if (n2 == -1) {
            throw new NoSuchTextException(string);
        }
        this.selectText(n2, n2 + string.length());
    }

    public void selectText(String string) {
        this.selectText(string, 0);
    }

    public void clearText() {
        this.output.printLine("Clearing text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Clearing text in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JTextComponentOperator.this.driver.clearText(JTextComponentOperator.this);
                return null;
            }

            public String getDescription() {
                return "Text clearing";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void scrollToPosition(int n) {
        this.output.printTrace("Scroll JTextComponent to " + Integer.toString(n) + " position\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JTextComponent to " + Integer.toString(n) + " position");
        this.makeComponentVisible();
        JScrollPane jScrollPane = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (jScrollPane == null) {
            return;
        }
        JScrollPaneOperator jScrollPaneOperator = new JScrollPaneOperator(jScrollPane);
        jScrollPaneOperator.copyEnvironment(this);
        jScrollPaneOperator.setVisualizer(new EmptyVisualizer());
        Rectangle rectangle = this.modelToView(n);
        jScrollPaneOperator.scrollToComponentRectangle(this.getSource(), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public String getDisplayedText() {
        try {
            Document document = this.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new JemmyException("Exception during text operation with\n    : " + this.toStringSource(), badLocationException);
        }
    }

    public void waitText(final String string, final int n) {
        this.getOutput().printLine("Wait \"" + string + "\" text starting from " + Integer.toString(n) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" text starting from " + Integer.toString(n) + " position");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                String string2 = JTextComponentOperator.this.getDisplayedText();
                if (n >= 0) {
                    if (n + string.length() <= string2.length()) {
                        return string2.substring(n, n + string.length()).equals(string);
                    }
                    return false;
                }
                return string2.indexOf(string) >= 0;
            }

            public String getDescription() {
                return "Has \"" + string + "\" text starting from " + Integer.toString(n) + " position";
            }
        });
    }

    public void waitText(String string) {
        this.getOutput().printLine("Wait \"" + string + "\" text in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" text");
        this.waitState(new JTextComponentByTextFinder(string, this.getComparator()));
    }

    public void waitCaretPosition(final int n) {
        this.getOutput().printLine("Wait caret to be at \"" + Integer.toString(n) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait caret to be at \"" + Integer.toString(n) + " position");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JTextComponentOperator.this.getCaretPosition() == n;
            }

            public String getDescription() {
                return "Has caret at " + Integer.toString(n) + " position";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(TEXT_DPROP, ((JTextComponent)this.getSource()).getText());
        if (((JTextComponent)this.getSource()).getSelectedText() != null && !((JTextComponent)this.getSource()).getSelectedText().equals("")) {
            hashtable.put(SELECTED_TEXT_DPROP, ((JTextComponent)this.getSource()).getSelectedText());
        }
        hashtable.put(IS_EDITABLE_DPROP, ((JTextComponent)this.getSource()).isEditable() ? "true" : "false");
        return hashtable;
    }

    public void addCaretListener(final CaretListener caretListener) {
        this.runMapping(new Operator.MapVoidAction("addCaretListener"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).addCaretListener(caretListener);
            }
        });
    }

    public void copy() {
        this.runMapping(new Operator.MapVoidAction("copy"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).copy();
            }
        });
    }

    public void cut() {
        this.runMapping(new Operator.MapVoidAction("cut"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).cut();
            }
        });
    }

    public javax.swing.Action[] getActions() {
        return (javax.swing.Action[])this.runMapping(new Operator.MapAction("getActions"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getActions();
            }
        });
    }

    public Caret getCaret() {
        return (Caret)this.runMapping(new Operator.MapAction("getCaret"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaret();
            }
        });
    }

    public Color getCaretColor() {
        return (Color)this.runMapping(new Operator.MapAction("getCaretColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaretColor();
            }
        });
    }

    public int getCaretPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getCaretPosition"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaretPosition();
            }
        });
    }

    public Color getDisabledTextColor() {
        return (Color)this.runMapping(new Operator.MapAction("getDisabledTextColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getDisabledTextColor();
            }
        });
    }

    public Document getDocument() {
        return (Document)this.runMapping(new Operator.MapAction("getDocument"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getDocument();
            }
        });
    }

    public char getFocusAccelerator() {
        return this.runMapping(new Operator.MapCharacterAction("getFocusAccelerator"){

            public char map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getFocusAccelerator();
            }
        });
    }

    public Highlighter getHighlighter() {
        return (Highlighter)this.runMapping(new Operator.MapAction("getHighlighter"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getHighlighter();
            }
        });
    }

    public Keymap getKeymap() {
        return (Keymap)this.runMapping(new Operator.MapAction("getKeymap"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getKeymap();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getMargin();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableBlockIncrement(rectangle, n, n2);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableUnitIncrement(rectangle, n, n2);
            }
        });
    }

    public String getSelectedText() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedText"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectedText();
            }
        });
    }

    public Color getSelectedTextColor() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectedTextColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectedTextColor();
            }
        });
    }

    public Color getSelectionColor() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionColor();
            }
        });
    }

    public int getSelectionEnd() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionEnd"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionEnd();
            }
        });
    }

    public int getSelectionStart() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionStart"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionStart();
            }
        });
    }

    public String getText() {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getText();
            }
        });
    }

    public String getText(final int n, final int n2) {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() throws BadLocationException {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getText(n, n2);
            }
        });
    }

    public TextUI getUI() {
        return (TextUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).isEditable();
            }
        });
    }

    public Rectangle modelToView(final int n) {
        return (Rectangle)this.runMapping(new Operator.MapAction("modelToView"){

            public Object map() throws BadLocationException {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).modelToView(n);
            }
        });
    }

    public void moveCaretPosition(final int n) {
        this.runMapping(new Operator.MapVoidAction("moveCaretPosition"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).moveCaretPosition(n);
            }
        });
    }

    public void paste() {
        this.runMapping(new Operator.MapVoidAction("paste"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).paste();
            }
        });
    }

    public void read(final Reader reader, final Object object) {
        this.runMapping(new Operator.MapVoidAction("read"){

            public void map() throws IOException {
                ((JTextComponent)JTextComponentOperator.this.getSource()).read(reader, object);
            }
        });
    }

    public void removeCaretListener(final CaretListener caretListener) {
        this.runMapping(new Operator.MapVoidAction("removeCaretListener"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).removeCaretListener(caretListener);
            }
        });
    }

    public void replaceSelection(final String string) {
        this.runMapping(new Operator.MapVoidAction("replaceSelection"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).replaceSelection(string);
            }
        });
    }

    public void select(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).select(n, n2);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setCaret(final Caret caret) {
        this.runMapping(new Operator.MapVoidAction("setCaret"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaret(caret);
            }
        });
    }

    public void setCaretColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setCaretColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaretColor(color);
            }
        });
    }

    public void setCaretPosition(final int n) {
        this.runMapping(new Operator.MapVoidAction("setCaretPosition"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaretPosition(n);
            }
        });
    }

    public void setDisabledTextColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setDisabledTextColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setDisabledTextColor(color);
            }
        });
    }

    public void setDocument(final Document document) {
        this.runMapping(new Operator.MapVoidAction("setDocument"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setDocument(document);
            }
        });
    }

    public void setEditable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setEditable(bl);
            }
        });
    }

    public void setFocusAccelerator(final char c) {
        this.runMapping(new Operator.MapVoidAction("setFocusAccelerator"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setFocusAccelerator(c);
            }
        });
    }

    public void setHighlighter(final Highlighter highlighter) {
        this.runMapping(new Operator.MapVoidAction("setHighlighter"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setHighlighter(highlighter);
            }
        });
    }

    public void setKeymap(final Keymap keymap) {
        this.runMapping(new Operator.MapVoidAction("setKeymap"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setKeymap(keymap);
            }
        });
    }

    public void setMargin(final Insets insets) {
        this.runMapping(new Operator.MapVoidAction("setMargin"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setMargin(insets);
            }
        });
    }

    public void setSelectedTextColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectedTextColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectedTextColor(color);
            }
        });
    }

    public void setSelectionColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionColor(color);
            }
        });
    }

    public void setSelectionEnd(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionEnd"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionEnd(n);
            }
        });
    }

    public void setSelectionStart(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionStart"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionStart(n);
            }
        });
    }

    public void setText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setText"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setText(string);
            }
        });
    }

    public void setUI(final TextUI textUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setUI(textUI);
            }
        });
    }

    public int viewToModel(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("viewToModel"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).viewToModel(point);
            }
        });
    }

    public void write(final Writer writer) {
        this.runMapping(new Operator.MapVoidAction("write"){

            public void map() throws IOException {
                ((JTextComponent)JTextComponentOperator.this.getSource()).write(writer);
            }
        });
    }

    static {
        Timeouts.initDefault("JTextComponentOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("JTextComponentOperator.BetweenKeysTimeout", 0L);
        Timeouts.initDefault("JTextComponentOperator.ChangeCaretPositionTimeout", 60000L);
        Timeouts.initDefault("JTextComponentOperator.TypeTextTimeout", 60000L);
    }

    public static class JTextComponentFinder
    extends Operator.Finder {
        public JTextComponentFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponentOperator.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent, componentChooser);
        }

        public JTextComponentFinder() {
            super(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponentOperator.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent);
        }
    }

    public static class JTextComponentByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JTextComponentByTextFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public JTextComponentByTextFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JTextComponent && ((JTextComponent)component).getText() != null) {
                return this.comparator.equals(((JTextComponent)component).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JTextComponent with text \"" + this.label + "\"";
        }
    }

    public static interface TextChooser {
        public boolean checkPosition(Document var1, int var2);

        public String getDescription();
    }

    public class NoSuchTextException
    extends JemmyInputException {
        public NoSuchTextException(String string) {
            super("No such text as \"" + string + "\"", JTextComponentOperator.this.getSource());
        }
    }
}

